/*
 * Decompiled with CFR 0.152.
 */
package com.powerutils;

import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ModUtils;
import com.powerutils.PowerUtils;
import com.powerutils.TileConverter;
import com.powerutils.TileFEConverter;
import com.powerutils.TileQEConverter;
import com.powerutils.TileTEConverter;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum BlockPowerConverter implements IMultiTileBlock
{
    power_utilities(TileConverter.class, 0),
    power_utilities_fe(TileFEConverter.class, 1),
    power_utilities_te(TileTEConverter.class, 2),
    power_utilities_qe(TileQEConverter.class, 3);

    public static final ResourceLocation IDENTITY;
    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    private final EnumRarity rarity;
    private TileEntityBlock dummyTe;

    private BlockPowerConverter(Class<? extends TileEntityBlock> teClass, int itemMeta) {
        this(teClass, itemMeta, EnumRarity.UNCOMMON);
    }

    private BlockPowerConverter(Class<? extends TileEntityBlock> teClass, int itemMeta, EnumRarity rarity) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
        this.rarity = rarity;
        GameRegistry.registerTileEntity(teClass, (ResourceLocation)PowerUtils.getIdentifier(this.func_176610_l()));
    }

    public void buildDummies() {
        for (BlockPowerConverter block : BlockPowerConverter.values()) {
            if (block.teClass == null) continue;
            try {
                block.dummyTe = block.teClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String func_176610_l() {
        return this.name();
    }

    public int getId() {
        return this.itemMeta;
    }

    @Nonnull
    public ResourceLocation getIdentifier() {
        return IDENTITY;
    }

    public boolean hasItem() {
        return true;
    }

    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    public boolean hasActive() {
        return false;
    }

    @Nonnull
    public Set<EnumFacing> getSupportedFacings() {
        return ModUtils.allFacings;
    }

    public float getHardness() {
        return 3.0f;
    }

    @Nonnull
    public MultiTileBlock.HarvestTool getHarvestTool() {
        return MultiTileBlock.HarvestTool.Wrench;
    }

    @Nonnull
    public MultiTileBlock.DefaultDrop getDefaultDrop() {
        return MultiTileBlock.DefaultDrop.Machine;
    }

    public boolean allowWrenchRotating() {
        return true;
    }

    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }

    static {
        IDENTITY = PowerUtils.getIdentifier("powerutils");
    }
}

