/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.energy;

import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionCraftingInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;
import thelm.packageddraconic.tile.TileMarkedInjector;

public class EnergyStorageMarkedInjector
implements IEnergyStorage {
    public final TileMarkedInjector tile;
    protected long energy;

    public EnergyStorageMarkedInjector(TileMarkedInjector tile) {
        this.tile = tile;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        this.tile.validateCraftingInventory();
        IFusionCraftingInventory inv = this.tile.getCraftingInventory();
        if (inv != null) {
            long ingCost = inv.getIngredientEnergyCost();
            long storageMaxReceive = ingCost / (long)(300 - this.tile.getPedestalTier() * 80);
            int energyReceived = (int)Math.min(ingCost - this.energy, Math.min(storageMaxReceive, (long)maxReceive));
            if (!simulate) {
                this.energy += (long)energyReceived;
                this.tile.func_70296_d();
            }
            return energyReceived;
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return (int)Math.min(Integer.MAX_VALUE, this.getExtendedEnergyStored());
    }

    public long getExtendedEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(Integer.MAX_VALUE, this.getExtendedMaxEnergyStored());
    }

    public long getExtendedMaxEnergyStored() {
        this.tile.validateCraftingInventory();
        IFusionCraftingInventory inv = this.tile.getCraftingInventory();
        return inv != null ? inv.getIngredientEnergyCost() : 0L;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public EnergyStorageMarkedInjector readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74763_f("Energy");
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energy < 0L) {
            this.energy = 0L;
        }
        nbt.func_74772_a("Energy", this.energy);
        return nbt;
    }

    public void setEnergyStored(long energy) {
        this.energy = energy;
        if (this.energy < 0L) {
            this.energy = 0L;
        }
    }

    public void modifyEnergyStored(long energy) {
        this.energy += energy;
        if (this.energy < 0L) {
            this.energy = 0L;
        }
    }
}

