/*
 * Decompiled with CFR 0.152.
 */
package com.ethercd.mysticalagriexpansion.item;

import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.ethercd.mysticalagriexpansion.item.ModItem;
import com.ethercd.mysticalagriexpansion.item.ModItems;
import com.ethercd.mysticalagriexpansion.lib.ModTooltips;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWateringCan
extends ModItem {
    private boolean water = false;
    private long ticks;
    private final int range;
    private final int chance;
    private final int delay;
    private final String name;

    public ItemWateringCan(String name, int range, int chance, float multipleDelay) {
        super(name + "_watering_can");
        this.func_77625_d(1);
        this.range = range;
        this.chance = chance;
        this.delay = (int)Math.ceil(1000.0f * multipleDelay);
        this.name = name + "_watering_can";
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (selected) {
            ++this.ticks;
            if (this.ticks % 4L == 0L) {
                this.water = true;
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        if (!ModConfig.confFakePlayerWatering && player instanceof FakePlayer) {
            return EnumActionResult.FAIL;
        }
        if (this.water) {
            Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-this.range, -this.range, -this.range), (BlockPos)pos.func_177982_a(this.range, this.range, this.range));
            for (BlockPos aoePos : blocks) {
                int moisture;
                IBlockState aoeState = world.func_180495_p(aoePos);
                if (!(aoeState.func_177230_c() instanceof BlockFarmland) || (moisture = ((Integer)aoeState.func_177229_b((IProperty)BlockFarmland.field_176531_a)).intValue()) >= 7) continue;
                world.func_180501_a(aoePos, aoeState.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
            }
            Random rand = Utils.rand;
            for (int x = -this.range; x <= this.range; ++x) {
                for (int z = -this.range; z <= this.range; ++z) {
                    double d0 = (float)pos.func_177982_a(x, 0, z).func_177958_n() + rand.nextFloat();
                    double d1 = (double)pos.func_177982_a(x, 0, z).func_177956_o() + 1.0;
                    double d2 = (float)pos.func_177982_a(x, 0, z).func_177952_p() + rand.nextFloat();
                    IBlockState state = world.func_180495_p(pos);
                    if (state.func_185917_h() || state.func_177230_c() instanceof BlockFarmland) {
                        d1 += 0.3;
                    }
                    world.func_175688_a(EnumParticleTypes.WATER_DROP, d0, d1, d2, 0.0, 0.0, 0.0, new int[5]);
                }
            }
            if (!world.field_72995_K) {
                this.water = false;
                int chance = Utils.randInt((int)1, (int)100);
                if (chance <= 40 + this.chance) {
                    for (BlockPos aoePos : blocks) {
                        Block plant = world.func_180495_p(aoePos).func_177230_c();
                        if (!(plant instanceof IGrowable) && !(plant instanceof IPlantable) && plant != Blocks.field_150391_bh && plant != Blocks.field_185766_cS) continue;
                        world.func_180497_b(aoePos, plant, 0, this.delay);
                    }
                    return EnumActionResult.FAIL;
                }
            }
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(ModTooltips.WATERING_CAN + " " + "\u00a75" + this.range + "x" + this.range);
    }

    public void register() {
        ModItems.add(this, this.name);
    }
}

