/*
 * Decompiled with CFR 0.152.
 */
package com.ethercd.mysticalagriexpansion.block.mutagenesis;

import com.ethercd.mysticalagriexpansion.MACreativeTabs;
import com.ethercd.mysticalagriexpansion.MysticalAgriexpansion;
import com.ethercd.mysticalagriexpansion.block.ModBlock;
import com.ethercd.mysticalagriexpansion.lib.ModTooltips;
import com.ethercd.mysticalagriexpansion.te.mutagenesis.TileEntityMutagenesisProcessor;
import com.ethercd.mysticalagriexpansion.te.mutagenesis.TileInferiumMutagenesisProcessor;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockMutagenesisProcessor
extends ModBlock
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private final int tier;

    public BlockMutagenesisProcessor(String name, int tier) {
        super(name, Material.field_151576_e, SoundType.field_185851_d, 5.0f, 8.0f);
        this.func_149647_a(MACreativeTabs.CREATIVE_TAB);
        this.tier = tier;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState north = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState south = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState west = worldIn.func_180495_p(pos.func_177974_f());
            IBlockState east = worldIn.func_180495_p(pos.func_177976_e());
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (face == EnumFacing.NORTH && north.func_185913_b() && !south.func_185913_b()) {
                face = EnumFacing.NORTH;
            } else if (face == EnumFacing.SOUTH && south.func_185913_b() && !north.func_185913_b()) {
                face = EnumFacing.SOUTH;
            } else if (face == EnumFacing.WEST && west.func_185913_b() && !east.func_185913_b()) {
                face = EnumFacing.WEST;
            } else if (face == EnumFacing.EAST && east.func_185913_b() && !west.func_185913_b()) {
                face = EnumFacing.EAST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)face), 2);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.SOUTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityMutagenesisProcessor) {
            TileEntityMutagenesisProcessor te = (TileEntityMutagenesisProcessor)tile;
            for (int i = 0; i < te.func_70302_i_(); ++i) {
                ItemStack stack = te.func_70301_a(i);
                BlockMutagenesisProcessor.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        switch (this.tier) {
            default: {
                tooltip.add(String.format(ModTooltips.MUTAGENESIS_PROCESSOR_CREATION, "\u00a7e40"));
                tooltip.add(String.format(ModTooltips.MUTAGENESIS_PROCESSOR_CHANCE, "\u00a7e1.0"));
                break;
            }
            case 2: {
                tooltip.add(String.format(ModTooltips.MUTAGENESIS_PROCESSOR_CREATION, "\u00a7a34"));
                tooltip.add(String.format(ModTooltips.MUTAGENESIS_PROCESSOR_CHANCE, "\u00a7a1.25"));
                break;
            }
            case 3: {
                tooltip.add(String.format(ModTooltips.MUTAGENESIS_PROCESSOR_CREATION, "\u00a7626"));
                tooltip.add(String.format(ModTooltips.MUTAGENESIS_PROCESSOR_CHANCE, "\u00a761.5"));
                break;
            }
            case 4: {
                tooltip.add(String.format(ModTooltips.MUTAGENESIS_PROCESSOR_CREATION, "\u00a7b14"));
                tooltip.add(String.format(ModTooltips.MUTAGENESIS_PROCESSOR_CHANCE, "\u00a7b1.75"));
                break;
            }
            case 5: {
                tooltip.add(String.format(ModTooltips.MUTAGENESIS_PROCESSOR_CREATION, "\u00a7c6"));
                tooltip.add(String.format(ModTooltips.MUTAGENESIS_PROCESSOR_CHANCE, "\u00a7c2.0"));
                break;
            }
            case 6: {
                tooltip.add(String.format(ModTooltips.MUTAGENESIS_PROCESSOR_CREATION, "\u00a752"));
                tooltip.add(String.format(ModTooltips.MUTAGENESIS_PROCESSOR_CHANCE, "\u00a753.0"));
            }
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileInferiumMutagenesisProcessor();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float side, float hitX, float hitY) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityMutagenesisProcessor) {
            player.openGui((Object)MysticalAgriexpansion.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }
}

