/*
 * Decompiled with CFR 0.152.
 */
package com.ethercd.mysticalagriexpansion.block;

import com.blakebr0.cucumber.registry.ModRegistry;
import com.ethercd.mysticalagriexpansion.MysticalAgriexpansion;
import com.ethercd.mysticalagriexpansion.block.BlockGrowthAccelerator;
import com.ethercd.mysticalagriexpansion.block.mutagenesis.BlockInferiumMutagenesisProcessor;
import com.ethercd.mysticalagriexpansion.block.mutagenesis.BlockInsaniumMutagenesisProcessor;
import com.ethercd.mysticalagriexpansion.block.mutagenesis.BlockIntermediumMutagenesisProcessor;
import com.ethercd.mysticalagriexpansion.block.mutagenesis.BlockMutagenesisProcessor;
import com.ethercd.mysticalagriexpansion.block.mutagenesis.BlockPrudentiumMutagenesisProcessor;
import com.ethercd.mysticalagriexpansion.block.mutagenesis.BlockSuperiumMutagenesisProcessor;
import com.ethercd.mysticalagriexpansion.block.mutagenesis.BlockSupremiumMutagenesisProcessor;
import com.ethercd.mysticalagriexpansion.config.ModConfig;
import com.ethercd.mysticalagriexpansion.lib.ModChecker;
import com.ethercd.mysticalagriexpansion.utils.RegisteredObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;

public class ModBlocks {
    public static final List<RegisteredObject<Block>> BLOCKS = new ArrayList<RegisteredObject<Block>>();
    public static BlockMutagenesisProcessor blockInferniumMutagenesisProcessor = new BlockInferiumMutagenesisProcessor();
    public static BlockMutagenesisProcessor blockPrudentiumMutagenesisProcessor = new BlockPrudentiumMutagenesisProcessor();
    public static BlockMutagenesisProcessor blockIntermediumMutagenesisProcessor = new BlockIntermediumMutagenesisProcessor();
    public static BlockMutagenesisProcessor blockSuperiumMutagenesisProcessor = new BlockSuperiumMutagenesisProcessor();
    public static BlockMutagenesisProcessor blockSupremiumMutagenesisProcessor = new BlockSupremiumMutagenesisProcessor();
    public static BlockMutagenesisProcessor blockInsaniumMutagenesisProcessor = new BlockInsaniumMutagenesisProcessor();

    public static void add(Block item, String name) {
        BLOCKS.add(new RegisteredObject<Block>(item, name));
    }

    public static void register() {
        ModRegistry registry = MysticalAgriexpansion.REGISTRY;
        if (ModConfig.growthAcceleratorActive) {
            BlockGrowthAccelerator.init();
        }
        registry.register((Block)blockInferniumMutagenesisProcessor, "inferium_mutagenesis_processor");
        registry.register((Block)blockPrudentiumMutagenesisProcessor, "prudentium_mutagenesis_processor");
        registry.register((Block)blockIntermediumMutagenesisProcessor, "intermedium_mutagenesis_processor");
        registry.register((Block)blockSuperiumMutagenesisProcessor, "superium_mutagenesis_processor");
        registry.register((Block)blockSupremiumMutagenesisProcessor, "supremium_mutagenesis_processor");
        if (ModConfig.integrationMAg && ModChecker.INSANIUM) {
            registry.register((Block)blockInsaniumMutagenesisProcessor, "insanium_mutagenesis_processor");
        }
        for (RegisteredObject<Block> elem : BLOCKS) {
            registry.register(elem.getObject(), elem.getName(), true);
        }
    }
}

