/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.utils.BaubleItem;
import dlovin.inventoryhud.utils.BaubleSlots;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.minecraftforge.fml.common.Loader;

public class BaubleSaveUtils {
    private static final String path = Loader.instance().getConfigDir().getPath() + "/InventoryHUD/baubles.json";

    public static void saveFile(String input) {
        File file = new File(path);
        BaubleSaveUtils.saveFile(file, input);
    }

    private static void saveFile(File file, String input) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(input);
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void saveSettings() {
        JsonObject obj = new JsonObject();
        for (Map.Entry<BaubleSlots, BaubleItem> entry : InventoryHUD.getInstance().getInventoryGui().baubles.entrySet()) {
            JsonObject tmpObject = new JsonObject();
            tmpObject.addProperty("x", (Number)entry.getValue().x);
            tmpObject.addProperty("y", (Number)entry.getValue().y);
            tmpObject.addProperty("halign", entry.getValue().aligns.HorAlign.name());
            tmpObject.addProperty("valign", entry.getValue().aligns.VertAlign.name());
            tmpObject.addProperty("enabled", Boolean.valueOf(entry.getValue().enabled));
            obj.add(entry.getKey().name(), (JsonElement)tmpObject);
        }
        BaubleSaveUtils.saveFile(obj.toString());
    }

    public static void loadFromFile(InventoryGui gui) {
        InventoryHUD.logger.info("TRY TO IN: " + path);
        File file = new File(path);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            BaubleSaveUtils.saveFile(file, BaubleSaveUtils.getDefault());
        }
        JsonParser jsonParser = new JsonParser();
        try (FileReader reader = new FileReader(file);){
            JsonElement obj = jsonParser.parse((Reader)reader);
            JsonObject list = BaubleSaveUtils.checkTypes(obj.getAsJsonObject());
            BaubleSaveUtils.setTypes(gui, list);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void setTypes(InventoryGui gui, JsonObject obj) {
        for (Map.Entry el : obj.entrySet()) {
            int x = ((JsonElement)el.getValue()).getAsJsonObject().get("x").getAsInt();
            int y = ((JsonElement)el.getValue()).getAsJsonObject().get("y").getAsInt();
            WidgetAligns.HAlign hAlign = WidgetAligns.HAlign.valueOf(((JsonElement)el.getValue()).getAsJsonObject().get("halign").getAsString());
            WidgetAligns.VAlign vAlign = WidgetAligns.VAlign.valueOf(((JsonElement)el.getValue()).getAsJsonObject().get("valign").getAsString());
            boolean enabled = ((JsonElement)el.getValue()).getAsJsonObject().get("enabled").getAsBoolean();
            gui.baubles.put(BaubleSlots.valueOf((String)el.getKey()), new BaubleItem(x, y, new WidgetAligns(hAlign, vAlign), BaubleSlots.valueOf((String)el.getKey()).ordinal(), enabled));
        }
    }

    private static String getDefault() {
        JsonObject obj = new JsonObject();
        for (int i = 0; i < BaubleSlots.values().length; ++i) {
            JsonObject tmpObject = new JsonObject();
            tmpObject.addProperty("x", (Number)0);
            tmpObject.addProperty("y", (Number)(i * 20));
            tmpObject.addProperty("halign", "LEFT");
            tmpObject.addProperty("valign", "TOP");
            tmpObject.addProperty("enabled", Boolean.valueOf(false));
            obj.add(BaubleSlots.values()[i].name(), (JsonElement)tmpObject);
        }
        return obj.toString();
    }

    private static JsonObject checkTypes(JsonObject obj) {
        boolean save = false;
        for (int i = 0; i < BaubleSlots.values().length; ++i) {
            if (obj.get(BaubleSlots.values()[i].name()) != null) continue;
            JsonObject tmpObject = new JsonObject();
            tmpObject.addProperty("x", (Number)0);
            tmpObject.addProperty("y", (Number)(i * 20));
            tmpObject.addProperty("halign", "LEFT");
            tmpObject.addProperty("valign", "TOP");
            tmpObject.addProperty("enabled", Boolean.valueOf(false));
            obj.add(BaubleSlots.values()[i].name(), (JsonElement)tmpObject);
            save = true;
        }
        if (save) {
            BaubleSaveUtils.saveFile(obj.toString());
        }
        return obj;
    }
}

