/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.config.ConfigScreen;
import dlovin.inventoryhud.gui.widgets.CheckBox;
import dlovin.inventoryhud.gui.widgets.CustomButton;
import dlovin.inventoryhud.gui.widgets.NumericTextField;
import dlovin.inventoryhud.gui.widgets.TextWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;

public class ArmorConfigScreen
extends ConfigScreen {
    private CustomButton ToggleBtn;
    private CustomButton ViewBtn;
    private CustomButton BarsBtn;
    private CustomButton MoveAllBtn;
    private CustomButton ShowEmpty;
    private CustomButton ShowCount;
    private CustomButton ArmScale;
    private NumericTextField AboveField;

    public ArmorConfigScreen(boolean inGame) {
        super(1, inGame);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        InventoryHUD.getConfig();
        String toggle = InvConfig.arm.ArmorDamage ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.ToggleBtn = new CustomButton(this.field_146294_l / 2 + 20, 0, 40, 20, toggle, this::ToggleSwitch, null, false);
        this.OptionList.addWidget(this.ToggleBtn, 0);
        int n = this.field_146294_l / 2 + 20;
        InventoryHUD.getConfig();
        this.AboveField = new NumericTextField(0, this.field_146289_q, n, 0, 40, 20, 0, 100, InvConfig.arm.armAbove, w -> this.AboveChanged());
        this.OptionList.addWidget(this.AboveField, 1);
        int n2 = this.field_146294_l / 2 + 20;
        CheckBox.IPressable iPressable = this::TypeArmorChanged;
        InventoryHUD.getConfig();
        this.OptionList.addWidget(new CheckBox(n2, 0, 20, 20, iPressable, InvConfig.arm.showArmor, new ResourceLocation("inventoryhud", "textures/gui/cb_arm.png")), 2);
        int n3 = this.field_146294_l / 2 + 42;
        CheckBox.IPressable iPressable2 = this::TypeMainHandChanged;
        InventoryHUD.getConfig();
        this.OptionList.addWidget(new CheckBox(n3, 0, 20, 20, iPressable2, InvConfig.arm.showMain, new ResourceLocation("inventoryhud", "textures/gui/cb_mh.png")), 2);
        int n4 = this.field_146294_l / 2 + 64;
        CheckBox.IPressable iPressable3 = this::TypeOffHandChanged;
        InventoryHUD.getConfig();
        this.OptionList.addWidget(new CheckBox(n4, 0, 20, 20, iPressable3, InvConfig.arm.showOff, new ResourceLocation("inventoryhud", "textures/gui/cb_oh.png")), 2);
        int n5 = this.field_146294_l / 2 + 86;
        CheckBox.IPressable iPressable4 = this::TypeArrowChanged;
        InventoryHUD.getConfig();
        this.OptionList.addWidget(new CheckBox(n5, 0, 20, 20, iPressable4, InvConfig.arm.showArrows, new ResourceLocation("inventoryhud", "textures/gui/cb_ar.png")), 2);
        int n6 = this.field_146294_l / 2 + 108;
        CheckBox.IPressable iPressable5 = this::TypeInvChanged;
        InventoryHUD.getConfig();
        this.OptionList.addWidget(new CheckBox(n6, 0, 20, 20, iPressable5, InvConfig.arm.showInv, new ResourceLocation("inventoryhud", "textures/gui/cb_inv.png")), 2);
        int n7 = this.field_146294_l / 2 + 20;
        InventoryHUD.getConfig();
        this.ViewBtn = new CustomButton(n7, 0, 75, 20, InvConfig.arm.armView.name(), this::ViewSwitch, null, false);
        this.OptionList.addWidget(this.ViewBtn, 3);
        int n8 = this.field_146294_l / 2 + 20;
        StringBuilder stringBuilder = new StringBuilder();
        InventoryHUD.getConfig();
        this.BarsBtn = new CustomButton(n8, 0, 40, 20, stringBuilder.append(InvConfig.arm.armBars).append("").toString(), this::BarsSwitch, null, false);
        this.OptionList.addWidget(this.BarsBtn, 4);
        int n9 = this.field_146294_l / 2 + 20;
        StringBuilder stringBuilder2 = new StringBuilder();
        InventoryHUD.getConfig();
        this.MoveAllBtn = new CustomButton(n9, 0, 40, 20, stringBuilder2.append(InvConfig.arm.moveAll).append("").toString(), this::MoveSwitch, null, false);
        this.OptionList.addWidget(this.MoveAllBtn, 5);
        int n10 = this.field_146294_l / 2 + 20;
        StringBuilder stringBuilder3 = new StringBuilder();
        InventoryHUD.getConfig();
        this.ShowEmpty = new CustomButton(n10, 0, 40, 20, stringBuilder3.append(InvConfig.arm.showEmpty).append("").toString(), this::EmptySwitch, null, false);
        this.OptionList.addWidget(this.ShowEmpty, 6);
        int n11 = this.field_146294_l / 2 + 20;
        StringBuilder stringBuilder4 = new StringBuilder();
        InventoryHUD.getConfig();
        this.ShowCount = new CustomButton(n11, 0, 40, 20, stringBuilder4.append(InvConfig.arm.showCount).append("").toString(), null, false);
        this.OptionList.addWidget(this.ShowCount, 7);
        this.ShowCount.addListener(this::CountSwitch);
        InventoryHUD.getConfig();
        float sc = (float)InvConfig.arm.armScale / 100.0f;
        String t = sc + "x";
        this.ArmScale = new CustomButton(this.field_146294_l / 2 + 20, 0, 40, 20, t, null, false);
        this.OptionList.addWidget(this.ArmScale, 8);
        this.ArmScale.addListener(this::ScaleSwitch);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_SCALE.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.ARM_SCALE_TT.func_150261_e(), x, y)), 8);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_COUNT.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.ARM_COUNT_TT.func_150261_e(), x, y)), 7);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_EMPTY.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.ARM_EMPTY_TT.func_150261_e(), x, y)), 6);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_MOVE.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146283_a(Translation.ARM_MOVE_TT.stream().map(TextComponentTranslation::func_150261_e).collect(Collectors.toList()), x, y)), 5);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_BARS.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.ARM_BARS_TT.func_150261_e(), x, y)), 4);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_VIEW.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146283_a(Translation.ARM_VIEW_TT.stream().map(TextComponentTranslation::func_150261_e).collect(Collectors.toList()), x, y)), 3);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_TYPE.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.ARM_TYPE_TT.func_150261_e(), x, y)), 2);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_HIDE.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.ARM_HIDE_TT.func_150261_e(), x, y)), 1);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_TOGGLE.func_150261_e(), this.field_146289_q, (w, x, y) -> this.func_146279_a(Translation.ARM_TOGGLE_TT.func_150261_e(), x, y)), 0);
        this.AboveField.setMaxStringLength(5);
    }

    private void ScaleSwitch() {
        int scale = (InventoryHUD.getInstance().getInventoryGui().armorRenderer.armScale + 25) % 175;
        if (scale == 0) {
            scale = 50;
        }
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.armScale = scale;
        InventoryHUD.getInstance().getInventoryGui().changeArmorOffset();
        InventoryHUD.getConfig();
        InvConfig.arm.armScale = scale;
        float sc = (float)scale / 100.0f;
        String t = sc + "x";
        this.ArmScale.setMessage(t);
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void CountSwitch() {
        InventoryHUD.getConfig();
        Boolean bd = !InvConfig.arm.showCount;
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showCount = bd;
        InventoryHUD.getConfig();
        InvConfig.arm.showCount = bd;
        this.ShowCount.setMessage(bd.toString());
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void TypeArmorChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showArmor = cb.checked;
        InventoryHUD.getConfig();
        InvConfig.arm.showArmor = cb.checked;
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void TypeMainHandChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showMain = cb.checked;
        InventoryHUD.getConfig();
        InvConfig.arm.showMain = cb.checked;
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void TypeOffHandChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showOff = cb.checked;
        InventoryHUD.getConfig();
        InvConfig.arm.showOff = cb.checked;
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void TypeArrowChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showArrows = cb.checked;
        InventoryHUD.getConfig();
        InvConfig.arm.showArrows = cb.checked;
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void TypeInvChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showInv = cb.checked;
        InventoryHUD.getConfig();
        InvConfig.arm.showInv = cb.checked;
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void AboveChanged() {
        int a;
        try {
            a = Integer.parseInt(this.AboveField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.armAbove = a;
        InventoryHUD.getConfig();
        InvConfig.arm.armAbove = a;
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void MoveSwitch() {
        InventoryHUD.getConfig();
        boolean bd = !InvConfig.arm.moveAll;
        InventoryHUD.getInstance().getInventoryGui().changeMoveAll(bd);
        InventoryHUD.getConfig();
        InvConfig.arm.moveAll = bd;
        this.MoveAllBtn.setMessage(Boolean.toString(bd));
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void EmptySwitch() {
        boolean bd;
        InventoryHUD.getConfig();
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showEmpty = bd = !InvConfig.arm.showEmpty;
        InventoryHUD.getConfig();
        InvConfig.arm.showEmpty = bd;
        this.ShowEmpty.setMessage(Boolean.toString(bd));
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void ViewSwitch() {
        InventoryHUD.getConfig();
        InvConfig.ArmorView at = InvConfig.arm.armView;
        switch (at) {
            case PERCENTAGE: {
                at = InvConfig.ArmorView.DAMAGE;
                break;
            }
            case DAMAGE: {
                at = InvConfig.ArmorView.DAMAGE_LEFT;
                break;
            }
            case DAMAGE_LEFT: {
                at = InvConfig.ArmorView.OFF;
                break;
            }
            case OFF: {
                at = InvConfig.ArmorView.PERCENTAGE;
            }
        }
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.armView = at;
        InventoryHUD.getConfig();
        InvConfig.arm.armView = at;
        this.ViewBtn.setMessage(at.name());
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void ToggleSwitch() {
        boolean armor;
        InventoryHUD.getConfig();
        InventoryHUD.armorHUD = armor = !InvConfig.arm.ArmorDamage;
        InventoryHUD.getConfig();
        InvConfig.arm.ArmorDamage = armor;
        String armString = armor ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.ToggleBtn.setMessage(armString);
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void BarsSwitch() {
        boolean bars;
        InventoryHUD.getConfig();
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.armBars = bars = !InvConfig.arm.armBars;
        InventoryHUD.getConfig();
        InvConfig.arm.armBars = bars;
        this.BarsBtn.setMessage(Boolean.toString(bars));
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }
}

