/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.ArmorConfigScreen;
import dlovin.inventoryhud.gui.config.BaublesConfigScreen;
import dlovin.inventoryhud.gui.config.InventoryConfigScreen;
import dlovin.inventoryhud.gui.config.PotionConfigScreen;
import dlovin.inventoryhud.gui.widgets.ConfigWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.BaubleItem;
import dlovin.inventoryhud.utils.BaubleSaveUtils;
import dlovin.inventoryhud.utils.BaubleSlots;
import dlovin.inventoryhud.utils.Color4F;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;

public class InGameConfigScreen
extends GuiScreen {
    private final ResourceLocation INV_BG = new ResourceLocation("inventoryhud", "textures/gui/inv_config_bg.png");
    private final ResourceLocation CONF_BG = new ResourceLocation("inventoryhud", "textures/gui/conf_bg.png");
    private ConfigWidget ICW;
    private ConfigWidget PCW;
    private ConfigWidget ACW;
    private GuiButton backButton;
    private final int menu;
    private final boolean inGame;

    public InGameConfigScreen(int menu, boolean inGame) {
        this.menu = menu;
        this.inGame = inGame;
    }

    public void func_73866_w_() {
        int textPos;
        int ySize;
        int xSize;
        int n;
        int n2;
        float f;
        super.func_73866_w_();
        this.backButton = new GuiButton(0, this.field_146294_l - 60, 10, 50, 20, "Back");
        this.field_146292_n.add(this.backButton);
        InventoryHUD.getConfig();
        float invScale = InvConfig.inv.invMini ? 0.75f : 1.0f;
        InventoryHUD.getConfig();
        int invWidth = InvConfig.inv.invVertical ? 52 : 160;
        InventoryHUD.getConfig();
        int invHeight = InvConfig.inv.invVertical ? 160 : 52;
        int n3 = (int)((float)invWidth * invScale);
        InventoryHUD.getConfig();
        int n4 = InvConfig.set.xInvPos;
        InventoryHUD.getConfig();
        int x = this.getPosX(n3, n4, InvConfig.set.invHalign);
        int n5 = (int)((float)invHeight * invScale);
        InventoryHUD.getConfig();
        int n6 = InvConfig.set.yInvPos;
        InventoryHUD.getConfig();
        int y = this.getPosY(n5, n6, InvConfig.set.invValign);
        this.ICW = new ConfigWidget(1, x, y, invWidth, invHeight, invScale, Translation.INVGUI.func_150261_e(), InventoryHUD.isActive);
        this.field_146292_n.add(this.ICW);
        InventoryHUD.getConfig();
        if (!InvConfig.inv.invVertical) {
            this.ICW.initTextureValues(0, 0, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        } else {
            this.ICW.initTextureValues(150, 54, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        }
        this.ICW.addListener(w -> this.onInvChanged());
        this.ICW.addPosListener(w -> this.onInvPosChanged());
        InventoryHUD.getConfig();
        if (InvConfig.pot.potMini) {
            InventoryHUD.getConfig();
            f = InvConfig.pot.potHor ? 1.0f : 0.75f;
        } else {
            f = 1.0f;
        }
        float potScale = f;
        InventoryHUD.getConfig();
        if (InvConfig.pot.potHor) {
            InventoryHUD.getConfig();
            n2 = InvConfig.pot.potMini ? 18 : 36;
        } else {
            n2 = 60;
        }
        int pw = n2;
        InventoryHUD.getConfig();
        if (InvConfig.pot.potHor) {
            InventoryHUD.getConfig();
            n = InvConfig.pot.potMini ? 22 : 38;
        } else {
            n = 24;
        }
        int ph = n;
        int n7 = (int)((float)pw * potScale);
        InventoryHUD.getConfig();
        int n8 = InvConfig.set.xPotionPos;
        InventoryHUD.getConfig();
        x = this.getPosX(n7, n8, InvConfig.set.PotHalign);
        int n9 = (int)((float)ph * potScale);
        InventoryHUD.getConfig();
        int n10 = InvConfig.set.yPotionPos;
        InventoryHUD.getConfig();
        y = this.getPosY(n9, n10, InvConfig.set.PotValign);
        String string = Translation.POTGUI.func_150261_e();
        InventoryHUD.getConfig();
        this.PCW = new ConfigWidget(2, x, y, pw, ph, potScale, string, InvConfig.pot.Potions);
        this.field_146292_n.add(this.PCW);
        this.PCW.initTextureValues(0, 54, new Color4F(1.0f, 0.5f, 0.5f, 1.0f), this.INV_BG);
        this.PCW.addListener(w -> this.onPotionChanged());
        this.PCW.addPosListener(w -> this.onPotionPosChanged());
        InventoryHUD.getConfig();
        float armScale = (float)InvConfig.arm.armScale / 100.0f;
        InventoryHUD.getConfig();
        if (InvConfig.arm.moveAll) {
            int n11 = (int)(90.0f * armScale);
            InventoryHUD.getConfig();
            int n12 = InvConfig.set.xArmPos;
            InventoryHUD.getConfig();
            x = this.getPosX(n11, n12, InvConfig.set.armHalign);
            int n13 = (int)(70.0f * armScale);
            InventoryHUD.getConfig();
            int n14 = InvConfig.set.yArmPos;
            InventoryHUD.getConfig();
            y = this.getPosY(n13, n14, InvConfig.set.armValign);
            this.ACW = new ConfigWidget(3, x, y, 90, 70, armScale, Translation.ARMGUI.func_150261_e(), InventoryHUD.armorHUD);
            this.field_146292_n.add(this.ACW);
            this.ACW.initTextureValues(60, 54, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG);
            this.ACW.addListener(w -> this.onArmorChanged());
            this.ACW.addPosListener(w -> this.onArmorPosChanged());
        } else {
            xSize = (int)(16.0f * armScale);
            ySize = (int)(16.0f * armScale);
            textPos = 80;
            InventoryHUD.getConfig();
            int n15 = InvConfig.set.helmPosX;
            InventoryHUD.getConfig();
            x = this.getPosX(xSize, n15, InvConfig.set.helmHal);
            InventoryHUD.getConfig();
            int n16 = InvConfig.set.helmPosY;
            InventoryHUD.getConfig();
            y = this.getPosY(ySize, n16, InvConfig.set.helmVal);
            InventoryHUD.getConfig();
            ConfigWidget tmp = new ConfigWidget(3, x, y, xSize, ySize, 1.0f, false, "", InvConfig.arm.showArmor, false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_armor_slot_helmet.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 0));
            InventoryHUD.getConfig();
            int n17 = InvConfig.set.chestPosX;
            InventoryHUD.getConfig();
            x = this.getPosX(xSize, n17, InvConfig.set.chestHal);
            InventoryHUD.getConfig();
            int n18 = InvConfig.set.chestPosY;
            InventoryHUD.getConfig();
            y = this.getPosY(ySize, n18, InvConfig.set.chestVal);
            InventoryHUD.getConfig();
            tmp = new ConfigWidget(4, x, y, xSize, ySize, 1.0f, false, "", InvConfig.arm.showArmor, false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_armor_slot_chestplate.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 1));
            InventoryHUD.getConfig();
            int n19 = InvConfig.set.legPosX;
            InventoryHUD.getConfig();
            x = this.getPosX(xSize, n19, InvConfig.set.legHal);
            InventoryHUD.getConfig();
            int n20 = InvConfig.set.legPosY;
            InventoryHUD.getConfig();
            y = this.getPosY(ySize, n20, InvConfig.set.legVal);
            InventoryHUD.getConfig();
            tmp = new ConfigWidget(5, x, y, xSize, ySize, 1.0f, false, "", InvConfig.arm.showArmor, false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_armor_slot_leggings.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 2));
            InventoryHUD.getConfig();
            int n21 = InvConfig.set.bootPosX;
            InventoryHUD.getConfig();
            x = this.getPosX(xSize, n21, InvConfig.set.bootHal);
            InventoryHUD.getConfig();
            int n22 = InvConfig.set.bootPosY;
            InventoryHUD.getConfig();
            y = this.getPosY(ySize, n22, InvConfig.set.bootVal);
            InventoryHUD.getConfig();
            tmp = new ConfigWidget(6, x, y, xSize, ySize, 1.0f, false, "", InvConfig.arm.showArmor, false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_armor_slot_boots.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 3));
            InventoryHUD.getConfig();
            int n23 = InvConfig.set.mainPosX;
            InventoryHUD.getConfig();
            x = this.getPosX(xSize, n23, InvConfig.set.mainHal);
            InventoryHUD.getConfig();
            int n24 = InvConfig.set.mainPosY;
            InventoryHUD.getConfig();
            y = this.getPosY(ySize, n24, InvConfig.set.mainVal);
            InventoryHUD.getConfig();
            tmp = new ConfigWidget(7, x, y, xSize, ySize, 1.0f, false, "", InvConfig.arm.showMain, false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_main_hand_slot.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 5));
            InventoryHUD.getConfig();
            int n25 = InvConfig.set.offPosX;
            InventoryHUD.getConfig();
            x = this.getPosX(xSize, n25, InvConfig.set.offHal);
            InventoryHUD.getConfig();
            int n26 = InvConfig.set.offPosY;
            InventoryHUD.getConfig();
            y = this.getPosY(ySize, n26, InvConfig.set.offVal);
            InventoryHUD.getConfig();
            tmp = new ConfigWidget(8, x, y, xSize, ySize, 1.0f, false, "", InvConfig.arm.showOff, false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_armor_slot_shield.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 4));
            InventoryHUD.getConfig();
            int n27 = InvConfig.set.arrPosX;
            InventoryHUD.getConfig();
            x = this.getPosX(xSize, n27, InvConfig.set.arrHal);
            InventoryHUD.getConfig();
            int n28 = InvConfig.set.arrPosY;
            InventoryHUD.getConfig();
            y = this.getPosY(ySize, n28, InvConfig.set.arrVal);
            InventoryHUD.getConfig();
            tmp = new ConfigWidget(9, x, y, xSize, ySize, 1.0f, false, "", InvConfig.arm.showArrows, false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_arrows.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 7));
            InventoryHUD.getConfig();
            int n29 = InvConfig.set.invPosX;
            InventoryHUD.getConfig();
            x = this.getPosX(xSize, n29, InvConfig.set.invHal);
            InventoryHUD.getConfig();
            int n30 = InvConfig.set.invPosY;
            InventoryHUD.getConfig();
            y = this.getPosY(ySize, n30, InvConfig.set.invVal);
            InventoryHUD.getConfig();
            tmp = new ConfigWidget(10, x, y, xSize, ySize, 1.0f, false, "", InvConfig.arm.showInv, false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_inventory.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 6));
        }
        if (InventoryHUD.isBaublesMod) {
            xSize = (int)(16.0f * armScale);
            ySize = (int)(16.0f * armScale);
            textPos = 80;
            for (Map.Entry<BaubleSlots, BaubleItem> entry : InventoryHUD.getInstance().getInventoryGui().baubles.entrySet()) {
                BaubleItem item = entry.getValue();
                if (!item.enabled) continue;
                x = this.getPosX(xSize, item.x, item.aligns.HorAlign);
                y = this.getPosY(ySize, item.y, item.aligns.VertAlign);
                ConfigWidget tmp = new ConfigWidget(10, x, y, xSize, ySize, 1.0f, false, "", item.enabled, false);
                this.field_146292_n.add(tmp);
                tmp.initTextureValues(textPos, 124, new Color4F(1.0f, 0.5f, 0.0f, 1.0f), this.INV_BG, item.icon);
                tmp.addPosListener(w -> this.onBaubleItemPosChanged(w, (BaubleSlots)((Object)((Object)entry.getKey()))));
            }
        }
    }

    private int getPosX(int width, int posX, WidgetAligns.HAlign hal) {
        int result = 0;
        switch (hal) {
            case LEFT: {
                result = posX;
                break;
            }
            case RIGHT: {
                result = this.field_146294_l - posX;
                break;
            }
            case MIDDLE: {
                result = this.field_146294_l / 2 - width / 2 - posX;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > this.field_146294_l - width) {
            result = this.field_146294_l - width;
        }
        return result;
    }

    private int getPosY(int height, int posY, WidgetAligns.VAlign hal) {
        int result = 0;
        switch (hal) {
            case TOP: {
                result = posY;
                break;
            }
            case BOTTOM: {
                result = this.field_146295_m - posY;
                break;
            }
            case CENTER: {
                result = this.field_146295_m / 2 - height / 2 - posY;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > this.field_146295_m - height) {
            result = this.field_146295_m - height;
        }
        return result;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.backButton) {
            this.saveConfig();
            switch (this.menu) {
                case -1: {
                    this.field_146297_k.func_147108_a(null);
                    break;
                }
                case 0: {
                    this.field_146297_k.func_147108_a((GuiScreen)new InventoryConfigScreen(this.inGame));
                    break;
                }
                case 1: {
                    this.field_146297_k.func_147108_a((GuiScreen)new ArmorConfigScreen(this.inGame));
                    break;
                }
                case 2: {
                    this.field_146297_k.func_147108_a((GuiScreen)new PotionConfigScreen(this.inGame));
                    break;
                }
                case 3: {
                    this.field_146297_k.func_147108_a((GuiScreen)new BaublesConfigScreen(this.inGame));
                }
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.CONF_BG);
        InGameConfigScreen.func_146110_a((int)0, (int)(this.field_146295_m / 3 - 1), (float)this.field_146294_l, (float)3.0f, (int)this.field_146294_l, (int)3, (float)3.0f, (float)3.0f);
        InGameConfigScreen.func_146110_a((int)0, (int)(this.field_146295_m / 3 * 2 - 1), (float)this.field_146294_l, (float)3.0f, (int)this.field_146294_l, (int)3, (float)3.0f, (float)3.0f);
        InGameConfigScreen.func_146110_a((int)(this.field_146294_l / 3 - 1), (int)0, (float)3.0f, (float)this.field_146295_m, (int)3, (int)this.field_146295_m, (float)3.0f, (float)3.0f);
        InGameConfigScreen.func_146110_a((int)(this.field_146294_l / 3 * 2 - 1), (int)0, (float)3.0f, (float)this.field_146295_m, (int)3, (int)this.field_146295_m, (float)3.0f, (float)3.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    public boolean func_73868_f() {
        return true;
    }

    private void saveConfig() {
        InventoryHUD.getConfig();
        InventoryHUD.getInstance().getInventoryGui();
        InvConfig.set.xInvPos = InventoryGui.invX;
        InventoryHUD.getConfig();
        InventoryHUD.getInstance().getInventoryGui();
        InvConfig.set.yInvPos = InventoryGui.invY;
        InventoryHUD.getConfig();
        InventoryHUD.getInstance().getInventoryGui();
        InvConfig.set.invHalign = InventoryGui.InvAligns.HorAlign;
        InventoryHUD.getConfig();
        InventoryHUD.getInstance().getInventoryGui();
        InvConfig.set.invValign = InventoryGui.InvAligns.VertAlign;
        InventoryHUD.getConfig();
        InvConfig.set.xPotionPos = InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX;
        InventoryHUD.getConfig();
        InvConfig.set.yPotionPos = InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY;
        InventoryHUD.getConfig();
        InvConfig.set.PotHalign = InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign;
        InventoryHUD.getConfig();
        InvConfig.set.PotValign = InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign;
        InventoryHUD.getConfig();
        InvConfig.set.xArmPos = InventoryHUD.getInstance().getInventoryGui().armorRenderer.armX;
        InventoryHUD.getConfig();
        InvConfig.set.yArmPos = InventoryHUD.getInstance().getInventoryGui().armorRenderer.armY;
        InventoryHUD.getConfig();
        InvConfig.set.armHalign = InventoryHUD.getInstance().getInventoryGui().armorRenderer.ArmAligns.HorAlign;
        InventoryHUD.getConfig();
        InvConfig.set.armValign = InventoryHUD.getInstance().getInventoryGui().armorRenderer.ArmAligns.VertAlign;
        InventoryHUD.getConfig();
        InvConfig.set.helmPosX = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].x;
        InventoryHUD.getConfig();
        InvConfig.set.chestPosX = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].x;
        InventoryHUD.getConfig();
        InvConfig.set.legPosX = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].x;
        InventoryHUD.getConfig();
        InvConfig.set.bootPosX = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].x;
        InventoryHUD.getConfig();
        InvConfig.set.offPosX = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].x;
        InventoryHUD.getConfig();
        InvConfig.set.mainPosX = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].x;
        InventoryHUD.getConfig();
        InvConfig.set.invPosX = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].x;
        InventoryHUD.getConfig();
        InvConfig.set.arrPosX = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].x;
        InventoryHUD.getConfig();
        InvConfig.set.helmPosY = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].y;
        InventoryHUD.getConfig();
        InvConfig.set.chestPosY = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].y;
        InventoryHUD.getConfig();
        InvConfig.set.legPosY = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].y;
        InventoryHUD.getConfig();
        InvConfig.set.bootPosY = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].y;
        InventoryHUD.getConfig();
        InvConfig.set.offPosY = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].y;
        InventoryHUD.getConfig();
        InvConfig.set.mainPosY = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].y;
        InventoryHUD.getConfig();
        InvConfig.set.invPosY = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].y;
        InventoryHUD.getConfig();
        InvConfig.set.arrPosY = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].y;
        InventoryHUD.getConfig();
        InvConfig.set.helmHal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].aligns.HorAlign;
        InventoryHUD.getConfig();
        InvConfig.set.chestHal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].aligns.HorAlign;
        InventoryHUD.getConfig();
        InvConfig.set.legHal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].aligns.HorAlign;
        InventoryHUD.getConfig();
        InvConfig.set.bootHal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].aligns.HorAlign;
        InventoryHUD.getConfig();
        InvConfig.set.offHal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].aligns.HorAlign;
        InventoryHUD.getConfig();
        InvConfig.set.mainHal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].aligns.HorAlign;
        InventoryHUD.getConfig();
        InvConfig.set.invHal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].aligns.HorAlign;
        InventoryHUD.getConfig();
        InvConfig.set.arrHal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].aligns.HorAlign;
        InventoryHUD.getConfig();
        InvConfig.set.helmVal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].aligns.VertAlign;
        InventoryHUD.getConfig();
        InvConfig.set.chestVal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].aligns.VertAlign;
        InventoryHUD.getConfig();
        InvConfig.set.legVal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].aligns.VertAlign;
        InventoryHUD.getConfig();
        InvConfig.set.bootVal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].aligns.VertAlign;
        InventoryHUD.getConfig();
        InvConfig.set.offVal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].aligns.VertAlign;
        InventoryHUD.getConfig();
        InvConfig.set.mainVal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].aligns.VertAlign;
        InventoryHUD.getConfig();
        InvConfig.set.invVal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].aligns.VertAlign;
        InventoryHUD.getConfig();
        InvConfig.set.arrVal = InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].aligns.VertAlign;
        if (InventoryHUD.isBaublesMod) {
            BaubleSaveUtils.saveSettings();
        }
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void onInvChanged() {
        InventoryHUD.isActive = this.ICW.getShow();
        InventoryHUD.getConfig();
        InvConfig.inv.byDefault = this.ICW.getShow();
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void onInvPosChanged() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.ICW.field_146128_h + this.ICW.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 3) {
            InventoryHUD.getInstance().getInventoryGui();
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryHUD.getInstance().getInventoryGui();
            InventoryGui.invX = this.ICW.field_146128_h;
        } else if (this.ICW.field_146128_h + this.ICW.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui();
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryHUD.getInstance().getInventoryGui();
            InventoryGui.invX = mc.field_71462_r.field_146294_l - this.ICW.field_146128_h;
        } else {
            InventoryHUD.getInstance().getInventoryGui();
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            if (this.ICW.field_146128_h + this.ICW.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 2 - 10) {
                InventoryHUD.getInstance().getInventoryGui();
                InventoryGui.invX = mc.field_71462_r.field_146294_l / 2 - this.ICW.field_146120_f / 2 - this.ICW.field_146128_h;
            } else if (this.ICW.field_146128_h + this.ICW.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 2 + 10) {
                InventoryHUD.getInstance().getInventoryGui();
                InventoryGui.invX = mc.field_71462_r.field_146294_l / 2 - this.ICW.field_146120_f / 2 - this.ICW.field_146128_h;
            } else {
                InventoryHUD.getInstance().getInventoryGui();
                InventoryGui.invX = 0;
            }
        }
        if (this.ICW.field_146129_i + this.ICW.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 3) {
            InventoryHUD.getInstance().getInventoryGui();
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryHUD.getInstance().getInventoryGui();
            InventoryGui.invY = this.ICW.field_146129_i;
        } else if (this.ICW.field_146129_i + this.ICW.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui();
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryHUD.getInstance().getInventoryGui();
            InventoryGui.invY = mc.field_71462_r.field_146295_m - this.ICW.field_146129_i;
        } else {
            InventoryHUD.getInstance().getInventoryGui();
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            if (this.ICW.field_146129_i + this.ICW.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 2 - 10) {
                InventoryHUD.getInstance().getInventoryGui();
                InventoryGui.invY = mc.field_71462_r.field_146295_m / 2 - this.ICW.field_146121_g / 2 - this.ICW.field_146129_i;
            } else if (this.ICW.field_146129_i + this.ICW.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 2 + 10) {
                InventoryHUD.getInstance().getInventoryGui();
                InventoryGui.invY = mc.field_71462_r.field_146295_m / 2 - this.ICW.field_146121_g / 2 - this.ICW.field_146129_i;
            } else {
                InventoryHUD.getInstance().getInventoryGui();
                InventoryGui.invY = 0;
            }
        }
    }

    private void onPotionChanged() {
        InventoryHUD.potionHUD = this.PCW.getShow();
        InventoryHUD.getConfig();
        InvConfig.pot.Potions = this.PCW.getShow();
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void onPotionPosChanged() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.PCW.field_146128_h + this.PCW.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 3) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = this.PCW.field_146128_h;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
        } else if (this.PCW.field_146128_h + this.PCW.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = mc.field_71462_r.field_146294_l - this.PCW.field_146128_h;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
        } else {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            if (this.PCW.field_146128_h + this.PCW.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 2 - 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = mc.field_71462_r.field_146294_l / 2 - this.PCW.field_146120_f / 2 - this.PCW.field_146128_h;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            } else if (this.PCW.field_146128_h + this.PCW.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 2 + 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = mc.field_71462_r.field_146294_l / 2 - this.PCW.field_146120_f / 2 - this.PCW.field_146128_h;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            } else {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = 0;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            }
        }
        if (this.PCW.field_146129_i + this.PCW.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 3) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = this.PCW.field_146129_i;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
        } else if (this.PCW.field_146129_i + this.PCW.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = mc.field_71462_r.field_146295_m - this.PCW.field_146129_i;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(false);
        } else {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            if (this.PCW.field_146129_i + this.PCW.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 2 - 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = mc.field_71462_r.field_146295_m / 2 - this.PCW.field_146121_g / 2 - this.PCW.field_146129_i;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
            } else if (this.PCW.field_146129_i + this.PCW.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 2 + 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = mc.field_71462_r.field_146295_m / 2 - this.PCW.field_146121_g / 2 - this.PCW.field_146129_i;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(false);
            } else {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = 0;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
            }
        }
    }

    private void onArmorChanged() {
        InventoryHUD.armorHUD = this.ACW.getShow();
        InventoryHUD.getConfig();
        InvConfig.arm.ArmorDamage = this.ACW.getShow();
        ConfigManager.sync((String)"inventoryhud", (Config.Type)Config.Type.INSTANCE);
    }

    private void onArmorPosChanged() {
        int ay;
        int ax;
        Minecraft mc = Minecraft.func_71410_x();
        WidgetAligns armal = new WidgetAligns(WidgetAligns.HAlign.LEFT, WidgetAligns.VAlign.BOTTOM);
        if (this.ACW.field_146128_h + this.ACW.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 3) {
            armal.HorAlign = WidgetAligns.HAlign.LEFT;
            ax = this.ACW.field_146128_h;
        } else if (this.ACW.field_146128_h + this.ACW.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 3 * 2) {
            armal.HorAlign = WidgetAligns.HAlign.RIGHT;
            ax = mc.field_71462_r.field_146294_l - this.ACW.field_146128_h;
        } else {
            armal.HorAlign = WidgetAligns.HAlign.MIDDLE;
            ax = this.ACW.field_146128_h + this.ACW.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 2 - 10 ? mc.field_71462_r.field_146294_l / 2 - this.ACW.field_146120_f / 2 - this.ACW.field_146128_h : (this.ACW.field_146128_h + this.ACW.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 2 + 10 ? mc.field_71462_r.field_146294_l / 2 - this.ACW.field_146120_f / 2 - this.ACW.field_146128_h : 0);
        }
        if (this.ACW.field_146129_i + this.ACW.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 2 - 10) {
            armal.VertAlign = WidgetAligns.VAlign.TOP;
            ay = this.ACW.field_146129_i;
        } else if (this.ACW.field_146129_i + this.ACW.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 2 + 10) {
            armal.VertAlign = WidgetAligns.VAlign.BOTTOM;
            ay = mc.field_71462_r.field_146295_m - this.ACW.field_146129_i;
        } else {
            armal.VertAlign = WidgetAligns.VAlign.CENTER;
            ay = this.ACW.field_146129_i + this.ACW.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 2 - 10 ? mc.field_71462_r.field_146295_m / 2 - this.ACW.field_146121_g / 2 - this.ACW.field_146129_i : (this.ACW.field_146129_i + this.ACW.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 2 + 10 ? mc.field_71462_r.field_146295_m / 2 - this.ACW.field_146121_g / 2 - this.ACW.field_146129_i : 0);
        }
        InventoryHUD.getInstance().getInventoryGui().changeArmorPos(armal, ax, ay);
    }

    private void onItemPosChanged(ConfigWidget w, int i) {
        Minecraft mc = Minecraft.func_71410_x();
        if (w.field_146128_h + w.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 3) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = w.field_146128_h;
        } else if (w.field_146128_h + w.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = mc.field_71462_r.field_146294_l - w.field_146128_h;
        } else {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = mc.field_71462_r.field_146294_l / 2 - w.field_146120_f / 2 - w.field_146128_h;
        }
        if (w.field_146129_i + w.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 2 - 10) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = w.field_146129_i;
        } else if (w.field_146129_i + w.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 2 + 10) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = mc.field_71462_r.field_146295_m - w.field_146129_i;
        } else {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = mc.field_71462_r.field_146295_m / 2 - w.field_146121_g / 2 - w.field_146129_i;
        }
    }

    private void onBaubleItemPosChanged(ConfigWidget w, BaubleSlots key) {
        Minecraft mc = Minecraft.func_71410_x();
        BaubleItem item = InventoryHUD.getInstance().getInventoryGui().baubles.get((Object)key);
        if (w.field_146128_h + w.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 3) {
            item.aligns.HorAlign = WidgetAligns.HAlign.LEFT;
            item.x = w.field_146128_h;
        } else if (w.field_146128_h + w.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 3 * 2) {
            item.aligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            item.x = mc.field_71462_r.field_146294_l - w.field_146128_h;
        } else {
            item.aligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            item.x = mc.field_71462_r.field_146294_l / 2 - w.field_146120_f / 2 - w.field_146128_h;
        }
        if (w.field_146129_i + w.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 2 - 10) {
            item.aligns.VertAlign = WidgetAligns.VAlign.TOP;
            item.y = w.field_146129_i;
        } else if (w.field_146129_i + w.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 2 + 10) {
            item.aligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            item.y = mc.field_71462_r.field_146295_m - w.field_146129_i;
        } else {
            item.aligns.VertAlign = WidgetAligns.VAlign.CENTER;
            item.y = mc.field_71462_r.field_146295_m / 2 - w.field_146121_g / 2 - w.field_146129_i;
        }
        InventoryHUD.getInstance().getInventoryGui().baubles.put(key, item);
    }

    protected void func_73869_a(char p_keyTyped_1_, int p_keyTyped_2_) {
        if (p_keyTyped_2_ == 1) {
            this.saveConfig();
            switch (this.menu) {
                case -1: {
                    this.field_146297_k.func_147108_a(null);
                    break;
                }
                case 0: {
                    this.field_146297_k.func_147108_a((GuiScreen)new InventoryConfigScreen(this.inGame));
                    break;
                }
                case 1: {
                    this.field_146297_k.func_147108_a((GuiScreen)new ArmorConfigScreen(this.inGame));
                    break;
                }
                case 2: {
                    this.field_146297_k.func_147108_a((GuiScreen)new PotionConfigScreen(this.inGame));
                    break;
                }
                case 3: {
                    this.field_146297_k.func_147108_a((GuiScreen)new BaublesConfigScreen(this.inGame));
                }
            }
        }
    }
}

