/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud;

import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.events.InvEvents;
import dlovin.inventoryhud.events.UpdateNotificationEvent;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.utils.potions.PotionUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="inventoryhud", name="InventoryHUD+", version="3.4.4", dependencies="after:baubles", updateJSON="https://raw.githubusercontent.com/DmitryLovin/pluginUpdate/master/invupdate.json")
@Mod.EventBusSubscriber
public class InventoryHUD {
    public static final String MODID = "inventoryhud";
    public static final String NAME = "InventoryHUD+";
    public static final String VERSION = "3.4.4";
    @Mod.Instance(value="inventoryhud")
    private static InventoryHUD instance;
    private InventoryGui inventoryGui;
    public static final Logger logger;
    private static InvConfig CONFIG;
    public static boolean isActive;
    public static boolean armorHUD;
    public static boolean potionHUD;
    public static boolean isBaublesMod;

    public InventoryHUD() {
        CONFIG = new InvConfig();
        instance = this;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (MODID.equals(event.getModID())) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
            instance.getInventoryGui().syncConfig();
            armorHUD = InvConfig.arm.ArmorDamage;
            potionHUD = InvConfig.pot.Potions;
        }
    }

    public static InvConfig getConfig() {
        return CONFIG;
    }

    public static InventoryHUD getInstance() {
        return instance;
    }

    public InventoryGui getInventoryGui() {
        return this.inventoryGui;
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (Loader.isModLoaded((String)"baubles")) {
            isBaublesMod = true;
        }
        this.inventoryGui = new InventoryGui();
        MinecraftForge.EVENT_BUS.register((Object)this.inventoryGui);
        MinecraftForge.EVENT_BUS.register((Object)new InvEvents());
        MinecraftForge.EVENT_BUS.register((Object)new UpdateNotificationEvent());
        isActive = InvConfig.inv.byDefault;
        armorHUD = InvConfig.arm.ArmorDamage;
        potionHUD = InvConfig.pot.Potions;
        logger.info("InventoryHUD+ successfully initialized");
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PotionUtils.Initialize();
    }

    static {
        logger = LogManager.getLogger((String)MODID);
        isBaublesMod = false;
    }
}

