/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.utils.Vector3;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RetraceDiggingUtils {
    public static RayTraceResult retrace(EntityPlayer player) {
        return RetraceDiggingUtils.retrace(player, RetraceDiggingUtils.getBlockReachDistance(player));
    }

    public static double getBlockReachDistance(EntityPlayer player) {
        return player.field_70170_p.field_72995_K ? RetraceDiggingUtils.getBlockReachDistance_client() : (player instanceof EntityPlayerMP ? RetraceDiggingUtils.getBlockReachDistance_server((EntityPlayerMP)player) : 5.0);
    }

    public static RayTraceResult retrace(EntityPlayer player, double reach) {
        return RetraceDiggingUtils.retrace(player, reach, true);
    }

    @SideOnly(value=Side.CLIENT)
    private static double getBlockReachDistance_client() {
        return Minecraft.func_71410_x().field_71442_b.func_78757_d();
    }

    private static double getBlockReachDistance_server(EntityPlayerMP player) {
        return player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
    }

    public static RayTraceResult retrace(EntityPlayer player, double reach, boolean stopOnFluids) {
        Vec3d startVec = RetraceDiggingUtils.getStartVec(player);
        Vec3d endVec = RetraceDiggingUtils.getEndVec(player, reach);
        return player.field_70170_p.func_147447_a(startVec, endVec, stopOnFluids, false, true);
    }

    public static Vec3d getStartVec(EntityPlayer player) {
        return RetraceDiggingUtils.getCorrectedHeadVec(player);
    }

    public static Vec3d getCorrectedHeadVec(EntityPlayer player) {
        Vector3 v = Vector3.fromEntity((Entity)player).add(0.0, player.func_70047_e(), 0.0);
        return v.vec3();
    }

    public static Vec3d getEndVec(EntityPlayer player, double reach) {
        Vec3d headVec = RetraceDiggingUtils.getCorrectedHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        return headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
    }
}

