/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.radiationsystem.EnumCoefficient;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.items.CellType;
import com.denfop.items.bags.ItemStackBags;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.mechanism.quarry.QuarryItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;

public class ModUtils {
    public static final Set<String> ignoredNbtKeys = new HashSet<String>(Arrays.asList("damage", "charge", "energy", "advDmg"));
    public static Logger log;
    public static EnumFacing[] facings;
    public static ItemStack emptyStack;
    public static Set<EnumFacing> noFacings;
    public static Set<EnumFacing> onlyNorth;
    public static Set<EnumFacing> horizontalFacings;
    public static Set<EnumFacing> verticalFacings;
    public static Set<EnumFacing> downSideFacings;
    public static Set<EnumFacing> allFacings;

    public static double getEnergyValue(ItemStack stack) {
        if (ModUtils.isEmpty(stack)) {
            return 0.0;
        }
        if (ModUtils.checkItemEquality(stack, Items.field_151137_ax)) {
            return 800.0;
        }
        return 0.0;
    }

    public static int getFuelValue(ItemStack stack, boolean allowLava) {
        boolean isLava;
        if (ModUtils.isEmpty(stack)) {
            return 0;
        }
        FluidStack liquid = FluidUtil.getFluidContained((ItemStack)stack);
        boolean bl = isLava = liquid != null && liquid.amount > 0 && liquid.getFluid() == FluidRegistry.LAVA;
        if (isLava && !allowLava) {
            return 0;
        }
        int ret = TileEntityFurnace.func_145952_a((ItemStack)stack);
        return isLava ? ret / 10 : ret;
    }

    public static ItemStack get(EntityPlayer player, EnumHand hand) {
        return player.func_184586_b(hand);
    }

    public static ItemStack decSize(ItemStack stack) {
        return ModUtils.decSize(stack, 1);
    }

    public static ItemStack decSize(ItemStack stack, int amount) {
        return ModUtils.incSize(stack, -amount);
    }

    public static ItemStack incSize(ItemStack stack, int amount) {
        return ModUtils.setSize(stack, ModUtils.getSize(stack) + amount);
    }

    public static boolean storeInventoryItem(ItemStack stack, EntityPlayer player, boolean simulate) {
        if (!simulate) {
            return player.field_71071_by.func_70441_a(stack);
        }
        int sizeLeft = ModUtils.getSize(stack);
        int maxStackSize = Math.min(player.field_71071_by.func_70297_j_(), stack.func_77976_d());
        for (int i = 0; i < player.field_71071_by.field_70462_a.size() && sizeLeft > 0; ++i) {
            ItemStack invStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (ModUtils.isEmpty(invStack)) {
                sizeLeft -= maxStackSize;
                continue;
            }
            if (!ModUtils.checkItemEqualityStrict(stack, invStack) || ModUtils.getSize(invStack) >= maxStackSize) continue;
            sizeLeft -= maxStackSize - ModUtils.getSize(invStack);
        }
        return sizeLeft <= 0;
    }

    public static void dropAsEntity(World world, BlockPos pos, ItemStack stack) {
        if (!ModUtils.isEmpty(stack)) {
            double f = 0.7;
            double dx = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
            double dy = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
            double dz = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + dx, (double)pos.func_177956_o() + dy, (double)pos.func_177952_p() + dz, stack.func_77946_l());
            entityItem.func_174869_p();
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static boolean checkItemEquality(ItemStack a, ItemStack b) {
        return ModUtils.isEmpty(a) && ModUtils.isEmpty(b) || !ModUtils.isEmpty(a) && !ModUtils.isEmpty(b) && a.func_77973_b() == b.func_77973_b() && (!a.func_77981_g() || a.func_77960_j() == b.func_77960_j()) && ModUtils.checkNbtEquality(a, b);
    }

    public static boolean checkItemEquality(ItemStack a, Item b) {
        return ModUtils.isEmpty(a) && b == null || !ModUtils.isEmpty(a) && b != null && a.func_77973_b() == b;
    }

    public static boolean checkItemEqualityStrict(ItemStack a, ItemStack b) {
        return ModUtils.isEmpty(a) && ModUtils.isEmpty(b) || !ModUtils.isEmpty(a) && !ModUtils.isEmpty(b) && a.func_77969_a(b) && ModUtils.checkNbtEqualityStrict(a, b);
    }

    private static boolean checkNbtEquality(ItemStack a, ItemStack b) {
        return ModUtils.checkNbtEquality(a.func_77978_p(), b.func_77978_p());
    }

    public static boolean checkNbtEquality(NBTTagCompound a, NBTTagCompound b) {
        String key2;
        if (a == b) {
            return true;
        }
        Set keysA = a != null ? a.func_150296_c() : Collections.emptySet();
        Set keysB = b != null ? b.func_150296_c() : Collections.emptySet();
        HashSet<String> toCheck = new HashSet<String>(Math.max(keysA.size(), keysB.size()));
        for (String key2 : keysA) {
            if (ignoredNbtKeys.contains(key2)) continue;
            if (!keysB.contains(key2)) {
                return false;
            }
            toCheck.add(key2);
        }
        for (String key2 : keysB) {
            if (ignoredNbtKeys.contains(key2)) continue;
            if (!keysA.contains(key2)) {
                return false;
            }
            toCheck.add(key2);
        }
        Iterator var5 = toCheck.iterator();
        do {
            if (var5.hasNext()) continue;
            return true;
        } while (a.func_74781_a(key2 = (String)var5.next()).equals((Object)b.func_74781_a(key2)));
        return false;
    }

    public static boolean checkNbtEqualityStrict(ItemStack a, ItemStack b) {
        NBTTagCompound nbtB;
        NBTTagCompound nbtA = a.func_77978_p();
        if (nbtA == (nbtB = b.func_77978_p())) {
            return true;
        }
        return nbtA != null && nbtA.equals((Object)nbtB);
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack == emptyStack || stack == null || stack.func_77973_b() == null || stack.func_190916_E() <= 0;
    }

    public static boolean isEmpty(EntityPlayer player, EnumHand hand) {
        return ModUtils.isEmpty(player.func_184586_b(hand));
    }

    public static int getSize(ItemStack stack) {
        return ModUtils.isEmpty(stack) ? 0 : stack.func_190916_E();
    }

    public static void setRawMeta(ItemStack stack, int meta) {
        if (meta < 0) {
            throw new IllegalArgumentException("negative meta");
        }
        Items.field_151100_aR.setDamage(stack, meta);
    }

    public static List<ItemStack> get_blacklist_block() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(Blocks.field_150348_b));
        list.add(new ItemStack(Blocks.field_150346_d));
        list.add(new ItemStack(Blocks.field_150424_aL));
        list.add(new ItemStack(Blocks.field_150377_bs));
        list.add(new ItemStack(Blocks.field_150348_b, 1, 1));
        list.add(new ItemStack(Blocks.field_150348_b, 1, 2));
        list.add(new ItemStack(Blocks.field_150348_b, 1, 3));
        list.add(new ItemStack(Blocks.field_150348_b, 1, 4));
        list.add(new ItemStack(Blocks.field_150348_b, 1, 5));
        list.add(new ItemStack(Blocks.field_150348_b, 1, 6));
        list.add(new ItemStack(Blocks.field_150346_d, 1, 1));
        list.add(new ItemStack(Blocks.field_150346_d, 1, 2));
        return list;
    }

    public static void info(String message) {
        log.info(message);
    }

    public static ItemStack getCellFromFluid(String name) {
        for (CellType cellType : CellType.values()) {
            if (cellType.getFluid() == null || !cellType.getFluid().getName().trim().equals(name.trim())) continue;
            return new ItemStack((Item)IUItem.cell_all, 1, cellType.ordinal());
        }
        return new ItemStack((Item)IUItem.cell_all, 1, 0);
    }

    public static ItemStack getCellFromFluid(Fluid name) {
        for (CellType cellType : CellType.values()) {
            if (cellType.getFluid() == null || !cellType.getFluid().equals(name)) continue;
            return new ItemStack((Item)IUItem.cell_all, 1, cellType.ordinal());
        }
        return new ItemStack((Item)IUItem.cell_all, 1, 0);
    }

    public static List<ItemStack> getListFromModule(ItemStack stack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (!stack.func_190926_b()) {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            int size = nbt.func_74762_e("size");
            for (int j = 0; j < size; ++j) {
                String l = "number_" + j;
                String temp = ModUtils.NBTGetString(stack, l);
                stacks.addAll((Collection<ItemStack>)OreDictionary.getOres((String)temp));
            }
        }
        return stacks;
    }

    public static List<QuarryItem> getQuarryListFromModule(ItemStack stack) {
        ArrayList<QuarryItem> stacks = new ArrayList<QuarryItem>();
        if (!stack.func_190926_b()) {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            int size = nbt.func_74762_e("size");
            for (int j = 0; j < size; ++j) {
                String l = "number_" + j;
                String temp = ModUtils.NBTGetString(stack, l);
                stacks.add(new QuarryItem((ItemStack)OreDictionary.getOres((String)temp).get(0), temp));
            }
        }
        return stacks;
    }

    public static boolean getore(Block localBlock, int meta) {
        ItemStack stack = new ItemStack(localBlock, 1, meta);
        for (ItemStack itemstack : ModUtils.get_blacklist_block()) {
            if (!stack.func_77969_a(itemstack)) continue;
            return false;
        }
        return true;
    }

    public static boolean getore(Item localBlock) {
        for (ItemStack itemstack : ModUtils.get_blacklist_block()) {
            if (localBlock != itemstack.func_77973_b()) continue;
            return false;
        }
        return true;
    }

    public static boolean getore(ItemStack localBlock) {
        for (ItemStack itemstack : ModUtils.get_blacklist_block()) {
            if (!localBlock.func_77969_a(itemstack)) continue;
            return false;
        }
        return true;
    }

    public static boolean getore(Block stack, Block localBlock) {
        ItemStack stack1 = new ItemStack(localBlock);
        for (ItemStack itemstack : ModUtils.get_blacklist_block()) {
            if (!stack1.func_77969_a(itemstack)) continue;
            return false;
        }
        if (stack != localBlock) {
            return false;
        }
        if (localBlock == Blocks.field_150439_ay) {
            return true;
        }
        for (ItemStack itemstack : IUCore.get_ore) {
            if (stack != Block.func_149634_a((Item)itemstack.func_77973_b())) continue;
            return true;
        }
        return false;
    }

    public static List<Double> Time(double time) {
        ArrayList<Double> list = new ArrayList<Double>();
        double temp = 0.0;
        if (time / 3600.0 >= 1.0) {
            temp = time / 3600.0;
        }
        temp = Math.floor(temp);
        list.add(Math.floor(temp));
        double temp1 = 0.0;
        if ((time - temp * 3600.0) / 60.0 >= 1.0) {
            temp1 = (time - temp * 3600.0) / 60.0;
        }
        temp1 = Math.floor(temp1);
        list.add(Math.floor(temp1));
        double temp2 = time - (temp * 3600.0 + temp1 * 60.0);
        list.add(Math.floor(temp2));
        return list;
    }

    public static void NBTSetString(ItemStack stack, String name, String string) {
        if (string == null) {
            return;
        }
        NBTTagCompound NBTTagCompound2 = stack.func_77978_p();
        if (NBTTagCompound2 == null) {
            NBTTagCompound2 = new NBTTagCompound();
        }
        NBTTagCompound2.func_74778_a(name, string);
        stack.func_77982_d(NBTTagCompound2);
    }

    public static int getsum1(List<Integer> sum) {
        int sum_sum = 0;
        for (Integer aDouble : sum) {
            sum_sum += aDouble.intValue();
        }
        return sum_sum;
    }

    public static void SetDoubleWithoutItem(NBTTagCompound NBTTagCompound2, String name, double amount) {
        if (NBTTagCompound2 == null) {
            NBTTagCompound2 = new NBTTagCompound();
        }
        NBTTagCompound2.func_74780_a(name, amount);
    }

    public static String Boolean(boolean boolean1) {
        if (boolean1) {
            return Localization.translate("iu.yes");
        }
        return Localization.translate("iu.no");
    }

    public static void mode(ItemStack stack, List<String> list) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        list.add(ModUtils.mode(nbt));
    }

    public static String mode(NBTTagCompound nbt) {
        String mode = nbt.func_74779_i("mode");
        if (mode.isEmpty()) {
            return Localization.translate("defaultskin");
        }
        switch (mode) {
            case "Zelen": {
                return Localization.translate("camouflageskin");
            }
            case "Demon": {
                return Localization.translate("demonskin");
            }
            case "Dark": {
                return Localization.translate("Darkskin");
            }
            case "Cold": {
                return Localization.translate("Coldskin");
            }
            case "Ender": {
                return Localization.translate("Enderskin");
            }
            case "Ukraine": {
                return Localization.translate("Ukraineskin");
            }
            case "Fire": {
                return Localization.translate("Fireskin");
            }
            case "Emerald": {
                return Localization.translate("Emeraldskin");
            }
            case "Taiga": {
                return Localization.translate("Taigaskin");
            }
            case "Desert": {
                return Localization.translate("Desertskin");
            }
            case "Snow": {
                return Localization.translate("Snowskin");
            }
        }
        return Localization.translate("defaultskin");
    }

    public static ItemStack mode(NBTTagCompound nbt, ItemStack stack) {
        String mode = nbt.func_74779_i("mode");
        ItemStack stack1 = stack.func_77946_l();
        if (mode.isEmpty()) {
            return stack1;
        }
        nbt = ModUtils.nbt(stack1);
        nbt.func_74778_a("mode", mode);
        return stack1;
    }

    public static String mode(int meta) {
        if (meta == 0) {
            return Localization.translate("defaultskin");
        }
        switch (meta) {
            case 3: {
                return Localization.translate("camouflageskin");
            }
            case 4: {
                return Localization.translate("demonskin");
            }
            case 6: {
                return Localization.translate("Darkskin");
            }
            case 1: {
                return Localization.translate("Coldskin");
            }
            case 7: {
                return Localization.translate("Enderskin");
            }
            case 2: {
                return Localization.translate("Ukraineskin");
            }
            case 5: {
                return Localization.translate("Fireskin");
            }
            case 11: {
                return Localization.translate("Emeraldskin");
            }
            case 8: {
                return Localization.translate("Taigaskin");
            }
            case 10: {
                return Localization.translate("Desertskin");
            }
            case 9: {
                return Localization.translate("Snowskin");
            }
        }
        return Localization.translate("defaultskin");
    }

    public static String getString(float number) {
        int i = (int)Math.log10(number);
        String maxstorage_2 = "0";
        if (i > -3 && i < 0) {
            float gg = number * 1000.0f;
            maxstorage_2 = String.format("%.0fm", Float.valueOf(gg));
        } else if (i <= -3 && i > -6) {
            float gg = number * 1000000.0f;
            maxstorage_2 = String.format("%.2f\u00b5", Float.valueOf(gg));
        } else if (i <= -6 && i > -9) {
            float gg = number * 1.0E9f;
            maxstorage_2 = String.format("%.2fn", Float.valueOf(gg));
        } else if (i <= -9 && i > -12) {
            float gg = number * 1.0E12f;
            maxstorage_2 = String.format("%.2fp", Float.valueOf(gg));
        } else if (i >= 0 && i < 3 && number <= 1000.0f) {
            float gg = number;
            maxstorage_2 = String.format("%.0f", Float.valueOf(gg));
        } else if (i >= 3 && i < 6) {
            float gg = number / 1000.0f;
            maxstorage_2 = String.format("%.2fK", Float.valueOf(gg));
        } else if (i >= 6 && i < 9) {
            float gg = number / 1000000.0f;
            maxstorage_2 = String.format("%.2fM", Float.valueOf(gg));
        } else if (i >= 9 && i < 12) {
            float gg = number / 1.0E9f;
            maxstorage_2 = String.format("%.2fG", Float.valueOf(gg));
        }
        return maxstorage_2;
    }

    public static String getUnit(EnumCoefficient coefficient) {
        switch (coefficient) {
            case MICRO: {
                return "\u00b5";
            }
            case MILI: {
                return "m";
            }
            case KILO: {
                return "k";
            }
            case DEFAULT: {
                return "";
            }
        }
        return "n";
    }

    public static String getString1(double number) {
        int i = (int)Math.log10(number);
        String maxstorage_2 = "0";
        if (i > -3 && i < 0) {
            double gg = number * 1000.0;
            maxstorage_2 = String.format("%.0fm", gg);
        } else if (i <= -3 && i > -6) {
            double gg = number * 1000000.0;
            maxstorage_2 = String.format("%.0f\u00b5", gg);
        } else if (i <= -6 && i > -9) {
            double gg = number * 1.0E9;
            maxstorage_2 = String.format("%.0fn", gg);
        } else if (i <= -9 && i > -12) {
            double gg = number * 1.0E12;
            maxstorage_2 = String.format("%.0fp", gg);
        } else if (i >= 0 && i < 3 && number <= 1000.0) {
            double gg = number;
            maxstorage_2 = String.format("%.0f", gg);
        } else if (i >= 3 && i < 6 && number >= 1000.0 && number < 1000000.0) {
            double gg = number / 1000.0;
            maxstorage_2 = String.format("%.2fK", gg);
        } else if (i >= 6 && i < 9 && number >= 1000000.0 && number < 1.0E9) {
            double gg = number / 1000000.0;
            maxstorage_2 = String.format("%.2fM", gg);
        } else if (i >= 9 && i < 12 && number >= 1.0E9 && number < 2.1E9) {
            double gg = number / 1.0E9;
            maxstorage_2 = String.format("%.2fG", gg);
        }
        return maxstorage_2;
    }

    public static String getString(double number) {
        String maxstorage_2 = "0";
        double i = Math.log10(number);
        if (i > -3.0 && i < 0.0) {
            maxstorage_2 = String.format("%.0fm", number * 1000.0);
        } else if (i <= -3.0 && i > -6.0) {
            maxstorage_2 = String.format("%.0f\u00b5", number * 1000000.0);
        } else if (i <= -6.0 && i > -9.0) {
            maxstorage_2 = String.format("%.0fn", number * 1.0E9);
        } else if (i <= -9.0 && i > -12.0) {
            maxstorage_2 = String.format("%.0fp", number * 1.0E12);
        } else if (i < 3.0) {
            maxstorage_2 = String.format("%.0f", number);
        } else if (i < 6.0) {
            maxstorage_2 = String.format("%.2fK", number / 1000.0);
        } else if (i < 9.0) {
            maxstorage_2 = String.format("%.2fM", number / 1000000.0);
        } else if (i < 12.0) {
            maxstorage_2 = String.format("%.2fG", number / 1.0E9);
        } else if (i < 15.0) {
            maxstorage_2 = String.format("%.2fT", number / 1.0E12);
        } else if (i < 18.0) {
            maxstorage_2 = String.format("%.2fP", number / 1.0E15);
        } else if (i < 21.0) {
            maxstorage_2 = String.format("%.2fE", number / 1.0E18);
        } else if (i < 24.0) {
            maxstorage_2 = String.format("%.2fZ", number / 1.0E21);
        } else if (i < 27.0) {
            maxstorage_2 = String.format("%.2fY", number / 1.0E24);
        }
        return maxstorage_2;
    }

    public static String getStringBukket(double number) {
        String maxstorage_2 = "0";
        double i = Math.log10(number);
        if (i > -3.0 && i < 0.0) {
            maxstorage_2 = String.format("%.0fm", number * 1000.0);
        } else if (i <= -3.0 && i > -6.0) {
            maxstorage_2 = String.format("%.0f\u00b5", number * 1000000.0);
        } else if (i <= -6.0 && i > -9.0) {
            maxstorage_2 = String.format("%.0fn", number * 1.0E9);
        } else if (i <= -9.0 && i > -12.0) {
            maxstorage_2 = String.format("%.0fp", number * 1.0E12);
        } else if (i < 3.0) {
            maxstorage_2 = String.format("%.0fm", number * 1000.0);
        } else if (i < 6.0) {
            maxstorage_2 = String.format("%.2fK", number / 1000.0);
        } else if (i < 9.0) {
            maxstorage_2 = String.format("%.2fM", number / 1000000.0);
        } else if (i < 12.0) {
            maxstorage_2 = String.format("%.2fG", number / 1.0E9);
        } else if (i < 15.0) {
            maxstorage_2 = String.format("%.2fT", number / 1.0E12);
        } else if (i < 18.0) {
            maxstorage_2 = String.format("%.2fP", number / 1.0E15);
        } else if (i < 21.0) {
            maxstorage_2 = String.format("%.2fE", number / 1.0E18);
        } else if (i < 24.0) {
            maxstorage_2 = String.format("%.2fZ", number / 1.0E21);
        } else if (i < 27.0) {
            maxstorage_2 = String.format("%.2fY", number / 1.0E24);
        }
        return maxstorage_2;
    }

    public static NBTTagCompound nbt() {
        return new NBTTagCompound();
    }

    public static NBTTagCompound nbt(ItemStack stack) {
        if (stack.func_190926_b()) {
            return new NBTTagCompound();
        }
        NBTTagCompound NBTTagCompound2 = stack.func_77978_p();
        if (NBTTagCompound2 == null) {
            NBTTagCompound2 = new NBTTagCompound();
        }
        stack.func_77982_d(NBTTagCompound2);
        return NBTTagCompound2;
    }

    public static NBTTagCompound nbtOrNull(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return stack.func_77978_p();
    }

    public static int slot(List<Integer> list) {
        int meta = 0;
        for (Integer integer : list) {
            if (integer == 0) continue;
            meta = integer;
        }
        return meta;
    }

    public static String NBTGetString(ItemStack stack, String name) {
        if (name == null) {
            return "";
        }
        if (stack == null) {
            return "";
        }
        NBTTagCompound NBTTagCompound2 = ModUtils.nbt(stack);
        return NBTTagCompound2.func_74779_i(name);
    }

    public static int NBTGetInteger(ItemStack stack, String name) {
        if (name == null) {
            return 0;
        }
        NBTTagCompound NBTTagCompound2 = stack.func_77978_p();
        if (NBTTagCompound2 == null) {
            return 0;
        }
        return NBTTagCompound2.func_74762_e(name);
    }

    public static void NBTSetInteger(ItemStack stack, String name, int string) {
        if (name == null) {
            return;
        }
        NBTTagCompound NBTTagCompound2 = stack.func_77978_p();
        if (NBTTagCompound2 == null) {
            NBTTagCompound2 = new NBTTagCompound();
        }
        NBTTagCompound2.func_74768_a(name, string);
        stack.func_77982_d(NBTTagCompound2);
    }

    public static int convertRGBcolorToInt(int r, int g, int b) {
        float divColor = 255.0f;
        Color tmpColor = new Color((float)r / divColor, (float)g / divColor, (float)b / divColor);
        return tmpColor.getRGB();
    }

    public static IItemHandler getItemHandler(@Nullable TileEntity tile, EnumFacing side) {
        IItemHandler handler;
        if (tile == null) {
            return null;
        }
        IItemHandler iItemHandler = handler = tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) ? (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) : null;
        if (handler == null) {
            if (side != null && tile instanceof ISidedInventory) {
                handler = new SidedInvWrapper((ISidedInventory)tile, side);
            } else if (tile instanceof IInventory) {
                handler = new InvWrapper((IInventory)tile);
            }
        }
        return handler;
    }

    public static void tick(InvSlotOutput slot, TileEntityBlock tile) {
        for (EnumFacing facing1 : facings) {
            BlockPos pos = tile.func_174877_v().func_177972_a(facing1);
            TileEntity tile1 = tile.func_145831_w().func_175625_s(pos);
            IItemHandler handler = ModUtils.getItemHandler(tile1, facing1.func_176734_d());
            if (handler == null) continue;
            int slots = handler.getSlots();
            for (int j = 0; j < slot.size(); ++j) {
                ItemStack stack1;
                ItemStack took = slot.get(j);
                if (took.func_190926_b()) continue;
                if (!(handler instanceof ISidedInventory)) {
                    stack1 = ModUtils.insertItem(handler, took = took.func_77946_l(), true, slots);
                    if (stack1.func_190926_b()) {
                        slot.put(j, ItemStack.field_190927_a);
                        ModUtils.insertItem(handler, took, false, slots);
                        continue;
                    }
                    if (stack1 == took) continue;
                    slot.get(j).func_190918_g(stack1.func_190916_E());
                    ModUtils.insertItem(handler, stack1, false, slots);
                    continue;
                }
                stack1 = ModUtils.insertItem1(handler, took, true, slots);
                if (stack1.func_190926_b()) {
                    slot.put(j, ItemStack.field_190927_a);
                    ModUtils.insertItem1(handler, took, false, slots);
                    continue;
                }
                if (stack1 == took) continue;
                slot.get(j).func_190918_g(stack1.func_190916_E());
                ModUtils.insertItem1(handler, stack1, false, slots);
            }
        }
    }

    public static void tick(ItemStack[] slot, IItemHandler tile, ItemStackBags handHeldBags) {
        if (tile == null) {
            return;
        }
        int slots = tile.getSlots();
        for (int i = 0; i < slot.length; ++i) {
            ItemStack stack;
            ItemStack took = slot[i];
            if (took.func_190926_b()) continue;
            if (!(tile instanceof ISidedInventory)) {
                stack = ModUtils.insertItem(tile, took = took.func_77946_l(), true, slots);
                if (stack.func_190926_b()) {
                    handHeldBags.put(i, ItemStack.field_190927_a);
                    ModUtils.insertItem(tile, took, false, slots);
                    continue;
                }
                if (stack == took) continue;
                handHeldBags.get(i).func_190918_g(stack.func_190916_E());
                ModUtils.insertItem1(tile, stack, false, slots);
                continue;
            }
            stack = ModUtils.insertItem1(tile, took, true, slots);
            if (stack.func_190926_b()) {
                handHeldBags.put(i, ItemStack.field_190927_a);
                ModUtils.insertItem1(tile, took, false, slots);
                continue;
            }
            if (stack == took) continue;
            handHeldBags.get(i).func_190918_g(stack.func_190916_E());
            ModUtils.insertItem1(tile, stack, false, slots);
        }
    }

    @Nonnull
    public static ItemStack insertItem1(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate, int slot) {
        if (dest == null || stack.func_190926_b()) {
            return stack;
        }
        slot = Math.min(slot, dest.getSlots());
        for (int i = 0; i < slot; ++i) {
            ItemStack stack2 = ModUtils.insertItem2(dest, i, stack, simulate);
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (stack2 == stack) continue;
            return stack2;
        }
        return stack;
    }

    public static boolean canItemStacksStack(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.func_190926_b() || !a.func_77969_a(b) || a.func_77942_o() != b.func_77942_o()) {
            return false;
        }
        return !a.func_77942_o() || a.func_77978_p().equals((Object)b.func_77978_p());
    }

    @Nonnull
    public static ItemStack insertItem2(IItemHandler dest, int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = dest.getStackInSlot(slot);
        if (!stackInSlot.func_190926_b()) {
            int max = stackInSlot.func_77976_d();
            int limit = dest.getSlotLimit(slot);
            if (stackInSlot.func_190916_E() >= Math.min(max, limit)) {
                return stack;
            }
            if (!ModUtils.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            int m = Math.min(max, limit) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    ((SidedInvWrapper)dest).setStackInSlot(slot, copy);
                    return ItemStack.field_190927_a;
                }
            } else {
                stack = stack.func_77946_l();
                if (!simulate) {
                    ItemStack copy = stack.func_77979_a(m);
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    ((SidedInvWrapper)dest).setStackInSlot(slot, copy);
                    return ItemStack.field_190927_a;
                }
            }
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), dest.getSlotLimit(slot));
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                ((SidedInvWrapper)dest).setStackInSlot(slot, stack.func_77979_a(m));
            }
            return stack;
        }
        if (!simulate) {
            ((SidedInvWrapper)dest).setStackInSlot(slot, stack);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack insertItem(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate, int slots) {
        if (dest == null || stack.func_190926_b()) {
            return stack;
        }
        slots = Math.min(slots, dest.getSlots());
        for (int i = 0; i < slots; ++i) {
            ItemStack stack1 = dest.insertItem(i, stack, simulate);
            if (stack1.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (stack1 == stack) continue;
            return stack1;
        }
        return stack;
    }

    public static ItemStack setSize(ItemStack stack, int col) {
        stack = stack.func_77946_l();
        stack.func_190920_e(col);
        return stack;
    }

    public static ItemStack setSize(Item item, int col) {
        ItemStack stack = new ItemStack(item);
        stack.func_190920_e(col);
        return stack;
    }

    public static int limit(int value, int min, int max) {
        if (value <= min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static float limit(float value, float min, float max) {
        if (!Float.isNaN(value) && !(value <= min)) {
            return Math.min(value, max);
        }
        return min;
    }

    public static double limit(double value, double min, double max) {
        if (!Double.isNaN(value) && !(value <= min)) {
            return Math.min(value, max);
        }
        return min;
    }

    public static ResourceLocation getName(Block block) {
        return (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
    }

    public static Item getItem(String name) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        return ModUtils.getItem(new ResourceLocation(name));
    }

    public static Item getItem(ResourceLocation loc) {
        return (Item)Item.field_150901_e.func_82594_a((Object)loc);
    }

    public static ResourceLocation getName(Item item) {
        return (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
    }

    public static boolean matchesNBT(NBTTagCompound subject, NBTTagCompound target) {
        String key;
        NBTBase subjectNBT;
        NBTBase targetNBT;
        if (subject == null) {
            return target == null || target.func_82582_d();
        }
        if (target == null) {
            return true;
        }
        Iterator var2 = target.func_150296_c().iterator();
        do {
            if (!var2.hasNext()) {
                return true;
            }
            key = (String)var2.next();
            targetNBT = target.func_74781_a(key);
            if (subject.func_74764_b(key) && targetNBT.func_74732_a() == subject.func_150299_b(key)) continue;
            return false;
        } while (targetNBT.equals((Object)(subjectNBT = subject.func_74781_a(key))));
        return false;
    }

    public static void showFlames(World world, BlockPos pos, EnumFacing facing) {
        if (world.field_73012_v.nextInt(8) == 0) {
            double x = (double)pos.func_177958_n() + ((double)facing.func_82601_c() * 1.04 + 1.0) / 2.0;
            double y = (double)pos.func_177956_o() + (double)world.field_73012_v.nextFloat() * 0.375;
            double z = (double)pos.func_177952_p() + ((double)facing.func_82599_e() * 1.04 + 1.0) / 2.0;
            if (facing.func_176740_k() == EnumFacing.Axis.X) {
                z += (double)world.field_73012_v.nextFloat() * 0.625 - 0.3125;
            } else {
                x += (double)world.field_73012_v.nextFloat() * 0.625 - 0.3125;
            }
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    static {
        facings = EnumFacing.values();
        emptyStack = ItemStack.field_190927_a;
        noFacings = Collections.emptySet();
        onlyNorth = Collections.unmodifiableSet(EnumSet.of(EnumFacing.NORTH));
        horizontalFacings = Collections.unmodifiableSet(EnumSet.copyOf(Arrays.asList(EnumFacing.field_176754_o)));
        verticalFacings = Collections.unmodifiableSet(EnumSet.of(EnumFacing.DOWN, EnumFacing.UP));
        downSideFacings = Collections.unmodifiableSet(EnumSet.complementOf(EnumSet.of(EnumFacing.UP)));
        allFacings = Collections.unmodifiableSet(EnumSet.allOf(EnumFacing.class));
    }
}

