/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.api.item.IEnergyItem;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class MatterRecipe {
    private final ItemStack stack;
    int COMPARE_DAMAGE = 1;
    int COMPARE_NBT = 2;
    int COMPARE_QUANTITY = 4;
    private boolean can;
    private double aer;
    private double aqua;
    private double earth;
    private double night;
    private double sun;
    private double end;
    private double nether;
    private double matter;

    public MatterRecipe(ItemStack stack) {
        this.stack = stack.func_77946_l();
        this.stack.func_190920_e(1);
        this.aer = 0.0;
        this.aqua = 0.0;
        this.earth = 0.0;
        this.night = 0.0;
        this.sun = 0.0;
        this.end = 0.0;
        this.nether = 0.0;
        this.matter = 0.0;
        this.can = false;
    }

    public static boolean areItemStackTagsEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        if (!stackA.func_190926_b() && !stackB.func_190926_b()) {
            if (stackA.func_77978_p() == null && stackB.func_77978_p() != null) {
                return false;
            }
            return stackA.func_77978_p() == null || stackA.func_77978_p().equals((Object)stackB.func_77978_p());
        }
        return false;
    }

    public boolean isEqualNbt(@Nullable ItemStack left, @Nullable ItemStack right) {
        if (!MatterRecipe.areItemStackTagsEqual(left, right)) {
            if (left.func_77942_o() && !right.func_77942_o() && left.func_77978_p().func_82582_d()) {
                return true;
            }
            if (!left.func_77942_o() && right.func_77942_o() && right.func_77978_p().func_82582_d()) {
                return true;
            }
            return !left.func_77942_o() && !right.func_77942_o();
        }
        return true;
    }

    public boolean isEqual(@Nullable ItemStack left, @Nullable ItemStack right, int flags) {
        if (left.func_77973_b() != right.func_77973_b()) {
            return false;
        }
        int damage = left.func_77952_i();
        int damage1 = right.func_77952_i();
        if (left.func_77973_b() instanceof IEnergyItem && right.func_77973_b() instanceof IEnergyItem) {
            return true;
        }
        if ((flags & this.COMPARE_DAMAGE) == this.COMPARE_DAMAGE && damage != Short.MAX_VALUE && damage1 != Short.MAX_VALUE && damage != damage1) {
            return false;
        }
        if ((flags & this.COMPARE_NBT) == this.COMPARE_NBT && !this.isEqualNbt(left, right)) {
            return false;
        }
        if ((flags & this.COMPARE_QUANTITY) == this.COMPARE_QUANTITY) {
            return left.func_190916_E() == right.func_190916_E();
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatterRecipe that = (MatterRecipe)o;
        return this.isEqual(that.stack, this.stack, 3);
    }

    public int hashCode() {
        return Objects.hash(this.stack, this.aer, this.aqua, this.earth, this.night, this.sun, this.end, this.nether, this.matter);
    }

    public void setCan(boolean can) {
        this.can = can;
    }

    public double getAer() {
        return this.aer;
    }

    public double getAqua() {
        return this.aqua;
    }

    public double getEarth() {
        return this.earth;
    }

    public double getEnd() {
        return this.end;
    }

    public double getMatter() {
        return this.matter;
    }

    public double getNether() {
        return this.nether;
    }

    public double getNight() {
        return this.night;
    }

    public double getSun() {
        return this.sun;
    }

    public boolean can() {
        return this.can && (this.aer != 0.0 || this.aqua != 0.0 || this.earth != 0.0 || this.nether != 0.0 || this.sun != 0.0 || this.night != 0.0 || this.matter != 0.0 || this.end != 0.0);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void addAer(double aer) {
        this.aer += aer;
    }

    public void addNether(double nether) {
        this.nether += nether;
    }

    public void addAqua(double aqua) {
        this.aqua += aqua;
    }

    public void addSun(double sun) {
        this.sun += sun;
    }

    public void addMatter(double matter) {
        this.matter += matter;
    }

    public void addEnd(double end) {
        this.end += end;
    }

    public void addEarth(double earth) {
        this.earth += earth;
    }

    public void addNight(double night) {
        this.night += night;
    }
}

