/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public final class CapturedMobUtils {
    @Nonnull
    private static final ResourceLocation PIG = new ResourceLocation("pig");
    @Nullable
    private final NBTTagCompound entityNbt;
    @Nonnull
    private final ResourceLocation entityId;
    @Nullable
    private final String customName;
    private final String resource;
    private final double coefficient;
    private int color;

    private CapturedMobUtils(@Nonnull EntityLivingBase entity) {
        EntityLiving entLiv;
        ResourceLocation id = EntityList.func_191301_a((Entity)entity);
        this.entityId = id == null ? PIG : id;
        this.entityNbt = entity.serializeNBT();
        String name = null;
        if (entity instanceof EntityLiving && (entLiv = (EntityLiving)entity).func_145818_k_()) {
            name = entLiv.func_95999_t();
        }
        this.color = -1;
        StringBuilder builder = new StringBuilder(this.entityId.toString());
        if (entity instanceof EntitySheep) {
            this.color = ((EntitySheep)entity).func_175509_cj().func_176765_a();
            builder.append("_").append(((EntitySheep)entity).func_175509_cj().func_176610_l());
        }
        this.customName = name != null && name.length() > 0 ? name : null;
        this.resource = builder.toString();
        this.coefficient = entity.func_110138_aP() / 40.0f;
    }

    private CapturedMobUtils(@Nonnull NBTTagCompound nbt) {
        this.entityNbt = nbt.func_74764_b("entity") ? nbt.func_74775_l("entity").func_74737_b() : (nbt.func_74764_b("EntityTag") ? nbt.func_74775_l("EntityTag").func_74737_b() : null);
        String id = nbt.func_74779_i("entityId");
        this.coefficient = nbt.func_74769_h("coefficient");
        this.entityId = !id.isEmpty() ? new ResourceLocation(id) : PIG;
        StringBuilder builder = new StringBuilder(this.entityId.toString());
        this.customName = nbt.func_74779_i("customName");
        this.color = nbt.func_74762_e("color");
        if (this.color >= 0) {
            builder.append("_").append(EnumDyeColor.func_176764_b((int)this.color));
        }
        this.resource = builder.toString();
    }

    private CapturedMobUtils(@Nonnull ResourceLocation entityId) {
        this.entityNbt = null;
        this.entityId = entityId;
        this.customName = null;
        this.resource = this.entityId.toString();
        this.coefficient = 1.0;
    }

    @Nullable
    public static CapturedMobUtils create(@Nullable Entity entity) {
        return entity instanceof EntityLivingBase && entity.func_70089_S() && !entity.field_70170_p.field_72995_K && !(entity instanceof EntityPlayer) && !CapturedMobUtils.isBlacklisted(entity) ? new CapturedMobUtils((EntityLivingBase)entity) : null;
    }

    @Nullable
    public static CapturedMobUtils create(@Nullable ResourceLocation entityId) {
        return entityId != null && EntityList.func_180125_b((ResourceLocation)entityId) && CapturedMobUtils.isRegisteredMob(entityId) ? new CapturedMobUtils(entityId) : null;
    }

    public static boolean isRegisteredMob(ResourceLocation entityName) {
        if (entityName == null) {
            return false;
        }
        Class clazz = EntityList.getClass((ResourceLocation)entityName);
        return clazz != null && EntityLiving.class.isAssignableFrom(clazz);
    }

    public static boolean containsSoul(@Nullable NBTTagCompound nbt) {
        return nbt != null && (nbt.func_74764_b("entity") || nbt.func_74764_b("entityId") || nbt.func_74764_b("EntityTag"));
    }

    public static boolean containsSoul(@Nonnull ItemStack stack) {
        return CapturedMobUtils.isValid(stack) && stack.func_77942_o() && CapturedMobUtils.containsSoul(stack.func_77978_p());
    }

    public static boolean isValid(@Nonnull ItemStack stack) {
        return !stack.func_190926_b();
    }

    @Nullable
    public static CapturedMobUtils create(@Nonnull ItemStack stack) {
        if (CapturedMobUtils.containsSoul(stack)) {
            assert (stack.func_77978_p() != null);
            return new CapturedMobUtils(stack.func_77978_p());
        }
        return null;
    }

    @Nullable
    public static CapturedMobUtils create(@Nullable NBTTagCompound nbt) {
        return CapturedMobUtils.containsSoul(nbt) ? new CapturedMobUtils(nbt) : null;
    }

    public static boolean isBlacklisted(@Nonnull Entity entity) {
        ResourceLocation entityId = EntityList.func_191301_a((Entity)entity);
        return entityId == null;
    }

    public double getCoefficient() {
        return this.coefficient;
    }

    public String getResource() {
        return this.resource;
    }

    @Nonnull
    public ItemStack toStack(@Nonnull Item item, int meta, int amount) {
        ItemStack stack = new ItemStack(item, amount, meta);
        stack.func_77982_d(this.toNbt(null));
        return stack;
    }

    @Nonnull
    public NBTTagCompound toNbt(@Nullable NBTTagCompound nbt) {
        NBTTagCompound data = nbt != null ? nbt : new NBTTagCompound();
        data.func_74778_a("entityId", this.entityId.toString());
        if (this.entityNbt != null) {
            data.func_74782_a("entity", (NBTBase)this.entityNbt.func_74737_b());
        }
        if (this.customName != null) {
            data.func_74778_a("customName", this.customName);
        }
        data.func_74768_a("color", this.color);
        data.func_74780_a("coefficient", this.coefficient);
        return data;
    }

    @Nullable
    public Entity getEntity(@Nullable World world, boolean clone) {
        return this.getEntity(world, null, null, clone);
    }

    @Nullable
    public Entity getEntity(@Nullable World world, @Nullable BlockPos pos, @Nullable DifficultyInstance difficulty, boolean clone) {
        if (world == null) {
            return null;
        }
        NBTTagCompound entityNbt_nullchecked = this.entityNbt;
        if (entityNbt_nullchecked == null || !clone) {
            Entity entity = EntityList.func_188429_b((ResourceLocation)this.entityId, (World)world);
            if (entity == null) {
                return null;
            }
            if (pos != null) {
                entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            }
            if (entity instanceof EntityLiving) {
                if (pos != null && difficulty == null) {
                    difficulty = world.func_175649_E(pos);
                }
                if (!(difficulty == null || pos != null && ForgeEventFactory.doSpecialSpawn((EntityLiving)((EntityLiving)entity), (World)world, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p(), null))) {
                    ((EntityLiving)entity).func_180482_a(difficulty, null);
                }
            }
            if (entity instanceof EntitySheep) {
                ((EntitySheep)entity).func_175512_b(EnumDyeColor.func_176764_b((int)this.color));
            }
            return entity;
        }
        Entity entity = EntityList.func_75615_a((NBTTagCompound)entityNbt_nullchecked, (World)world);
        if (entity instanceof EntitySheep) {
            ((EntitySheep)entity).func_175512_b(EnumDyeColor.func_176764_b((int)this.color));
        }
        return entity;
    }
}

