/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.cool.CoolNet;
import com.denfop.api.cool.ICoolAcceptor;
import com.denfop.api.cool.ICoolConductor;
import com.denfop.api.cool.ICoolEmitter;
import com.denfop.api.cool.event.CoolTileLoadEvent;
import com.denfop.api.cool.event.CoolTileUnloadEvent;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergyAcceptor;
import com.denfop.api.energy.IEnergyConductor;
import com.denfop.api.energy.IEnergyEmitter;
import com.denfop.api.energy.event.EnergyTileLoadEvent;
import com.denfop.api.energy.event.EnergyTileUnLoadEvent;
import com.denfop.api.heat.HeatNet;
import com.denfop.api.heat.IHeatAcceptor;
import com.denfop.api.heat.IHeatConductor;
import com.denfop.api.heat.IHeatEmitter;
import com.denfop.api.heat.event.HeatTileLoadEvent;
import com.denfop.api.heat.event.HeatTileUnloadEvent;
import com.denfop.api.sytem.EnergyBase;
import com.denfop.api.sytem.EnergyEvent;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.sytem.EnumTypeEvent;
import com.denfop.api.sytem.IAcceptor;
import com.denfop.api.sytem.IConductor;
import com.denfop.api.sytem.IEmitter;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockUniversalCable;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketCableSound;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.ICableItem;
import com.denfop.tiles.transport.types.UniversalType;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import scala.actors.threadpool.Arrays;

public class TileEntityUniversalCable
extends TileEntityMultiCable
implements IEnergyConductor,
IHeatConductor,
ICoolConductor,
IConductor {
    public boolean addedToEnergyNet;
    protected UniversalType cableType;
    private boolean needUpdate;

    public TileEntityUniversalCable(UniversalType cableType) {
        super(cableType);
        this.cableType = cableType;
    }

    public TileEntityUniversalCable() {
        super(UniversalType.glass);
        this.cableType = UniversalType.glass;
        this.connectivity = 0;
        this.addedToEnergyNet = false;
    }

    public static TileEntityUniversalCable delegate(UniversalType cableType) {
        return new TileEntityUniversalCable(cableType);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockUniversalCable.universal_cable;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.universalcableblock;
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.field_174879_c;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableType = UniversalType.values[nbt.func_74771_c("cableType") & 0xFF];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("cableType", (byte)this.cableType.ordinal());
        return nbt;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        super.updateTileServer(var1, var2);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.func_145831_w(), this));
        MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this, this.func_145831_w()));
        MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this, this.func_145831_w()));
        MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.QUANTUM, this));
        MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.EXPERIENCE, this));
        MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.SOLARIUM, this));
        this.needUpdate = true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.func_145831_w(), this));
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.func_145831_w()));
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.func_145831_w()));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.QUANTUM, this));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.EXPERIENCE, this));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.SOLARIUM, this));
            this.needUpdate = false;
            this.updateConnectivity();
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.func_145831_w(), this));
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.func_145831_w()));
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.func_145831_w()));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.QUANTUM, this));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.EXPERIENCE, this));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.LOAD, EnergyType.SOLARIUM, this));
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    @Override
    public void onUnloaded() {
        if (IUCore.proxy.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.func_145831_w(), this));
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this, this.func_145831_w()));
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this, this.func_145831_w()));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.QUANTUM, this));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.EXPERIENCE, this));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.func_145831_w(), EnumTypeEvent.UNLOAD, EnergyType.SOLARIUM, this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return new ItemStack((Item)IUItem.universal_cable, 1, this.cableType.ordinal());
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (!this.func_145831_w().field_72995_K) {
            this.updateConnectivity();
        }
    }

    @Override
    public void updateConnectivity() {
        EnumFacing[] var4;
        World world = this.func_145831_w();
        byte newConnectivity = 0;
        for (EnumFacing dir : var4 = EnumFacing.field_82609_l) {
            newConnectivity = (byte)(newConnectivity << 1);
            if (this.getBlackList().contains(dir)) continue;
            Object tile = EnergyNetGlobal.instance.getTile(world, this.field_174879_c.func_177972_a(dir));
            if (tile != EnergyNetGlobal.EMPTY) {
                if ((!(tile instanceof IEnergyAcceptor) || !((IEnergyAcceptor)tile).acceptsEnergyFrom(this, dir.func_176734_d())) && (!(tile instanceof IEnergyEmitter) || !((IEnergyEmitter)tile).emitsEnergyTo(this, dir.func_176734_d())) || !this.canInteractWith()) continue;
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            tile = EnergyBase.SE.getSubTile(world, this.field_174879_c.func_177972_a(dir));
            if (tile != null) {
                if ((!(tile instanceof IAcceptor) || !((IAcceptor)tile).acceptsFrom(this, dir.func_176734_d())) && (!(tile instanceof IEmitter) || !((IEmitter)tile).emitsTo(this, dir.func_176734_d()))) continue;
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            tile = HeatNet.instance.getSubTile(world, this.field_174879_c.func_177972_a(dir));
            if (tile != null) {
                if ((!(tile instanceof IHeatAcceptor) || !((IHeatAcceptor)tile).acceptsHeatFrom(this, dir.func_176734_d())) && (!(tile instanceof IHeatEmitter) || !((IHeatEmitter)tile).emitsHeatTo(this, dir.func_176734_d())) || !this.canInteractWith()) continue;
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            tile = CoolNet.instance.getSubTile(world, this.field_174879_c.func_177972_a(dir));
            if (tile != null) {
                if ((!(tile instanceof ICoolAcceptor) || !((ICoolAcceptor)tile).acceptsCoolFrom(this, dir.func_176734_d())) && (!(tile instanceof ICoolEmitter) || !((ICoolEmitter)tile).emitsCoolTo(this, dir.func_176734_d())) || !this.canInteractWith()) continue;
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            tile = EnergyBase.QE.getSubTile(world, this.field_174879_c.func_177972_a(dir));
            if (tile != null) {
                if ((!(tile instanceof IAcceptor) || !((IAcceptor)tile).acceptsFrom(this, dir.func_176734_d())) && (!(tile instanceof IEmitter) || !((IEmitter)tile).emitsTo(this, dir.func_176734_d())) || !this.canInteractWith()) continue;
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            tile = EnergyBase.EXP.getSubTile(world, this.field_174879_c.func_177972_a(dir));
            if (tile == null || (!(tile instanceof IAcceptor) || !((IAcceptor)tile).acceptsFrom(this, dir.func_176734_d())) && (!(tile instanceof IEmitter) || !((IEmitter)tile).emitsTo(this, dir.func_176734_d())) || !this.canInteractWith()) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return !this.getBlackList().contains(direction);
    }

    public boolean canInteractWith() {
        return true;
    }

    @Override
    public double getConductionLoss() {
        return this.cableType.loss;
    }

    @Override
    public double getConductorBreakdownEnergy() {
        return this.cableType.capacity + 1.0;
    }

    @Override
    public double getConductorBreakdownEnergy(EnergyType energyType) {
        return 2.147483647E9;
    }

    @Override
    public double getConductorBreakdownHeat() {
        return 16001.0;
    }

    @Override
    public double getConductorBreakdownCold() {
        return 65.0;
    }

    @Override
    public void removeConductor() {
        this.func_145831_w().func_175698_g(this.field_174879_c);
        new PacketCableSound(this.func_145831_w(), this.field_174879_c, 0.5, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = UniversalType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.rerender();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void update_render() {
        if (!this.func_145831_w().field_72995_K) {
            this.updateConnectivity();
        }
    }

    @Override
    public EnergyType getEnergyType() {
        return EnergyType.QUANTUM;
    }

    @Override
    public boolean hasEnergies() {
        return true;
    }

    @Override
    public List<EnergyType> getEnergies() {
        return Arrays.asList((Object[])new EnergyType[]{EnergyType.QUANTUM, EnergyType.SOLARIUM, EnergyType.EXPERIENCE});
    }

    @Override
    public boolean acceptsCoolFrom(ICoolEmitter var1, EnumFacing var2) {
        return true;
    }

    @Override
    public boolean emitsCoolTo(ICoolAcceptor var1, EnumFacing var2) {
        return true;
    }

    @Override
    public boolean acceptsHeatFrom(IHeatEmitter var1, EnumFacing var2) {
        return true;
    }

    @Override
    public boolean emitsHeatTo(IHeatAcceptor var1, EnumFacing var2) {
        return true;
    }

    @Override
    public boolean acceptsFrom(IEmitter var1, EnumFacing var2) {
        return true;
    }

    @Override
    public boolean emitsTo(IAcceptor var1, EnumFacing var2) {
        return true;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }
}

