/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.transport.FluidHandler;
import com.denfop.api.transport.ITransportAcceptor;
import com.denfop.api.transport.ITransportConductor;
import com.denfop.api.transport.ITransportEmitter;
import com.denfop.api.transport.ITransportTile;
import com.denfop.api.transport.TransportFluidItemSinkSource;
import com.denfop.api.transport.TransportNetGlobal;
import com.denfop.api.transport.event.TransportTileLoadEvent;
import com.denfop.api.transport.event.TransportTileUnLoadEvent;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockItemPipes;
import com.denfop.container.SlotInfo;
import com.denfop.gui.GuiCable1;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.ICableItem;
import com.denfop.tiles.transport.types.ItemType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityItemPipes
extends TileEntityMultiCable
implements ITransportConductor {
    public final SlotInfo list;
    public boolean addedToEnergyNet = false;
    public ItemType cableType;
    private boolean needUpdate;

    public TileEntityItemPipes() {
        super(ItemType.itemcable);
        this.cableType = ItemType.itemcable;
        this.list = new SlotInfo(this, 18, !this.cableType.isItem());
    }

    public TileEntityItemPipes(ItemType cableType) {
        super(cableType);
        this.cableType = cableType;
        this.list = new SlotInfo(this, 18, !this.cableType.isItem());
    }

    public static TileEntityItemPipes delegate(ItemType cableType) {
        return new TileEntityItemPipes(cableType);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockItemPipes.item_pipes;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blockItemPipes;
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableType = ItemType.values[nbt.func_74771_c("cableType") & 0xFF];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("cableType", (byte)this.cableType.ordinal());
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            EnumFacing[] var4;
            for (EnumFacing dir : var4 = EnumFacing.field_82609_l) {
                TransportFluidItemSinkSource transport;
                boolean isSource;
                IItemHandler item_storage;
                ITransportTile transportTile;
                TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(dir));
                if (this.getBlackList().contains(dir) || tile == null) continue;
                if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir) && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())) {
                    transportTile = TransportNetGlobal.instance.getSubTile(this.field_145850_b, this.func_174877_v().func_177972_a(dir));
                    item_storage = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d());
                    IFluidHandler fluid_storage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d());
                    boolean isSink = false;
                    boolean isSource2 = false;
                    boolean isSinkFluid = false;
                    boolean isSourceFluid = false;
                    if (transportTile == null) {
                        ArrayList<EnumFacing> facingListSink = new ArrayList<EnumFacing>();
                        for (EnumFacing dir1 : var4) {
                            TileEntity tile2 = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir).func_177972_a(dir1));
                            if (!(tile2 instanceof ITransportConductor)) continue;
                            ITransportConductor transportConductor = (ITransportConductor)tile2;
                            if (transportConductor.isItem()) {
                                if (!transportConductor.isOutput()) {
                                    isSink = true;
                                    facingListSink.add(dir);
                                    continue;
                                }
                                isSource2 = true;
                                continue;
                            }
                            if (!transportConductor.isOutput()) {
                                isSinkFluid = true;
                                facingListSink.add(dir);
                                continue;
                            }
                            isSourceFluid = true;
                        }
                        TransportFluidItemSinkSource transport2 = new TransportFluidItemSinkSource(this.field_174879_c.func_177972_a(dir), item_storage, fluid_storage, isSink, isSource2, isSinkFluid, isSourceFluid);
                        transport2.setFacingListSink(facingListSink);
                        MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport2));
                        continue;
                    }
                    TransportFluidItemSinkSource transportFluidItemSinkSource = (TransportFluidItemSinkSource)transportTile;
                    if (this.isItem()) {
                        if (this.isOutput()) {
                            transportFluidItemSinkSource.setSource(true);
                        } else {
                            transportFluidItemSinkSource.setSink(true);
                            transportFluidItemSinkSource.canAdd(dir);
                        }
                    } else if (this.isOutput()) {
                        transportFluidItemSinkSource.setSourceFluid(true);
                    } else {
                        transportFluidItemSinkSource.setSinkFluid(true);
                        transportFluidItemSinkSource.canAdd(dir);
                    }
                    if (!transportFluidItemSinkSource.isNeed_update()) continue;
                    transportFluidItemSinkSource.setNeed_update(false);
                    isSink = transportFluidItemSinkSource.isSink();
                    isSource2 = transportFluidItemSinkSource.isSource();
                    isSinkFluid = transportFluidItemSinkSource.isSinkFluid();
                    isSourceFluid = transportFluidItemSinkSource.isSourceFluid();
                    BlockPos pos = transportFluidItemSinkSource.getBlockPos();
                    IItemHandler handler = transportFluidItemSinkSource.getItemHandler();
                    IFluidHandler fluidHandler = transportFluidItemSinkSource.getFluidHandler();
                    List<EnumFacing> enumFacings = transportFluidItemSinkSource.getFacingList();
                    MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), transportTile));
                    TransportFluidItemSinkSource trasport = new TransportFluidItemSinkSource(pos, handler, fluidHandler, isSink, isSource2, isSinkFluid, isSourceFluid);
                    trasport.setFacingListSink(enumFacings);
                    MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), trasport));
                    continue;
                }
                if (this.isItem() && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir)) {
                    transportTile = TransportNetGlobal.instance.getSubTile(this.field_145850_b, this.func_174877_v().func_177972_a(dir));
                    item_storage = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d());
                    boolean isSink = false;
                    isSource = false;
                    if (transportTile == null) {
                        ArrayList<EnumFacing> facingListSink = new ArrayList<EnumFacing>();
                        for (EnumFacing dir1 : var4) {
                            ITransportConductor transportConductor;
                            TileEntity tile2 = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir).func_177972_a(dir1));
                            if (!(tile2 instanceof ITransportConductor) || !(transportConductor = (ITransportConductor)tile2).isItem()) continue;
                            if (!transportConductor.isOutput()) {
                                isSink = true;
                                facingListSink.add(dir);
                                continue;
                            }
                            isSource = true;
                        }
                        TransportFluidItemSinkSource transport3 = new TransportFluidItemSinkSource(this.field_174879_c.func_177972_a(dir), item_storage, null, isSink, isSource, false, false);
                        transport3.setFacingListSink(facingListSink);
                        MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport3));
                        continue;
                    }
                    TransportFluidItemSinkSource transportFluidItemSinkSource = (TransportFluidItemSinkSource)transportTile;
                    if (this.isItem()) {
                        if (this.isOutput()) {
                            transportFluidItemSinkSource.setSource(true);
                        } else {
                            transportFluidItemSinkSource.setSink(true);
                            transportFluidItemSinkSource.canAdd(dir);
                        }
                    }
                    if (!transportFluidItemSinkSource.isNeed_update()) continue;
                    transportFluidItemSinkSource.setNeed_update(false);
                    isSink = transportFluidItemSinkSource.isSink();
                    isSource = transportFluidItemSinkSource.isSource();
                    boolean isSinkFluid = transportFluidItemSinkSource.isSinkFluid();
                    boolean isSourceFluid = transportFluidItemSinkSource.isSourceFluid();
                    BlockPos pos = transportFluidItemSinkSource.getBlockPos();
                    IItemHandler handler = transportFluidItemSinkSource.getItemHandler();
                    IFluidHandler fluidHandler = transportFluidItemSinkSource.getFluidHandler();
                    List<EnumFacing> enumFacings = transportFluidItemSinkSource.getFacingList();
                    MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), transportTile));
                    transport = new TransportFluidItemSinkSource(pos, handler, fluidHandler, isSink, isSource, isSinkFluid, isSourceFluid);
                    transport.setFacingListSink(enumFacings);
                    MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport));
                    continue;
                }
                if (this.isItem() || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())) continue;
                transportTile = TransportNetGlobal.instance.getSubTile(this.field_145850_b, this.func_174877_v().func_177972_a(dir));
                IFluidHandler fluid_storage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d());
                boolean isSink = false;
                isSource = false;
                boolean isSinkFluid = false;
                boolean isSourceFluid = false;
                if (transportTile == null) {
                    ArrayList<EnumFacing> facingListSink = new ArrayList<EnumFacing>();
                    for (EnumFacing dir1 : var4) {
                        ITransportConductor transportConductor;
                        TileEntity tile2 = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir).func_177972_a(dir1));
                        if (!(tile2 instanceof ITransportConductor) || (transportConductor = (ITransportConductor)tile2).isItem()) continue;
                        if (!transportConductor.isOutput()) {
                            isSinkFluid = true;
                            facingListSink.add(dir1);
                            continue;
                        }
                        isSourceFluid = true;
                    }
                    TransportFluidItemSinkSource transport4 = new TransportFluidItemSinkSource(this.field_174879_c.func_177972_a(dir), null, fluid_storage, isSink, isSource, isSinkFluid, isSourceFluid);
                    transport4.setFacingListSink(facingListSink);
                    MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport4));
                    continue;
                }
                TransportFluidItemSinkSource transportFluidItemSinkSource = (TransportFluidItemSinkSource)transportTile;
                if (!this.isItem()) {
                    if (this.isOutput()) {
                        transportFluidItemSinkSource.setSourceFluid(true);
                    } else {
                        transportFluidItemSinkSource.setSinkFluid(true);
                        transportFluidItemSinkSource.canAdd(dir);
                    }
                }
                if (!transportFluidItemSinkSource.isNeed_update()) continue;
                transportFluidItemSinkSource.setNeed_update(false);
                isSink = transportFluidItemSinkSource.isSink();
                isSource = transportFluidItemSinkSource.isSource();
                isSinkFluid = transportFluidItemSinkSource.isSinkFluid();
                isSourceFluid = transportFluidItemSinkSource.isSourceFluid();
                BlockPos pos = transportFluidItemSinkSource.getBlockPos();
                IItemHandler handler = transportFluidItemSinkSource.getItemHandler();
                IFluidHandler fluidHandler = transportFluidItemSinkSource.getFluidHandler();
                List<EnumFacing> enumFacings = transportFluidItemSinkSource.getFacingList();
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), transportTile));
                transport = new TransportFluidItemSinkSource(pos, handler, fluidHandler, isSink, isSource, isSinkFluid, isSourceFluid);
                transport.setFacingListSink(enumFacings);
                MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport));
            }
            if (this.cableType.isItem()) {
                MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), this));
            } else {
                MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), this));
            }
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (var2 < (double)EnumFacing.field_82609_l.length) {
            EnumFacing[] var4;
            super.updateTileServer(var1, var2);
            for (EnumFacing dir : var4 = EnumFacing.field_82609_l) {
                ITransportTile tile = TransportNetGlobal.instance.getSubTile(this.field_145850_b, this.field_174879_c.func_177972_a(dir));
                if (tile instanceof ITransportConductor || tile == null) continue;
                TransportFluidItemSinkSource transportFluidItemSinkSource = (TransportFluidItemSinkSource)tile;
                if (this.isItem()) {
                    if (this.isOutput()) {
                        transportFluidItemSinkSource.setSource(false);
                    } else {
                        transportFluidItemSinkSource.setSink(false);
                        transportFluidItemSinkSource.removeFacing(dir);
                    }
                } else if (this.isOutput()) {
                    transportFluidItemSinkSource.setSourceFluid(false);
                } else {
                    transportFluidItemSinkSource.setSinkFluid(false);
                    transportFluidItemSinkSource.removeFacing(dir);
                }
                if (transportFluidItemSinkSource.need_delete()) {
                    MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), tile));
                    continue;
                }
                if (!transportFluidItemSinkSource.isNeed_update()) continue;
                transportFluidItemSinkSource.setNeed_update(false);
                boolean isSink = transportFluidItemSinkSource.isSink();
                boolean isSource = transportFluidItemSinkSource.isSource();
                boolean isSinkFluid = transportFluidItemSinkSource.isSinkFluid();
                boolean isSourceFluid = transportFluidItemSinkSource.isSourceFluid();
                BlockPos pos = transportFluidItemSinkSource.getBlockPos();
                IItemHandler handler = transportFluidItemSinkSource.getItemHandler();
                IFluidHandler fluidHandler = transportFluidItemSinkSource.getFluidHandler();
                List<EnumFacing> enumFacings = transportFluidItemSinkSource.getFacingList();
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), tile));
                TransportFluidItemSinkSource transport = new TransportFluidItemSinkSource(pos, handler, fluidHandler, isSink, isSource, isSinkFluid, isSourceFluid);
                transport.setFacingListSink(enumFacings);
                MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport));
            }
            if (this.cableType.isItem()) {
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), this));
            } else {
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), this));
            }
            this.needUpdate = true;
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            EnumFacing[] var4;
            for (EnumFacing dir : var4 = EnumFacing.field_82609_l) {
                TransportFluidItemSinkSource transport;
                boolean isSource;
                IItemHandler item_storage;
                ITransportTile transportTile;
                TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(dir));
                if (tile == null) continue;
                if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir) && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())) {
                    transportTile = TransportNetGlobal.instance.getSubTile(this.field_145850_b, this.func_174877_v().func_177972_a(dir));
                    item_storage = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d());
                    IFluidHandler fluid_storage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d());
                    boolean isSink = false;
                    boolean isSource2 = false;
                    boolean isSinkFluid = false;
                    boolean isSourceFluid = false;
                    if (transportTile == null) {
                        ArrayList<EnumFacing> facingListSink = new ArrayList<EnumFacing>();
                        for (EnumFacing dir1 : var4) {
                            TileEntity tile2 = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir).func_177972_a(dir1));
                            if (!(tile2 instanceof ITransportConductor)) continue;
                            ITransportConductor transportConductor = (ITransportConductor)tile2;
                            if (transportConductor.isItem()) {
                                if (!transportConductor.isOutput()) {
                                    isSink = true;
                                    facingListSink.add(dir);
                                    continue;
                                }
                                isSource2 = true;
                                continue;
                            }
                            if (!transportConductor.isOutput()) {
                                isSinkFluid = true;
                                facingListSink.add(dir);
                                continue;
                            }
                            isSourceFluid = true;
                        }
                        TransportFluidItemSinkSource transport2 = new TransportFluidItemSinkSource(this.field_174879_c.func_177972_a(dir), item_storage, fluid_storage, isSink, isSource2, isSinkFluid, isSourceFluid);
                        transport2.setFacingListSink(facingListSink);
                        MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport2));
                        continue;
                    }
                    TransportFluidItemSinkSource transportFluidItemSinkSource = (TransportFluidItemSinkSource)transportTile;
                    if (this.isItem()) {
                        if (this.isOutput()) {
                            transportFluidItemSinkSource.setSource(true);
                        } else {
                            transportFluidItemSinkSource.setSink(true);
                            transportFluidItemSinkSource.canAdd(dir);
                        }
                    } else if (this.isOutput()) {
                        transportFluidItemSinkSource.setSourceFluid(true);
                    } else {
                        transportFluidItemSinkSource.setSinkFluid(true);
                        transportFluidItemSinkSource.canAdd(dir);
                    }
                    if (!transportFluidItemSinkSource.isNeed_update()) continue;
                    transportFluidItemSinkSource.setNeed_update(false);
                    isSink = transportFluidItemSinkSource.isSink();
                    isSource2 = transportFluidItemSinkSource.isSource();
                    isSinkFluid = transportFluidItemSinkSource.isSinkFluid();
                    isSourceFluid = transportFluidItemSinkSource.isSourceFluid();
                    BlockPos pos = transportFluidItemSinkSource.getBlockPos();
                    IItemHandler handler = transportFluidItemSinkSource.getItemHandler();
                    IFluidHandler fluidHandler = transportFluidItemSinkSource.getFluidHandler();
                    List<EnumFacing> enumFacings = transportFluidItemSinkSource.getFacingList();
                    MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), transportTile));
                    TransportFluidItemSinkSource trasport = new TransportFluidItemSinkSource(pos, handler, fluidHandler, isSink, isSource2, isSinkFluid, isSourceFluid);
                    trasport.setFacingListSink(enumFacings);
                    MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), trasport));
                    continue;
                }
                if (this.isItem() && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir)) {
                    transportTile = TransportNetGlobal.instance.getSubTile(this.field_145850_b, this.func_174877_v().func_177972_a(dir));
                    item_storage = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d());
                    boolean isSink = false;
                    isSource = false;
                    if (transportTile == null) {
                        ArrayList<EnumFacing> facingListSink = new ArrayList<EnumFacing>();
                        for (EnumFacing dir1 : var4) {
                            ITransportConductor transportConductor;
                            TileEntity tile2 = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir).func_177972_a(dir1));
                            if (!(tile2 instanceof ITransportConductor) || !(transportConductor = (ITransportConductor)tile2).isItem()) continue;
                            if (!transportConductor.isOutput()) {
                                isSink = true;
                                facingListSink.add(dir);
                                continue;
                            }
                            isSource = true;
                        }
                        TransportFluidItemSinkSource transport3 = new TransportFluidItemSinkSource(this.field_174879_c.func_177972_a(dir), item_storage, null, isSink, isSource, false, false);
                        transport3.setFacingListSink(facingListSink);
                        MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport3));
                        continue;
                    }
                    TransportFluidItemSinkSource transportFluidItemSinkSource = (TransportFluidItemSinkSource)transportTile;
                    if (this.isItem()) {
                        if (this.isOutput()) {
                            transportFluidItemSinkSource.setSource(true);
                        } else {
                            transportFluidItemSinkSource.setSink(true);
                            transportFluidItemSinkSource.canAdd(dir);
                        }
                    }
                    if (!transportFluidItemSinkSource.isNeed_update()) continue;
                    transportFluidItemSinkSource.setNeed_update(false);
                    isSink = transportFluidItemSinkSource.isSink();
                    isSource = transportFluidItemSinkSource.isSource();
                    boolean isSinkFluid = transportFluidItemSinkSource.isSinkFluid();
                    boolean isSourceFluid = transportFluidItemSinkSource.isSourceFluid();
                    BlockPos pos = transportFluidItemSinkSource.getBlockPos();
                    IItemHandler handler = transportFluidItemSinkSource.getItemHandler();
                    IFluidHandler fluidHandler = transportFluidItemSinkSource.getFluidHandler();
                    List<EnumFacing> enumFacings = transportFluidItemSinkSource.getFacingList();
                    MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), transportTile));
                    transport = new TransportFluidItemSinkSource(pos, handler, fluidHandler, isSink, isSource, isSinkFluid, isSourceFluid);
                    transport.setFacingListSink(enumFacings);
                    MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport));
                    continue;
                }
                if (this.isItem() || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())) continue;
                transportTile = TransportNetGlobal.instance.getSubTile(this.field_145850_b, this.func_174877_v().func_177972_a(dir));
                IFluidHandler fluid_storage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d());
                boolean isSink = false;
                isSource = false;
                boolean isSinkFluid = false;
                boolean isSourceFluid = false;
                if (transportTile == null) {
                    ArrayList<EnumFacing> facingListSink = new ArrayList<EnumFacing>();
                    for (EnumFacing dir1 : var4) {
                        ITransportConductor transportConductor;
                        TileEntity tile2 = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir).func_177972_a(dir1));
                        if (!(tile2 instanceof ITransportConductor) || (transportConductor = (ITransportConductor)tile2).isItem()) continue;
                        if (!transportConductor.isOutput()) {
                            isSinkFluid = true;
                            facingListSink.add(dir1);
                            continue;
                        }
                        isSourceFluid = true;
                    }
                    TransportFluidItemSinkSource transport4 = new TransportFluidItemSinkSource(this.field_174879_c.func_177972_a(dir), null, fluid_storage, isSink, isSource, isSinkFluid, isSourceFluid);
                    transport4.setFacingListSink(facingListSink);
                    MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport4));
                    continue;
                }
                TransportFluidItemSinkSource transportFluidItemSinkSource = (TransportFluidItemSinkSource)transportTile;
                if (!this.isItem()) {
                    if (this.isOutput()) {
                        transportFluidItemSinkSource.setSourceFluid(true);
                    } else {
                        transportFluidItemSinkSource.setSinkFluid(true);
                        transportFluidItemSinkSource.canAdd(dir);
                    }
                }
                if (!transportFluidItemSinkSource.isNeed_update()) continue;
                transportFluidItemSinkSource.setNeed_update(false);
                isSink = transportFluidItemSinkSource.isSink();
                isSource = transportFluidItemSinkSource.isSource();
                isSinkFluid = transportFluidItemSinkSource.isSinkFluid();
                isSourceFluid = transportFluidItemSinkSource.isSourceFluid();
                BlockPos pos = transportFluidItemSinkSource.getBlockPos();
                IItemHandler handler = transportFluidItemSinkSource.getItemHandler();
                IFluidHandler fluidHandler = transportFluidItemSinkSource.getFluidHandler();
                List<EnumFacing> enumFacings = transportFluidItemSinkSource.getFacingList();
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), transportTile));
                transport = new TransportFluidItemSinkSource(pos, handler, fluidHandler, isSink, isSource, isSinkFluid, isSourceFluid);
                transport.setFacingListSink(enumFacings);
                MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport));
            }
            if (this.cableType.isItem()) {
                MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), this));
            } else {
                MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), this));
            }
            this.updateConnectivity();
            this.needUpdate = false;
        }
    }

    @Override
    public void onUnloaded() {
        if (IUCore.proxy.isSimulating() && this.addedToEnergyNet) {
            EnumFacing[] var4;
            for (EnumFacing dir : var4 = EnumFacing.field_82609_l) {
                ITransportTile tile = TransportNetGlobal.instance.getSubTile(this.field_145850_b, this.field_174879_c.func_177972_a(dir));
                if (tile instanceof ITransportConductor || tile == null) continue;
                TransportFluidItemSinkSource transportFluidItemSinkSource = (TransportFluidItemSinkSource)tile;
                if (this.isItem()) {
                    if (this.isOutput()) {
                        transportFluidItemSinkSource.setSource(false);
                    } else {
                        transportFluidItemSinkSource.setSink(false);
                        transportFluidItemSinkSource.removeFacing(dir);
                    }
                } else if (this.isOutput()) {
                    transportFluidItemSinkSource.setSourceFluid(false);
                } else {
                    transportFluidItemSinkSource.setSinkFluid(false);
                    transportFluidItemSinkSource.removeFacing(dir);
                }
                if (transportFluidItemSinkSource.need_delete()) {
                    MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), tile));
                    continue;
                }
                if (!transportFluidItemSinkSource.isNeed_update()) continue;
                transportFluidItemSinkSource.setNeed_update(false);
                boolean isSink = transportFluidItemSinkSource.isSink();
                boolean isSource = transportFluidItemSinkSource.isSource();
                boolean isSinkFluid = transportFluidItemSinkSource.isSinkFluid();
                boolean isSourceFluid = transportFluidItemSinkSource.isSourceFluid();
                BlockPos pos = transportFluidItemSinkSource.getBlockPos();
                IItemHandler handler = transportFluidItemSinkSource.getItemHandler();
                IFluidHandler fluidHandler = transportFluidItemSinkSource.getFluidHandler();
                List<EnumFacing> enumFacings = transportFluidItemSinkSource.getFacingList();
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), tile));
                TransportFluidItemSinkSource transport = new TransportFluidItemSinkSource(pos, handler, fluidHandler, isSink, isSource, isSinkFluid, isSourceFluid);
                transport.setFacingListSink(enumFacings);
                MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(this.func_145831_w(), transport));
            }
            if (this.cableType.isItem()) {
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), this));
            } else {
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.func_145831_w(), this));
            }
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return new ItemStack((Item)IUItem.item_pipes, 1, this.cableType.ordinal());
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (!this.func_145831_w().field_72995_K) {
            this.updateConnectivity();
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        if (var1.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == IUItem.connect_item) {
            return super.getGui(var1, var2);
        }
        return new GuiCable1(this.getGuiContainer(var1));
    }

    @Override
    public void updateConnectivity() {
        EnumFacing[] var4;
        World world = this.func_145831_w();
        byte newConnectivity = 0;
        for (EnumFacing dir : var4 = EnumFacing.field_82609_l) {
            newConnectivity = (byte)(newConnectivity << 1);
            ITransportTile tile = TransportNetGlobal.instance.getSubTile(world, this.field_174879_c.func_177972_a(dir));
            if (this.getBlackList().contains(dir) || (!(tile instanceof ITransportAcceptor) || !((ITransportAcceptor)tile).acceptsFrom(this, dir.func_176734_d())) && (!(tile instanceof ITransportEmitter) || !((ITransportEmitter)tile).emitsTo(this, dir.func_176734_d()))) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean isOutput() {
        return this.cableType.isOutput;
    }

    @Override
    public void update_render() {
        this.updateConnectivity();
    }

    @Override
    public boolean isItem() {
        return this.cableType.isItem();
    }

    @Override
    public List<ItemStack> getBlackListItems() {
        return this.list.getContents().subList(0, 9).stream().filter(item -> !item.func_190926_b()).collect(Collectors.toList());
    }

    @Override
    public List<ItemStack> getWhiteListItems() {
        return this.list.getContents().subList(9, this.list.size()).stream().filter(item -> !item.func_190926_b()).collect(Collectors.toList());
    }

    @Override
    public List<FluidStack> getBlackListFluids() {
        return this.list.getFluidStackList().subList(0, 9).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<FluidStack> getWhiteListFluids() {
        return this.list.getFluidStackList().subList(9, this.list.size()).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
            EncoderHandler.encode(packet, this.list.isFluid());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = ItemType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.list.setFluid((Boolean)DecoderHandler.decode(customPacketBuffer));
            this.rerender();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onNetworkEvent(int event) {
        World world = this.func_145831_w();
        if (event == 0) {
            world.func_184133_a(null, this.field_174879_c, SoundEvents.field_187658_bx, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + Math.random(), (double)this.field_174879_c.func_177956_o() + 1.2, (double)this.field_174879_c.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean acceptsFrom(ITransportEmitter var1, EnumFacing var2) {
        if (this.getBlackList().contains(var2)) {
            return false;
        }
        if (this.cableType.isItem()) {
            return var1.getHandler() instanceof IItemHandler;
        }
        return var1.getHandler() instanceof IFluidHandler;
    }

    @Override
    public boolean emitsTo(ITransportAcceptor var1, EnumFacing var2) {
        if (this.getBlackList().contains(var2)) {
            return false;
        }
        if (this.cableType.isItem()) {
            return var1.getHandler() instanceof IItemHandler;
        }
        return var1.getHandler() instanceof IFluidHandler;
    }

    @Override
    public Object getHandler() {
        if (this.cableType.isItem()) {
            return new ItemStackHandler();
        }
        return new FluidHandler();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.field_174879_c;
    }
}

