/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.cool.CoolNet;
import com.denfop.api.cool.ICoolAcceptor;
import com.denfop.api.cool.ICoolConductor;
import com.denfop.api.cool.ICoolEmitter;
import com.denfop.api.cool.ICoolTile;
import com.denfop.api.cool.event.CoolTileLoadEvent;
import com.denfop.api.cool.event.CoolTileUnloadEvent;
import com.denfop.api.heat.HeatNet;
import com.denfop.api.heat.IHeatAcceptor;
import com.denfop.api.heat.IHeatConductor;
import com.denfop.api.heat.IHeatEmitter;
import com.denfop.api.heat.IHeatTile;
import com.denfop.api.heat.event.HeatTileLoadEvent;
import com.denfop.api.heat.event.HeatTileUnloadEvent;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockHeatColdPipes;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketCableSound;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.HeatColdType;
import com.denfop.tiles.transport.types.ICableItem;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityHeatColdPipes
extends TileEntityMultiCable
implements ICoolConductor,
IHeatConductor {
    public boolean addedToEnergyNet;
    protected HeatColdType cableType;
    private boolean needUpdate;

    public TileEntityHeatColdPipes(HeatColdType cableType) {
        super(cableType);
        this.cableType = cableType;
        this.connectivity = 0;
        this.addedToEnergyNet = false;
    }

    public TileEntityHeatColdPipes() {
        super(HeatColdType.heatcool);
        this.cableType = HeatColdType.heatcool;
        this.connectivity = 0;
        this.addedToEnergyNet = false;
    }

    public static TileEntityHeatColdPipes delegate(HeatColdType cableType) {
        return new TileEntityHeatColdPipes(cableType);
    }

    public static TileEntityHeatColdPipes delegate() {
        return new TileEntityHeatColdPipes();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockHeatColdPipes.heatcold;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.heatcoolpipesblock;
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.field_174879_c;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableType = HeatColdType.values[nbt.func_74771_c("cableType") & 0xFF];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("cableType", (byte)this.cableType.ordinal());
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.func_145831_w()));
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.func_145831_w()));
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        super.updateTileServer(var1, var2);
        MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this, this.func_145831_w()));
        MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this, this.func_145831_w()));
        this.needUpdate = true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.func_145831_w()));
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.func_145831_w()));
            this.needUpdate = false;
            this.updateConnectivity();
        }
    }

    @Override
    public void onUnloaded() {
        if (IUCore.proxy.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this, this.func_145831_w()));
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this, this.func_145831_w()));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public SoundType getBlockSound(Entity entity) {
        return SoundType.field_185854_g;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return new ItemStack((Item)IUItem.heatcold_pipes, 1, this.cableType.ordinal());
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (!this.func_145831_w().field_72995_K) {
            this.updateConnectivity();
        }
    }

    @Override
    public void updateConnectivity() {
        EnumFacing[] var4;
        World world = this.func_145831_w();
        byte newConnectivity = 0;
        for (EnumFacing dir : var4 = EnumFacing.field_82609_l) {
            newConnectivity = (byte)(newConnectivity << 1);
            ICoolTile tile = CoolNet.instance.getSubTile(world, this.field_174879_c.func_177972_a(dir));
            if (this.getBlackList().contains(dir)) continue;
            if (tile != null) {
                if ((!(tile instanceof ICoolAcceptor) || !((ICoolAcceptor)tile).acceptsCoolFrom(this, dir.func_176734_d())) && (!(tile instanceof ICoolEmitter) || !((ICoolEmitter)tile).emitsCoolTo(this, dir.func_176734_d())) || !this.canInteractWith()) continue;
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            IHeatTile heatTile = HeatNet.instance.getSubTile(world, this.field_174879_c.func_177972_a(dir));
            if ((!(heatTile instanceof IHeatAcceptor) || !((IHeatAcceptor)heatTile).acceptsHeatFrom(this, dir.func_176734_d())) && (!(heatTile instanceof IHeatEmitter) || !((IHeatEmitter)heatTile).emitsHeatTo(this, dir.func_176734_d())) || !this.canInteractWith()) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer player) {
        return false;
    }

    public boolean canInteractWith() {
        return true;
    }

    @Override
    public double getConductorBreakdownHeat() {
        return this.cableType.capacity1 + 1.0;
    }

    @Override
    public double getConductorBreakdownCold() {
        return this.cableType.capacity + 1.0;
    }

    @Override
    public void removeConductor() {
        this.func_145831_w().func_175698_g(this.field_174879_c);
        new PacketCableSound(this.func_145831_w(), this.field_174879_c, 0.5, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
    }

    @Override
    public void update_render() {
        if (!this.func_145831_w().field_72995_K) {
            this.updateConnectivity();
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = HeatColdType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.rerender();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean acceptsCoolFrom(ICoolEmitter var1, EnumFacing var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean emitsCoolTo(ICoolAcceptor var1, EnumFacing var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean acceptsHeatFrom(IHeatEmitter var1, EnumFacing var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean emitsHeatTo(IHeatAcceptor var1, EnumFacing var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public TileEntity getTile() {
        return this;
    }
}

