/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.graphite.cooling;

import com.denfop.api.reactors.IGraphiteReactor;
import com.denfop.componets.CoolComponent;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.reactors.graphite.ICooling;

public class TileEntityCoolant
extends TileEntityMultiBlockElement
implements ICooling {
    private final int level;
    public final CoolComponent cold;
    private IGraphiteReactor gasReactor;

    public TileEntityCoolant(int level) {
        this.level = level;
        this.cold = this.addComponent(CoolComponent.asBasicSource(this, 8.0 * Math.pow(2.0, this.level), 14));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getMain() != null) {
            this.gasReactor = (IGraphiteReactor)this.getMain();
            if (this.gasReactor.getEnergy() != null && this.gasReactor.getEnergy().getEnergy() >= 30.0 && this.cold.getEnergy() < this.cold.getCapacity()) {
                this.cold.addEnergy(1.0);
                this.gasReactor.getEnergy().useEnergy(30.0);
            }
            if (this.func_145831_w().func_72820_D() % 40L == 0L && this.cold.getEnergy() > 0.0) {
                this.cold.useEnergy(1.0);
            }
        }
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public double work(double heat) {
        return Math.max(1.0, heat - (double)this.func_145831_w().field_73012_v.nextInt(40 * (this.level + 1)));
    }
}

