/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.gas.coolant;

import com.denfop.api.reactors.IGasReactor;
import com.denfop.componets.CoolComponent;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.reactors.gas.ICoolant;

public class TileEntityCoolant
extends TileEntityMultiBlockElement
implements ICoolant {
    private final int level;
    public final CoolComponent cold;
    private IGasReactor gasReactor;

    public TileEntityCoolant(int level) {
        this.level = level;
        this.cold = this.addComponent(CoolComponent.asBasicSource(this, 8.0 * Math.pow(2.0, this.level), 14));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getMain() != null) {
            this.gasReactor = (IGasReactor)this.getMain();
            if (this.gasReactor.getEnergy() != null && this.gasReactor.getEnergy().getEnergy() >= 30.0 && this.cold.getEnergy() < this.cold.getCapacity()) {
                this.cold.addEnergy(1.0);
                this.gasReactor.getEnergy().useEnergy(30.0);
            }
            if (this.func_145831_w().func_72820_D() % 40L == 0L && this.cold.getEnergy() > 0.0) {
                this.cold.useEnergy(1.0);
            }
        }
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public void setGasReactor(IGasReactor gasReactor) {
        this.gasReactor = gasReactor;
    }

    @Override
    public double getLevelRefrigerator() {
        return this.cold.getEnergy();
    }
}

