/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.gas.compressor;

import com.denfop.container.ContainerCompressor;
import com.denfop.gui.GuiCompressor;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.reactors.gas.ICompressor;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBaseCompressor
extends TileEntityMultiBlockElement
implements ICompressor,
IUpdatableTileEvent {
    private final int level;
    private int pressure;

    public TileEntityBaseCompressor(int level) {
        this.level = level;
        this.pressure = 1;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.pressure = customPacketBuffer.readInt();
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.pressure);
        return customPacketBuffer;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.pressure = nbtTagCompound.func_74762_e("pressure");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_74768_a("pressure", this.pressure);
        return nbtTagCompound;
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    public ContainerCompressor getGuiContainer(EntityPlayer var1) {
        return new ContainerCompressor(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiCompressor(this.getGuiContainer(var1));
    }

    @Override
    public int getEnergy() {
        return this.pressure * 5;
    }

    @Override
    public int getPressure() {
        return this.pressure;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        this.pressure = var2 == 0.0 ? Math.min(this.level + 1, this.pressure + 1) : Math.max(1, this.pressure - 1);
    }
}

