/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.quarry_earth;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockEarthQuarry;
import com.denfop.container.ContainerEarthAnalyzer;
import com.denfop.gui.GuiEarthAnalyzer;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.quarry_earth.DataPos;
import com.denfop.tiles.quarry_earth.IAnalyzer;
import com.denfop.tiles.quarry_earth.TileEntityEarthQuarryController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityEarthQuarryAnalyzer
extends TileEntityMultiBlockElement
implements IAnalyzer,
IUpdatableTileEvent {
    private boolean analyzer;
    private boolean fullAnalyzer;
    Map<ChunkPos, List<DataPos>> chunkPosListHashMap = new HashMap<ChunkPos, List<DataPos>>();
    private ChunkPos chunkPos;
    int x = -1;
    int z = -1;

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.earthQuarry;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockEarthQuarry.earth_analyzer;
    }

    public ContainerEarthAnalyzer getGuiContainer(EntityPlayer var1) {
        return new ContainerEarthAnalyzer(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiEarthAnalyzer(this.getGuiContainer(var1));
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.analyzer);
        customPacketBuffer.writeBoolean(this.fullAnalyzer);
        return customPacketBuffer;
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.analyzer = customPacketBuffer.readBoolean();
        this.fullAnalyzer = customPacketBuffer.readBoolean();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("analyzer", this.analyzer);
        nbt.func_74757_a("fullAnalyzer", this.fullAnalyzer);
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.analyzer = nbtTagCompound.func_74767_n("analyzer");
        this.fullAnalyzer = nbtTagCompound.func_74767_n("fullAnalyzer");
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.chunkPos = this.field_145850_b.func_175726_f(this.field_174879_c).func_76632_l();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().field_73011_w.getWorldTime() % 10L == 0L) {
            if (this.analyzer && !this.fullAnalyzer && this.getMain() != null) {
                TileEntityEarthQuarryController controller;
                if (this.z == 2) {
                    if (!this.chunkPosListHashMap.isEmpty()) {
                        this.fullAnalyzer = true;
                        controller = (TileEntityEarthQuarryController)this.getMain();
                        controller.map = this.chunkPosListHashMap;
                        controller.chunkPosList = new ArrayList<ChunkPos>(this.chunkPosListHashMap.keySet());
                    }
                    this.analyzer = false;
                }
                controller = (TileEntityEarthQuarryController)this.getMain();
                Chunk chunk1 = this.field_145850_b.func_72964_e(this.chunkPos.field_77276_a + this.x, this.chunkPos.field_77275_b + this.z);
                if (!TileEntityEarthQuarryController.chunkPos.contains(chunk1.func_76632_l())) {
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            int height = chunk1.func_76611_b(chunk1.func_76632_l().field_77276_a * 16 + x & 0xF, chunk1.func_76632_l().field_77275_b * 16 + z & 0xF);
                            for (int y = 0; y < 10; ++y) {
                                if (!(controller.getEnergy().getEnergy() > 20.0)) continue;
                                controller.getEnergy().useEnergy(20.0);
                                BlockPos pos = new BlockPos(chunk1.func_76632_l().field_77276_a * 16 + x, height - y, chunk1.func_76632_l().field_77275_b * 16 + z);
                                IBlockState state = this.field_145850_b.func_180495_p(pos);
                                if (state.func_177230_c() != Blocks.field_150346_d && state.func_177230_c() != Blocks.field_150351_n && state.func_177230_c() != Blocks.field_150354_m) continue;
                                List dataPos = this.chunkPosListHashMap.getOrDefault(chunk1.func_76632_l(), new ArrayList());
                                if (dataPos.isEmpty()) {
                                    dataPos.add(new DataPos(pos, state));
                                    this.chunkPosListHashMap.put(chunk1.func_76632_l(), dataPos);
                                    continue;
                                }
                                dataPos.add(new DataPos(pos, state));
                            }
                        }
                    }
                    if (this.x < 1) {
                        ++this.x;
                    } else {
                        ++this.z;
                        this.x = -1;
                    }
                } else if (this.x < 1) {
                    ++this.x;
                } else {
                    ++this.z;
                    this.x = -1;
                }
            } else {
                this.analyzer = false;
            }
        }
    }

    @Override
    public boolean isAnalyzed() {
        return this.analyzer;
    }

    @Override
    public boolean fullAnalyzed() {
        return this.fullAnalyzer;
    }

    @Override
    public Map<ChunkPos, List<DataPos>> getChunkPoses() {
        return this.chunkPosListHashMap;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (var2 == 0.0 && this.getMain() != null && !this.analyzer) {
            this.analyzer = true;
            this.x = -1;
            this.z = -1;
            this.chunkPosListHashMap.clear();
        }
    }
}

