/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.solardestiller;

import com.denfop.api.gui.IType;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.FluidName;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerSolarDestiller;
import com.denfop.gui.GuiSolarDestiller;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotTank;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBaseSolarDestiller
extends TileEntityInventory
implements IUpgradableBlock,
IType {
    public final FluidTank inputTank;
    public final FluidTank outputTank;
    public final InvSlotOutput wateroutputSlot;
    public final InvSlotOutput destiwateroutputSlott;
    public final InvSlotFluidByList waterinputSlot;
    public final InvSlotTank destiwaterinputSlot;
    public final InvSlotUpgrade upgradeSlot;
    protected final Fluids fluids = this.addComponent(new Fluids(this));
    private final EnumTypeStyle style;
    private int tickrate;
    private boolean skyLight;
    private boolean hasSky;

    public TileEntityBaseSolarDestiller(EnumTypeStyle style) {
        this.style = style;
        this.inputTank = this.fluids.addTankInsert("inputTank", 10000, Fluids.fluidPredicate(FluidRegistry.WATER));
        this.outputTank = this.fluids.addTankExtract("outputTank", 10000);
        this.waterinputSlot = new InvSlotFluidByList(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.INPUT, FluidRegistry.WATER);
        this.destiwaterinputSlot = new InvSlotTank(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT, (IFluidTank)this.outputTank);
        this.wateroutputSlot = new InvSlotOutput(this, 1);
        this.destiwateroutputSlott = new InvSlotOutput(this, 1);
        this.upgradeSlot = new InvSlotUpgrade(this, 3);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.tickrate = this.getTickRate();
        this.hasSky = !this.field_145850_b.field_73011_w.func_177495_o();
        this.updateVisibility();
    }

    public void updateVisibility() {
        this.skyLight = this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) && this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_185904_a().func_151565_r() == MapColor.field_151660_b && this.hasSky && this.field_145850_b.func_72935_r();
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.skyLight = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.skyLight);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.waterinputSlot.processIntoTank((IFluidTank)this.inputTank, this.wateroutputSlot);
        if (this.func_145831_w().field_73011_w.getWorldTime() % 40L == 0L) {
            this.updateVisibility();
        }
        this.destiwaterinputSlot.processFromTank((IFluidTank)this.outputTank, this.destiwateroutputSlott);
        if (!this.skyLight) {
            return;
        }
        if (this.func_145831_w().field_73011_w.getWorldTime() % (long)this.tickrate == 0L && this.canWork()) {
            this.inputTank.drainInternal(1, true);
            this.outputTank.fillInternal(new FluidStack(FluidName.fluiddistilled_water.getInstance(), 1), true);
        }
        this.upgradeSlot.tickNoMark();
    }

    public ContainerSolarDestiller getGuiContainer(EntityPlayer player) {
        return new ContainerSolarDestiller(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiSolarDestiller(new ContainerSolarDestiller(player, this));
    }

    public int getTickRate() {
        Biome biome = this.field_145850_b.func_180494_b(this.field_174879_c);
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT)) {
            switch (this.style) {
                case DEFAULT: {
                    return 36;
                }
                case ADVANCED: {
                    return 30;
                }
                case IMPROVED: {
                    return 24;
                }
                case PERFECT: {
                    return 15;
                }
            }
        } else {
            switch (this.style) {
                case DEFAULT: {
                    return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) ? 144 : 72;
                }
                case ADVANCED: {
                    return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) ? 120 : 60;
                }
                case IMPROVED: {
                    return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) ? 96 : 48;
                }
                case PERFECT: {
                    return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) ? 60 : 30;
                }
            }
        }
        return 0;
    }

    public int gaugeLiquidScaled(int i, int tank) {
        switch (tank) {
            case 0: {
                if (this.inputTank.getFluidAmount() <= 0) {
                    return 0;
                }
                return this.inputTank.getFluidAmount() * i / this.inputTank.getCapacity();
            }
            case 1: {
                if (this.outputTank.getFluidAmount() <= 0) {
                    return 0;
                }
                return this.outputTank.getFluidAmount() * i / this.outputTank.getCapacity();
            }
        }
        return 0;
    }

    public boolean canWork() {
        return this.inputTank.getFluidAmount() > 0 && this.outputTank.getFluidAmount() < this.outputTank.getCapacity() && this.skyLight;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidProducing, UpgradableProperty.FluidConsuming);
    }

    @Override
    public EnumTypeStyle getStyle() {
        return this.style;
    }
}

