/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.quarry;

import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class QuarryItem {
    private final ItemStack stack;
    private final String oreDict;

    public QuarryItem(ItemStack stack) {
        this.stack = stack;
        this.oreDict = OreDictionary.getOreIDs((ItemStack)stack).length > 0 ? OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)stack)[0]) : "";
    }

    public QuarryItem(ItemStack stack, String oreDict) {
        this.stack = stack;
        this.oreDict = oreDict;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuarryItem that = (QuarryItem)o;
        return this.stack.func_77969_a(that.getStack());
    }

    public int hashCode() {
        return Objects.hash(this.stack, this.oreDict);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public String getOreDict() {
        return this.oreDict;
    }

    public boolean isGem() {
        return this.getOreDict().startsWith("gem");
    }

    public boolean isShard() {
        return this.getOreDict().startsWith("shard");
    }
}

