/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.multiblocks.base;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.multiblock.IMainMultiBlock;
import com.denfop.api.multiblock.MultiBlockStructure;
import com.denfop.container.ContainerBase;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileMultiBlockBase
extends TileEntityInventory
implements IMainMultiBlock,
IUpdatableTileEvent {
    private final MultiBlockStructure multiBlockStructure;
    public boolean full;
    public boolean activate;
    public List<EntityPlayer> entityPlayerList;

    public TileMultiBlockBase(MultiBlockStructure multiBlockStructure) {
        this.multiBlockStructure = multiBlockStructure;
        this.full = false;
        this.entityPlayerList = new ArrayList<EntityPlayer>();
        this.activate = false;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.full);
            EncoderHandler.encode(packet, this.activate);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.full = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.activate = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(TileMultiBlockBase tileEntityMultiBlockBase, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!this.isFull()) {
            this.renderBlock(tileEntityMultiBlockBase, x, y, z, partialTicks, destroyStage, alpha);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderBlock(TileMultiBlockBase tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        for (Map.Entry<BlockPos, ItemStack> entry : this.multiBlockStructure.ItemStackMap.entrySet()) {
            BlockPos pos1;
            if (entry.getValue().func_190926_b()) continue;
            EnumFacing rotation = this.multiBlockStructure.RotationMap.get(entry.getKey());
            switch (this.getFacing()) {
                case NORTH: {
                    pos1 = new BlockPos(entry.getKey().func_177958_n(), entry.getKey().func_177956_o(), entry.getKey().func_177952_p());
                    break;
                }
                case EAST: {
                    pos1 = new BlockPos(entry.getKey().func_177952_p() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177958_n());
                    break;
                }
                case WEST: {
                    pos1 = new BlockPos(entry.getKey().func_177952_p(), entry.getKey().func_177956_o(), entry.getKey().func_177958_n() * -1);
                    break;
                }
                case SOUTH: {
                    pos1 = new BlockPos(entry.getKey().func_177958_n() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177952_p() * -1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + this.getFacing());
                }
            }
            ItemStack item = entry.getValue();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)pos1.func_177958_n(), (double)(0.5 + (double)pos1.func_177956_o()), (double)pos1.func_177952_p());
            if (rotation != null && rotation != this.getFacing()) {
                block6 : switch (this.getFacing()) {
                    case NORTH: {
                        switch (rotation) {
                            case SOUTH: {
                                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break;
                            }
                            case NORTH: {
                                break;
                            }
                            case WEST: {
                                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break;
                            }
                            case EAST: {
                                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                            }
                        }
                        break;
                    }
                    case SOUTH: {
                        switch (rotation) {
                            case SOUTH: {
                                break;
                            }
                            case NORTH: {
                                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break;
                            }
                            case WEST: {
                                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break;
                            }
                            case EAST: {
                                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                            }
                        }
                        break;
                    }
                    case WEST: {
                        switch (rotation) {
                            case SOUTH: {
                                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break;
                            }
                            case NORTH: {
                                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break;
                            }
                            case WEST: {
                                break;
                            }
                            case EAST: {
                                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                            }
                        }
                        break;
                    }
                    case EAST: {
                        switch (rotation) {
                            case SOUTH: {
                                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break block6;
                            }
                            case NORTH: {
                                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break block6;
                            }
                            case WEST: {
                                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                break block6;
                            }
                        }
                    }
                }
            }
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            IBakedModel itemModel = this.multiBlockStructure.bakedModelMap.get(entry.getKey());
            if (itemModel == null) {
                itemModel = renderItem.func_184393_a(item, tile.func_145831_w(), null);
                this.multiBlockStructure.bakedModelMap.put(entry.getKey(), itemModel);
            }
            renderItem.func_180454_a(item, itemModel);
            GlStateManager.func_179121_F();
        }
    }

    public abstract void updateAfterAssembly();

    public abstract void usingBeforeGUI();

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer entityPlayer) {
        if (!this.entityPlayerList.contains(entityPlayer)) {
            this.entityPlayerList.add(entityPlayer);
        }
        return null;
    }

    @Override
    public boolean isFull() {
        return this.full;
    }

    @Override
    public void setFull(boolean full) {
        if (!full && !this.entityPlayerList.isEmpty()) {
            this.entityPlayerList.forEach(EntityPlayer::func_71053_j);
        }
        this.full = full;
        new PacketUpdateFieldTile(this, "full", full);
    }

    @Override
    public MultiBlockStructure getMultiBlockStucture() {
        return this.multiBlockStructure;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public boolean wasActivated() {
        return this.activate;
    }

    @Override
    public void setActivated(boolean active) {
        this.activate = active;
        new PacketUpdateFieldTile(this, "activate", this.activate);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("full")) {
            try {
                this.full = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("activate")) {
            try {
                this.activate = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void updateFull() {
        this.setFull(this.getMultiBlockStucture().getFull(this.getFacing(), this.getBlockPos(), this.func_145831_w()));
        if (this.isFull()) {
            this.setActivated(true);
        }
    }

    @Override
    public void loadBeforeFirstClientUpdate() {
        super.loadBeforeFirstClientUpdate();
        if (this.activate && this.func_145831_w().field_72995_K) {
            this.updateFull();
            try {
                this.updateAfterAssembly();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        if (this.activate && !this.func_145831_w().field_72995_K) {
            this.updateFull();
            this.updateAfterAssembly();
        }
    }

    @Override
    public void updateFull(EntityPlayer player) {
        this.setFull(this.getMultiBlockStucture().getFull(this.getFacing(), this.getBlockPos(), this.func_145831_w(), player));
        if (this.isFull()) {
            this.setActivated(true);
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.full || !this.activate) {
            if (!this.getMultiBlockStucture().isHasActivatedItem()) {
                this.updateFull(player);
                if (this.full) {
                    this.updateAfterAssembly();
                }
                return true;
            }
            if (this.getMultiBlockStucture().isActivateItem(player.func_184586_b(hand))) {
                this.updateFull(player);
                if (!this.full) {
                    return false;
                }
                this.updateAfterAssembly();
            } else if (IUCore.proxy.isSimulating()) {
                IUCore.proxy.messagePlayer(player, Localization.translate("iu.activate_multiblock") + " " + this.getMultiBlockStucture().getActivateItem().func_82833_r(), new Object[0]);
            }
            return false;
        }
        this.usingBeforeGUI();
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.activate = nbttagcompound.func_74767_n("activate");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("activate", this.activate);
        return nbttagcompound;
    }

    @Override
    public IMainMultiBlock getMain() {
        return this;
    }

    @Override
    public void setMainMultiElement(IMainMultiBlock main) {
    }
}

