/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.generator.things.fluid;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerAirCollector;
import com.denfop.gui.GuiAirCollector;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotDrainTank;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileElectricMachine;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileAirCollector
extends TileElectricMachine
implements IUpgradableBlock,
IManufacturerBlock {
    public final Fluids fluids;
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotDrainTank[] containerslot;
    public FluidTank[] fluidTank = new FluidTank[3];
    private int level;

    public TileAirCollector() {
        super(5000.0, 1, 3);
        int i;
        this.fluids = this.addComponent(new Fluids(this));
        Fluid[] name1 = new Fluid[]{FluidName.fluidazot.getInstance(), FluidName.fluidoxy.getInstance(), FluidName.fluidco2.getInstance()};
        for (i = 0; i < this.fluidTank.length; ++i) {
            this.fluidTank[i] = this.fluids.addTank("fluidTank" + i, 10000, InvSlot.TypeItemSlot.OUTPUT, Fluids.fluidPredicate(name1[i]));
        }
        this.containerslot = new InvSlotDrainTank[name1.length];
        for (i = 0; i < name1.length; ++i) {
            this.containerslot[i] = new InvSlotDrainTank(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT, name1[i]);
        }
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.level = 0;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.fluidTank = (FluidTank[])DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.aircollector;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + 5 + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.aircollector.info", 20) + new FluidStack(FluidName.fluidazot.getInstance(), 1).getLocalizedName());
            tooltip.add(Localization.translate("iu.aircollector.info", 60) + new FluidStack(FluidName.fluidoxy.getInstance(), 1).getLocalizedName());
            tooltip.add(Localization.translate("iu.aircollector.info", 120) + new FluidStack(FluidName.fluidco2.getInstance(), 1).getLocalizedName());
        }
        super.addInformation(stack, tooltip, advanced);
    }

    @Override
    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        if (this.level != 0) {
            ret.add(new ItemStack((Item)IUItem.upgrade_speed_creation, this.level));
            this.level = 0;
        }
        return ret;
    }

    public FluidTank getFluidTank(int num) {
        return this.fluidTank[num];
    }

    public ContainerAirCollector getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerAirCollector(entityPlayer, this);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("level", this.level);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.level = nbttagcompound.func_74762_e("level");
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.level < 10) {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_77973_b().equals(IUItem.upgrade_speed_creation)) {
                return super.onActivated(player, hand, side, hitX, hitY, hitZ);
            }
            stack.func_190918_g(1);
            ++this.level;
            return false;
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiAirCollector(new ContainerAirCollector(entityPlayer, this));
    }

    public int gaugeLiquidScaled(int i) {
        return this.getFluidTank(0).getFluidAmount() <= 0 ? 0 : this.getFluidTank(0).getFluidAmount() * i / this.getFluidTank(0).getCapacity();
    }

    public double gaugeLiquidScaled(double i) {
        return this.getFluidTank(0).getFluidAmount() <= 0 ? 0.0 : (double)this.getFluidTank(0).getFluidAmount() * i / (double)this.getFluidTank(0).getCapacity();
    }

    public String getStartSoundFile() {
        return "Machines/air_collector.ogg";
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.setUpgradestat();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        for (FluidTank tank : this.fluidTank) {
            for (InvSlotDrainTank slot : this.containerslot) {
                if (tank.getFluidAmount() < 1000 || slot.isEmpty()) continue;
                slot.processFromTank((IFluidTank)tank, this.outputSlot);
            }
        }
        boolean work = false;
        if (this.energy.getEnergy() > (double)(5 + 5 * this.level)) {
            if (this.field_145850_b.field_73011_w.getWorldTime() % 400L == 0L) {
                this.initiate(2);
            }
            work = true;
            if (this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L) {
                if (this.fluidTank[0].getFluidAmount() + 1 <= this.fluidTank[0].getCapacity()) {
                    this.fluidTank[0].fill(new FluidStack(FluidName.fluidazot.getInstance(), Math.min(1 + this.level, this.fluidTank[0].getCapacity() - this.fluidTank[0].getFluidAmount())), true);
                }
                if (this.field_145850_b.field_73011_w.getWorldTime() % 60L == 0L && this.fluidTank[1].getFluidAmount() + 1 <= this.fluidTank[1].getCapacity()) {
                    this.fluidTank[1].fill(new FluidStack(FluidName.fluidoxy.getInstance(), Math.min(1 + this.level, this.fluidTank[1].getCapacity() - this.fluidTank[1].getFluidAmount())), true);
                    work = true;
                }
                if (this.field_145850_b.field_73011_w.getWorldTime() % 120L == 0L && this.fluidTank[2].getFluidAmount() + 1 <= this.fluidTank[2].getCapacity()) {
                    this.fluidTank[2].fill(new FluidStack(FluidName.fluidco2.getInstance(), Math.min(1 + this.level, this.fluidTank[2].getCapacity() - this.fluidTank[2].getFluidAmount())), true);
                    work = true;
                }
                this.energy.useEnergy(5 + 5 * this.level);
            }
        }
        if (!work) {
            this.initiate(2);
        } else {
            this.initiate(0);
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(this.tier + this.upgradeSlot.extraTier);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidProducing);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void removeLevel(int level) {
        this.level -= level;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.air_collector.getSoundEvent();
    }
}

