/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.generator.energy.redstone;

import com.denfop.Localization;
import com.denfop.api.gui.IType;
import com.denfop.componets.AdvEnergy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerRedstoneGenerator;
import com.denfop.gui.GuiRedstoneGenerator;
import com.denfop.invslot.InvSlotRedstoneGenerator;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileBaseRedstoneGenerator
extends TileElectricMachine
implements IType {
    public final double coef;
    public final InvSlotRedstoneGenerator slot;
    public int fuel = 0;
    public int max_fuel = 400;
    public int redstone_coef = 1;

    public TileBaseRedstoneGenerator(double coef, int tier) {
        super(0.0, tier, 0);
        this.energy = this.addComponent(AdvEnergy.asBasicSource(this, 150000.0 * coef, tier));
        this.coef = coef;
        this.slot = new InvSlotRedstoneGenerator(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive()) {
            ModUtils.showFlames(this.func_145831_w(), this.field_174879_c, this.getFacing());
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.fuel = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fuel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.info_upgrade_energy") + this.coef);
        }
        if (this.getComp(AdvEnergy.class) != null) {
            AdvEnergy energy = this.getComp(AdvEnergy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        ItemStack content = this.slot.get();
        if (content.func_190926_b()) {
            this.redstone_coef = 0;
        }
        this.redstone_coef = content.func_77973_b() == Items.field_151137_ax ? 1 : 9;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.slot.isEmpty() && this.fuel == 0) {
            this.fuel = this.max_fuel;
            this.slot.get().func_190918_g(1);
            if (!this.getActive()) {
                this.setActive(true);
            }
        }
        if (this.fuel == 0 && this.getActive()) {
            this.setActive(false);
        }
        if (this.getActive()) {
            this.energy.addEnergy(25.0 * this.coef * (double)this.redstone_coef);
        }
        this.fuel = Math.max(0, this.fuel - 1);
        if (this.fuel == 0 && this.slot.get().func_190926_b()) {
            this.redstone_coef = 0;
        }
    }

    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        return Math.min(this.fuel * i / this.max_fuel, i);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fuel = nbttagcompound.func_74762_e("fuel");
    }

    public int gaugeStorageScaled(int i) {
        return (int)(this.energy.getEnergy() * (double)i / this.energy.getCapacity());
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("fuel", this.fuel);
        return nbt;
    }

    public ContainerRedstoneGenerator getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerRedstoneGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiRedstoneGenerator(new ContainerRedstoneGenerator(entityPlayer, this));
    }

    @Override
    public EnumTypeStyle getStyle() {
        return EnumTypeStyle.DEFAULT;
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

