/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.generator.energy.coal;

import com.denfop.Localization;
import com.denfop.api.gui.IType;
import com.denfop.componets.AdvEnergy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerGenerator;
import com.denfop.gui.GuiGenerator;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.generator.energy.TileEntityBaseGenerator;
import com.denfop.utils.DamageHandler;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileEntityAdvGenerator
extends TileEntityBaseGenerator
implements IType {
    public final InvSlot fuelSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

        @Override
        public boolean accepts(ItemStack stack, int index) {
            return ModUtils.getFuelValue(stack, false) > 0;
        }
    };
    private final double coef;
    public int itemFuelTime = 0;

    public TileEntityAdvGenerator(double coef, int maxstorage, int tier) {
        super(coef * (double)Math.round(10.0f), tier, maxstorage);
        this.coef = coef;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive()) {
            ModUtils.showFlames(this.func_145831_w(), this.field_174879_c, this.getFacing());
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.fuel = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fuel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.info_upgrade_energy") + this.coef);
        }
        if (this.getComp(AdvEnergy.class) != null) {
            AdvEnergy energy = this.getComp(AdvEnergy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        if (this.itemFuelTime <= 0) {
            this.itemFuelTime = this.fuel;
        }
        return Math.min(this.fuel * i / this.itemFuelTime, i);
    }

    public int consumeFuel() {
        ItemStack fuel = this.consume(1);
        return fuel == null ? 0 : ModUtils.getFuelValue(fuel, false);
    }

    @Override
    public boolean gainFuel() {
        int fuelValue = this.consumeFuel() / 4;
        if (fuelValue == 0) {
            return false;
        }
        this.fuel += fuelValue;
        this.itemFuelTime = fuelValue;
        return true;
    }

    public ItemStack consume(int amount) {
        ItemStack ret = ItemStack.field_190927_a;
        ItemStack stack = this.fuelSlot.get(0);
        if (!(stack.func_190926_b() || ModUtils.getSize(stack) != 1 && stack.func_77973_b().hasContainerItem(stack))) {
            int currentAmount = Math.min(amount, ModUtils.getSize(stack));
            amount -= currentAmount;
            if (ModUtils.getSize(stack) == currentAmount) {
                if (stack.func_77973_b().hasContainerItem(stack)) {
                    ItemStack container = stack.func_77973_b().getContainerItem(stack);
                    if (container.func_190926_b() && container.func_77984_f() && DamageHandler.getDamage(container) > DamageHandler.getMaxDamage(container)) {
                        container = ItemStack.field_190927_a;
                    }
                    this.fuelSlot.put(0, container);
                } else {
                    this.fuelSlot.put(0, ItemStack.field_190927_a);
                }
            } else {
                this.fuelSlot.put(0, ModUtils.decSize(stack, currentAmount));
            }
            ret = ModUtils.setSize(stack, currentAmount);
        }
        return ret;
    }

    public int gaugeStorageScaled(int i) {
        return (int)(this.energy.getEnergy() * (double)i / this.energy.getCapacity());
    }

    public double getEnergy() {
        return this.energy.getEnergy();
    }

    public ContainerGenerator getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiGenerator(new ContainerGenerator(entityPlayer, this));
    }

    @Override
    public boolean isConverting() {
        return this.fuel > 0;
    }

    public String getOperationSoundFile() {
        return "Generators/GeneratorLoop.ogg";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.itemFuelTime = nbt.func_74762_e("itemFuelTime");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("itemFuelTime", this.itemFuelTime);
        return nbt;
    }

    @Override
    public EnumTypeStyle getStyle() {
        return EnumTypeStyle.DEFAULT;
    }
}

