/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.energy;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergyConductor;
import com.denfop.api.energy.IEnergyController;
import com.denfop.api.energy.Path;
import com.denfop.api.energy.event.EventLoadController;
import com.denfop.api.energy.event.EventUnloadController;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerSubstitute;
import com.denfop.gui.GuiEnergySubstitute;
import com.denfop.invslot.CableItem;
import com.denfop.invslot.InvSlotSubstitute;
import com.denfop.items.block.ItemBlockTileEntity;
import com.denfop.items.transport.ItemCable;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.FakePlayerSpawner;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.transport.tiles.TileEntityCable;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEnergySubstitute
extends TileEntityInventory
implements IUpdatableTileEvent,
IEnergyController {
    public final InvSlotSubstitute slot;
    public List<Path> energyPathList = new ArrayList<Path>();
    public Set<IEnergyConductor> conductorList = new HashSet<IEnergyConductor>();
    public boolean work = false;
    public int size;
    public int max_value = 0;
    List<CableItem> cableItemList = new ArrayList<CableItem>();
    CableItem main_cableItem = null;
    FakePlayerSpawner fakePlayer;

    public TileEnergySubstitute() {
        this.slot = new InvSlotSubstitute(this);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.substitute;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(Localization.translate("iu.controller_cables.info"));
        tooltip.add(Localization.translate("iu.controller_cables.info1"));
    }

    public List<CableItem> getCableItemList() {
        return this.cableItemList;
    }

    public void setCableItemList(List<CableItem> cableItemList) {
        this.cableItemList = cableItemList;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EventLoadController(this));
            this.fakePlayer = new FakePlayerSpawner(this.func_145831_w());
            this.slot.onChanged();
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.size = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public void onUnloaded() {
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EventUnloadController(this));
        }
        super.onUnloaded();
    }

    public ContainerSubstitute getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSubstitute(this, entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiEnergySubstitute(this.getGuiContainer(entityPlayer));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("work", this.work);
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.work = nbtTagCompound.func_74767_n("work");
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work) {
            if (this.main_cableItem != null) {
                ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
                for (IEnergyConductor conductor : this.conductorList) {
                    if (!(conductor.getConductorBreakdownEnergy() - 1.0 < (double)this.max_value)) continue;
                    for (ItemStack stack : this.slot.gets()) {
                        if (!stack.func_77969_a(this.main_cableItem.getStack()) || !ModUtils.nbt(this.main_cableItem.getStack()).equals((Object)ModUtils.nbt(stack)) || !(this.main_cableItem.getStack().func_77973_b() instanceof ItemCable)) continue;
                        TileEntityCable te = TileEntityCable.delegate(ItemCable.getCableType(this.main_cableItem.getStack()));
                        TileEntityBlock tile = (TileEntityBlock)EnergyNetGlobal.instance.getBlockPosFromEnergyTile(conductor);
                        EnumFacing facing = tile.getFacing().func_176734_d();
                        List<ItemStack> drops = tile.getBlockType().getDrops((IBlockAccess)this.field_145850_b, tile.func_174877_v(), tile.getBlockState(), 100);
                        if (!drops.isEmpty()) {
                            itemStackList.add(drops.get(0));
                        }
                        conductor.removeConductor();
                        BlockPos pos = tile.func_174877_v();
                        if (!ItemBlockTileEntity.placeTeBlock(this.main_cableItem.getStack(), (EntityLivingBase)this.fakePlayer, this.func_145831_w(), pos, facing, te)) continue;
                        stack.func_190918_g(1);
                        this.main_cableItem.shrink(1);
                        EnergyNetGlobal.getForWorld(this.func_145831_w()).update(pos);
                        TileEntityCable cable = (TileEntityCable)this.func_145831_w().func_175625_s(pos);
                        if (cable == null) break;
                        cable.update_render();
                        break;
                    }
                    if (this.main_cableItem.getCount() != 0) continue;
                    this.slot.onChanged();
                    if (this.main_cableItem != null) continue;
                    break;
                }
                for (ItemStack stack : itemStackList) {
                    this.slot.add(stack);
                }
            }
            this.energyPathList.clear();
            this.conductorList.clear();
            this.size = 0;
            this.work = false;
            for (EnumFacing facing : EnumFacing.values()) {
                List<Path> energyPathList1 = EnergyNetGlobal.instance.getEnergyPaths(this.func_145831_w(), this.getBlockPos().func_177972_a(facing));
                for (Path path : energyPathList1) {
                    if (this.energyPathList.contains(path)) continue;
                    this.energyPathList.add(path);
                }
            }
            this.energyPathList.forEach(energyPath -> this.conductorList.addAll(energyPath.getConductors()));
            this.size = this.conductorList.size();
            this.main_cableItem = null;
            this.max_value = 0;
            this.slot.onChanged();
        }
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (i == 0.0) {
            this.energyPathList.clear();
            this.conductorList.clear();
            for (EnumFacing facing : EnumFacing.values()) {
                List<Path> energyPathList1 = EnergyNetGlobal.instance.getEnergyPaths(this.func_145831_w(), this.getBlockPos().func_177972_a(facing));
                for (Path path : energyPathList1) {
                    if (this.energyPathList.contains(path)) continue;
                    this.energyPathList.add(path);
                }
            }
            this.energyPathList.forEach(energyPath -> this.conductorList.addAll(energyPath.getConductors()));
            this.size = this.conductorList.size();
            this.main_cableItem = null;
            this.max_value = 0;
            this.slot.onChanged();
        } else if (i == 1.0) {
            this.work = true;
        }
    }

    @Override
    public boolean getWork() {
        return this.work;
    }

    @Override
    public void work() {
        if (this.getWork()) {
            this.energyPathList.clear();
            this.conductorList.clear();
            for (EnumFacing facing : EnumFacing.values()) {
                List<Path> energyPathList1 = EnergyNetGlobal.instance.getEnergyPaths(this.func_145831_w(), this.getBlockPos().func_177972_a(facing));
                for (Path path : energyPathList1) {
                    if (this.energyPathList.contains(path)) continue;
                    this.energyPathList.add(path);
                }
            }
            this.energyPathList.forEach(energyPath -> this.conductorList.addAll(energyPath.getConductors()));
            this.size = this.conductorList.size();
        }
    }

    @Override
    public void unload() {
        this.energyPathList.clear();
        this.conductorList.clear();
    }

    public void setMaxValue(int max_value, double provider, CableItem cableItem) {
        if (provider > (double)max_value) {
            this.max_value = (int)provider;
            this.main_cableItem = cableItem;
        }
    }
}

