/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.energy;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergyController;
import com.denfop.api.energy.Path;
import com.denfop.api.energy.event.EventLoadController;
import com.denfop.api.energy.event.EventUnloadController;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerController;
import com.denfop.gui.GuiEnergyController;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEnergyController
extends TileEntityInventory
implements IUpdatableTileEvent,
IEnergyController {
    public List<Path> energyPathList = new ArrayList<Path>();
    public boolean work = false;
    public int size;

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.energy_controller;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(Localization.translate("iu.controller.info"));
        tooltip.add(Localization.translate("iu.controller.info1"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.size = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EventLoadController(this));
        }
    }

    @Override
    public void onUnloaded() {
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EventUnloadController(this));
        }
        super.onUnloaded();
    }

    public ContainerController getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerController(this, entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiEnergyController(this.getGuiContainer(entityPlayer));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("work", this.work);
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.work = nbtTagCompound.func_74767_n("work");
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (i == 0.0) {
            this.energyPathList.clear();
            for (EnumFacing facing : EnumFacing.values()) {
                List<Path> energyPathList1 = EnergyNetGlobal.instance.getEnergyPaths(this.func_145831_w(), this.getBlockPos().func_177972_a(facing));
                for (Path path : energyPathList1) {
                    if (this.energyPathList.contains(path)) continue;
                    this.energyPathList.add(path);
                }
            }
            this.size = this.energyPathList.size();
        } else if (i == 1.0) {
            this.work = true;
            this.energyPathList.forEach(energyPath -> energyPath.setHasController(true));
        }
    }

    @Override
    public boolean getWork() {
        return this.work;
    }

    @Override
    public void work() {
        if (this.getWork()) {
            this.energyPathList.clear();
            for (EnumFacing facing : EnumFacing.values()) {
                List<Path> energyPathList1 = EnergyNetGlobal.instance.getEnergyPaths(this.func_145831_w(), this.getBlockPos().func_177972_a(facing));
                for (Path path : energyPathList1) {
                    if (this.energyPathList.contains(path)) continue;
                    this.energyPathList.add(path);
                }
            }
            this.size = this.energyPathList.size();
            this.energyPathList.forEach(energyPath -> energyPath.setHasController(true));
        }
    }

    @Override
    public void unload() {
        this.energyPathList.forEach(energyPath -> energyPath.setHasController(false));
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }
}

