/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.cooling;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.client.ComponentClientEffectRender;
import com.denfop.componets.client.EffectType;
import com.denfop.container.ContainerCoolMachine;
import com.denfop.gui.GuiCoolMachine;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileCooling
extends TileElectricMachine
implements IUpdatableTileEvent {
    public CoolComponent cold;
    public int max;
    public boolean work;
    private int coef;

    public TileCooling() {
        super(10000.0, 14, 1);
        this.cold = this.addComponent(CoolComponent.asBasicSource(this, 4.0, this.tier));
        this.max = 4;
        this.componentClientEffectRender = new ComponentClientEffectRender(this, EffectType.REFRIGERATOR);
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packet = super.writeUpdatePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer customPacketBuffer) {
        super.readUpdatePacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.max = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.work = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.max);
            EncoderHandler.encode(packet, this.work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.cooling;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.max = nbttagcompound.func_74762_e("max");
        this.work = nbttagcompound.func_74767_n("work");
        this.cold.setCapacity(this.max);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("max", this.max);
        nbttagcompound.func_74757_a("work", this.work);
        return nbttagcompound;
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        if (i == 0.0) {
            this.cold.setCapacity(this.max + 4);
            if (this.cold.getCapacity() > 64.0) {
                this.cold.setCapacity(64.0);
            }
            this.max = (int)this.cold.getCapacity();
        }
        if (i == 1.0) {
            this.cold.setCapacity(this.max - 4);
            if (this.cold.getCapacity() < 4.0) {
                this.cold.setCapacity(4.0);
            }
            this.max = (int)this.cold.getCapacity();
        }
        if (i == 2.0) {
            boolean bl = this.work = !this.work;
        }
        if (i == 10.0) {
            super.updateTileServer(entityPlayer, i);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + 30 + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip, advanced);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.coef = (int)Math.max(Math.ceil(this.cold.storage / 16.0), 1.0);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.cold.allow || this.work) {
            if (this.energy.getEnergy() >= (double)(30 * this.coef) && this.cold.getEnergy() < this.cold.getCapacity()) {
                this.cold.addEnergy(1.0);
                this.energy.useEnergy(30 * this.coef);
                this.initiate(0);
            }
            if (this.field_145850_b.field_73011_w.getWorldTime() % 400L == 0L) {
                this.initiate(2);
            }
            if (this.energy.getEnergy() < (double)(30 * this.coef)) {
                this.initiate(2);
            } else {
                this.initiate(0);
            }
        } else {
            this.initiate(2);
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L && this.cold.getEnergy() >= 1.0) {
            this.cold.addEnergy(-1.0);
        }
    }

    public ContainerCoolMachine getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerCoolMachine(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiCoolMachine(this.getGuiContainer(entityPlayer));
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.cooling.getSoundEvent();
    }
}

