/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.gui.IType;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerPump;
import com.denfop.gui.GuiPump;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricLiquidTankInventory;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;
import org.lwjgl.input.Keyboard;

public class TilePump
extends TileElectricLiquidTankInventory
implements IUpgradableBlock,
IType {
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final InvSlotFluid containerSlot = new InvSlotFluid(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT);
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, 1);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, 4);
    public double energyConsume = 1.0;
    public int operationsPerTick;
    public short progress = 0;
    public int operationLength;
    public float guiProgress;

    public TilePump(int size, int operationLength) {
        super(20.0, 1, size);
        this.defaultEnergyConsume = 1.0;
        this.defaultOperationLength = this.operationLength = operationLength;
        this.defaultTier = 1;
        this.defaultEnergyStorage = this.operationLength;
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private static double applyModifier(double base, double extra, double multiplier) {
        return Math.round((base + extra) * multiplier);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = ((Float)DecoderHandler.decode(customPacketBuffer)).floatValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, Float.valueOf(this.guiProgress));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultEnergyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        super.addInformation(stack, tooltip, advanced);
    }

    @Override
    public void updateEntityServer() {
        MutableObject output;
        super.updateEntityServer();
        if (this.energy.canUseEnergy(this.energyConsume * (double)this.operationLength)) {
            if (this.progress < this.operationLength) {
                this.progress = (short)(this.progress + 1);
                this.energy.useEnergy(this.energyConsume);
            } else if (this.canoperate()) {
                this.progress = 0;
            }
        }
        if (this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        this.guiProgress = (float)this.progress / (float)this.operationLength;
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    public boolean canoperate() {
        return this.operate(true);
    }

    public boolean operate(boolean sim) {
        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
            return false;
        }
        boolean canOperate = false;
        for (int i = this.field_174879_c.func_177958_n() - 5; i <= this.field_174879_c.func_177958_n() + 5; ++i) {
            for (int j = this.field_174879_c.func_177952_p() - 5; j <= this.field_174879_c.func_177952_p() + 5; ++j) {
                for (int k = this.field_174879_c.func_177956_o() - 5; k <= this.field_174879_c.func_177956_o() + 5; ++k) {
                    for (EnumFacing dir : EnumFacing.values()) {
                        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
                            return false;
                        }
                        FluidStack liquid = this.pump(new BlockPos(i + dir.func_82601_c(), k + dir.func_96559_d(), j + dir.func_82599_e()), false);
                        if (this.getFluidTank().fill(liquid, false) <= 0) continue;
                        this.getFluidTank().fill(liquid, true);
                        canOperate = true;
                    }
                }
            }
        }
        return canOperate;
    }

    public FluidStack pump(BlockPos pos, boolean sim) {
        IBlockState block;
        FluidStack ret = null;
        int freespace = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (freespace >= 1000 && (block = this.func_145831_w().func_180495_p(pos)).func_185904_a().func_76224_d()) {
            if (block.func_177230_c() instanceof IFluidBlock) {
                IFluidBlock liquid = (IFluidBlock)block.func_177230_c();
                if ((this.fluidTank.getFluid() == null || this.fluidTank.getFluid().getFluid() == liquid.getFluid()) && liquid.canDrain(this.func_145831_w(), pos)) {
                    if (!sim) {
                        ret = liquid.drain(this.func_145831_w(), pos, true);
                        this.func_145831_w().func_175698_g(pos);
                    } else {
                        ret = new FluidStack(liquid.getFluid(), 1000);
                    }
                }
            } else {
                if (block.func_177230_c().func_176201_c(block) != 0) {
                    return null;
                }
                ret = new FluidStack(FluidRegistry.getFluid((String)block.func_177230_c().func_149739_a().substring(5)), 1000);
                if (!(this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() != ret.getFluid() || sim)) {
                    this.func_145831_w().func_175698_g(pos);
                }
            }
        }
        return ret;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        double previousProgress = (double)this.progress / (double)this.operationLength;
        double stackOpLen = ((double)this.defaultOperationLength + (double)this.upgradeSlot.extraProcessTime) * 64.0 * this.upgradeSlot.processTimeMultiplier;
        this.operationsPerTick = (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
        this.operationLength = (int)Math.round(stackOpLen * (double)this.operationsPerTick / 64.0);
        this.energyConsume = TilePump.applyModifier(this.defaultEnergyConsume, this.upgradeSlot.extraEnergyDemand, 1.0);
        this.energy.setSinkTier(TilePump.applyModifier(this.defaultTier, this.upgradeSlot.extraTier, 1.0));
        this.energy.setCapacity(TilePump.applyModifier(this.defaultEnergyStorage, this.upgradeSlot.extraEnergyStorage + (double)this.operationLength * this.energyConsume, this.upgradeSlot.energyStorageMultiplier));
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        this.progress = (short)Math.floor(previousProgress * (double)this.operationLength + 0.1);
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy.canUseEnergy(amount)) {
            this.energy.useEnergy(amount);
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        return nbttagcompound;
    }

    public ContainerPump getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPump(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiPump getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiPump(new ContainerPump(entityPlayer, this));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, new UpgradableProperty[]{UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidProducing, UpgradableProperty.FluidConsuming});
    }

    @Override
    public EnumTypeStyle getStyle() {
        return null;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.PumpOp.getSoundEvent();
    }
}

