/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.container.ContainerPlasticPlateCreator;
import com.denfop.gui.GuiPlasticPlateCreator;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileBasePlasticPlateCreator;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TilePlasticPlateCreator
extends TileBasePlasticPlateCreator
implements IUpdateTick,
IHasRecipe {
    public TilePlasticPlateCreator() {
        super(1, 300, 1);
        this.inputSlotA = new InvSlotRecipes(this, "plasticplate", this, this.fluidTank);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.inputSlotA.setInvSlotConsumableLiquidByList(this.fluidSlot);
        Recipes.recipes.addInitRecipes(this);
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidoxy.getInstance(), 1000), input.getInput(new ItemStack(IUItem.plast))), new RecipeOutput(null, new ItemStack(IUItem.plastic_plate))));
        Recipes.recipes.addRecipe("plasticplate", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidco2.getInstance(), 500), input.getInput(new ItemStack(Items.field_151145_ak, 4))), new RecipeOutput(null, new ItemStack((Item)IUItem.crafting_elements, 1, 344))));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.plastic_plate_creator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1;
    }

    public String getInventoryName() {
        return Localization.translate("iu.blockPlasticPlateCreator.name");
    }

    @Override
    public int gaugeLiquidScaled(int i) {
        return this.getFluidTank().getFluidAmount() <= 0 ? 0 : this.getFluidTank().getFluidAmount() * i / this.getFluidTank().getCapacity();
    }

    public ContainerPlasticPlateCreator getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPlasticPlateCreator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiPlasticPlateCreator(new ContainerPlasticPlateCreator(entityPlayer, this));
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.plastic_plate.getSoundEvent();
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, new UpgradableProperty[]{UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidConsuming});
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }
}

