/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.container.ContainerPlasticCreator;
import com.denfop.gui.GuiPlasticCreator;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileBasePlasticCreator;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TilePlasticCreator
extends TileBasePlasticCreator
implements IHasRecipe {
    public TilePlasticCreator() {
        super(1, 300, 1);
        this.inputSlotA = new InvSlotRecipes(this, "plastic", this, this.fluidTank);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.inputSlotA.setInvSlotConsumableLiquidByList(this.fluidSlot);
        Recipes.recipes.addInitRecipes(this);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.plastic_creator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1;
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack(FluidRegistry.WATER, 1000), input.getInput(IUItem.PolyethCell), input.getInput(IUItem.PolypropCell)), new RecipeOutput(null, new ItemStack(IUItem.plast))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidazot.getInstance(), 12000), input.getInput("blockVitalium"), input.getInput(new ItemStack((Item)IUItem.crafting_elements, 1, 269))), new RecipeOutput(null, new ItemStack((Item)IUItem.crafting_elements, 1, 270))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidpolyeth.getInstance(), 500), input.getInput(new ItemStack((Item)IUItem.crafting_elements, 1, 344)), input.getInput("doubleplateTitanium")), new RecipeOutput(null, new ItemStack((Item)IUItem.crafting_elements, 1, 340))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack(FluidName.fluidneft.getInstance(), 5000), input.getInput(new ItemStack((Item)IUItem.crafting_elements, 8, 283)), input.getInput("ingotGermanium", 4)), new RecipeOutput(null, new ItemStack((Item)IUItem.crafting_elements, 1, 386))));
    }

    public String getInventoryName() {
        return Localization.translate("iu.blockPlasticCreator.name");
    }

    @Override
    public int gaugeLiquidScaled(int i) {
        return this.getFluidTank().getFluidAmount() <= 0 ? 0 : this.getFluidTank().getFluidAmount() * i / this.getFluidTank().getCapacity();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiPlasticCreator(new ContainerPlasticCreator(entityPlayer, this));
    }

    public String getStartSoundFile() {
        return "Machines/plastic.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, new UpgradableProperty[]{UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidConsuming});
    }
}

