/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.vein.Type;
import com.denfop.api.vein.Vein;
import com.denfop.api.vein.VeinSystem;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.blocks.mechanism.BlockPetrolQuarry;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerOilPump;
import com.denfop.gui.GuiOilPump;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileElectricLiquidTankInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;
import org.lwjgl.input.Keyboard;

public class TileOilPump
extends TileElectricLiquidTankInventory
implements IUpgradableBlock,
IManufacturerBlock {
    private static final List<AxisAlignedBB> aabbs = Collections.singletonList(new AxisAlignedBB(0.0, 0.0, -1.0, 1.0, 2.0, 2.0));
    public final int defaultTier;
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotFluid containerslot = new InvSlotFluidByList(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT, FluidName.fluidneft.getInstance());
    public int level = 0;
    public boolean find;
    public int count;
    public int maxcount;
    public Vein vein;
    public int type;

    public TileOilPump() {
        super(50000.0, 14, 20, Fluids.fluidPredicate(FluidName.fluidneft.getInstance()));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.defaultTier = 14;
    }

    private static int applyModifier(int extra) {
        double ret = Math.round(14.0 + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockPetrolQuarry.petrol_quarry;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.oilgetter;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void removeLevel(int level) {
        this.level -= level;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + 2 + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)stack.func_77978_p().func_74781_a("fluid")));
            tooltip.add(Localization.translate("iu.fluid.info") + fluidStack.getLocalizedName());
            tooltip.add(Localization.translate("iu.fluid.info1") + fluidStack.amount / 1000 + " B");
        }
        super.addInformation(stack, tooltip, advanced);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("level", this.level);
        nbttagcompound.func_74757_a("find", this.find);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.level = nbttagcompound.func_74762_e("level");
        this.find = nbttagcompound.func_74767_n("find");
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.count = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.find = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.maxcount = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.level = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.type = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.vein = (Vein)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.count);
            EncoderHandler.encode(packet, this.find);
            EncoderHandler.encode(packet, this.maxcount);
            EncoderHandler.encode(packet, this.level);
            EncoderHandler.encode(packet, this.type);
            EncoderHandler.encode(packet, this.vein);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    public Vein getVein() {
        return this.vein;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.level < 10) {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_77973_b().equals(IUItem.upgrade_speed_creation)) {
                return super.onActivated(player, hand, side, hitX, hitY, hitZ);
            }
            stack.func_190918_g(1);
            ++this.level;
            return false;
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        if (this.level != 0) {
            ret.add(new ItemStack((Item)IUItem.upgrade_speed_creation, this.level));
            this.level = 0;
        }
        return ret;
    }

    private void updateTileEntityField() {
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        drop = super.adjustDrop(drop, wrench);
        if (wrench || this.teBlock.getDefaultDrop() == MultiTileBlock.DefaultDrop.Self) {
            NBTTagCompound nbt = ModUtils.nbt(drop);
            if (this.fluidTank.getFluidAmount() > 0) {
                nbt.func_74782_a("fluid", (NBTBase)this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
            }
        }
        return drop;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.vein = VeinSystem.system.getVein(this.func_145831_w().func_175726_f(this.field_174879_c).func_76632_l());
        if (this.vein != VeinSystem.system.getEMPTY()) {
            this.find = this.vein.get();
            this.count = this.vein.getCol();
            this.maxcount = this.vein.getMaxCol();
            this.type = this.vein.getType().ordinal();
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)stack.func_77978_p().func_74781_a("fluid")));
            if (fluidStack != null) {
                this.fluidTank.fill(fluidStack, true);
            }
            new PacketUpdateFieldTile(this, "fluidTank", (Object)this.fluidTank);
        }
        this.updateTileEntityField();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("fluidTank")) {
            try {
                FluidTank fluidTank = (FluidTank)DecoderHandler.decode(is);
                this.fluidTank.readFromNBT(fluidTank.writeToNBT(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.vein = VeinSystem.system.getVein(this.func_145831_w().func_175726_f(this.field_174879_c).func_76632_l());
        if (this.vein != VeinSystem.system.getEMPTY()) {
            boolean find = this.vein.get();
            if (this.find != find) {
                this.vein.setFind(this.find);
            }
            this.count = this.vein.getCol();
            this.maxcount = this.vein.getMaxCol();
            this.type = this.vein.getType().ordinal();
        }
        this.updateTileEntityField();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        return aabbs;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.vein == null || this.vein.getType() != Type.OIL) {
            return;
        }
        MutableObject output = new MutableObject();
        if (this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        if (this.energy.getEnergy() >= 2.0 && this.find) {
            this.get_oil();
            if (!this.getActive()) {
                this.setActive(true);
                this.initiate(0);
            }
        } else if (this.getActive()) {
            this.setActive(false);
            this.initiate(2);
        }
    }

    private void get_oil() {
        if (this.vein.getCol() >= 1) {
            int size = Math.min(this.level + 1, this.vein.getCol());
            size = Math.min(size, this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount());
            if (this.fluidTank.getFluidAmount() + size <= this.fluidTank.getCapacity()) {
                this.fluidTank.fill(new FluidStack(FluidName.fluidneft.getInstance(), size), true);
                this.vein.removeCol(size);
                this.count = this.vein.getCol();
                this.energy.useEnergy(2.0);
                this.updateTileEntityField();
                if (this.upgradeSlot.tickNoMark()) {
                    this.setUpgradestat();
                }
            }
        }
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (IUCore.proxy.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(TileOilPump.applyModifier(this.upgradeSlot.extraTier));
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy.getEnergy() >= amount) {
            this.energy.useEnergy(amount);
            return true;
        }
        return false;
    }

    public String getStartSoundFile() {
        return "Machines/oilgetter.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public boolean canDrain(Fluid fluid) {
        return true;
    }

    public ContainerOilPump getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerOilPump(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiOilPump getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiOilPump(new ContainerOilPump(entityPlayer, this));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidProducing);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.oilgetter.getSoundEvent();
    }
}

