/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AdvEnergy;
import com.denfop.container.ContainerWaterRotorAssembler;
import com.denfop.gui.GuiWaterRotorAssembler;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileEntityWaterRotorAssembler
extends TileEntityInventory
implements IUpdateTick,
IHasRecipe {
    public final InvSlotRecipes inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "water_rotor_assembler", (IUpdateTick)this);
    public final AdvEnergy energy;
    public final int defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final int defaultEnergyStorage;
    public final InvSlotOutput outputSlot;
    public MachineRecipe recipe;
    public short progress;
    public double guiProgress;
    public int energyConsume;
    public int operationLength;
    public int operationsPerTick = 1;

    public TileEntityWaterRotorAssembler() {
        this.inputSlotA.setStackSizeLimit(1);
        this.energyConsume = 2;
        this.defaultEnergyConsume = 2;
        this.operationLength = 100;
        this.defaultOperationLength = 100;
        this.defaultTier = 14;
        this.defaultEnergyStorage = 200;
        this.recipe = null;
        this.outputSlot = new InvSlotOutput(this, 1);
        this.energy = this.addComponent(AdvEnergy.asBasicSink((TileEntityInventory)this, (double)this.defaultEnergyStorage, this.defaultTier));
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addRecipe(int meta, int meta1, ItemStack stack) {
        IInputHandler input = Recipes.inputFactory;
        ((ItemDamage)stack.func_77973_b()).setCustomDamage(stack, ((ItemDamage)stack.func_77973_b()).getMaxCustomDamage(stack));
        Recipes.recipes.addRecipe("water_rotor_assembler", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.water_rod, 1, meta)), input.getInput(new ItemStack((Item)IUItem.water_rod, 1, meta)), input.getInput(new ItemStack((Item)IUItem.water_rod, 1, meta)), input.getInput(new ItemStack((Item)IUItem.water_rod, 1, meta)), input.getInput(new ItemStack((Item)IUItem.corewater, 1, meta1))), new RecipeOutput(null, stack)));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.water_rotor_assembler;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public void init() {
        TileEntityWaterRotorAssembler.addRecipe(0, 0, new ItemStack((Item)IUItem.water_rotor_wood));
        TileEntityWaterRotorAssembler.addRecipe(1, 1, new ItemStack((Item)IUItem.water_rotor_bronze));
        TileEntityWaterRotorAssembler.addRecipe(2, 2, new ItemStack((Item)IUItem.water_rotor_iron));
        TileEntityWaterRotorAssembler.addRecipe(3, 3, new ItemStack((Item)IUItem.water_rotor_steel));
        TileEntityWaterRotorAssembler.addRecipe(4, 4, new ItemStack((Item)IUItem.water_rotor_carbon));
        TileEntityWaterRotorAssembler.addRecipe(5, 5, IUItem.water_iridium);
        TileEntityWaterRotorAssembler.addRecipe(6, 6, IUItem.water_compressiridium);
        TileEntityWaterRotorAssembler.addRecipe(7, 7, IUItem.water_spectral);
        TileEntityWaterRotorAssembler.addRecipe(8, 8, IUItem.water_myphical);
        TileEntityWaterRotorAssembler.addRecipe(10, 10, IUItem.water_photon);
        TileEntityWaterRotorAssembler.addRecipe(9, 9, IUItem.water_neutron);
        TileEntityWaterRotorAssembler.addRecipe(11, 11, IUItem.water_barionrotor);
        TileEntityWaterRotorAssembler.addRecipe(12, 12, IUItem.water_adronrotor);
        TileEntityWaterRotorAssembler.addRecipe(13, 13, IUItem.water_ultramarinerotor);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(this.getNBTFromSlot(customPacketBuffer));
            this.progress = (Short)DecoderHandler.decode(customPacketBuffer);
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.inputSlotA);
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultEnergyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        if (this.getComp(AdvEnergy.class) != null) {
            AdvEnergy energy = this.getComp(AdvEnergy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.inputSlotA.load();
        this.getOutput();
    }

    public void operate(MachineRecipe output) {
        for (int i = 0; i < this.operationsPerTick; ++i) {
            List<ItemStack> processResult = output.getRecipe().output.items;
            this.operateOnce(processResult);
            if (!this.inputSlotA.continue_process(this.recipe) || !this.outputSlot.canAdd(output.getRecipe().output.items)) {
                this.getOutput();
                break;
            }
            if (this.recipe == null) break;
        }
    }

    public MachineRecipe getOutput() {
        this.recipe = this.inputSlotA.process();
        return this.recipe;
    }

    public void operateOnce(List<ItemStack> processResult) {
        this.inputSlotA.consume();
        this.outputSlot.add(processResult);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.recipe != null && this.energy.canUseEnergy(this.energyConsume) && !this.inputSlotA.isEmpty() && this.outputSlot.canAdd(this.recipe.getRecipe().getOutput().items)) {
            this.setActive(true);
            this.progress = (short)(this.progress + 1);
            this.energy.useEnergy(this.energyConsume);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate(this.recipe);
                this.progress = 0;
                this.setActive(false);
            }
        } else if (this.recipe == null) {
            this.progress = 0;
            this.setActive(false);
        }
    }

    public ContainerWaterRotorAssembler getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerWaterRotorAssembler(this, entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiWaterRotorAssembler(this.getGuiContainer(entityPlayer));
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.recipe;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.recipe = output;
    }
}

