/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerRefrigerator;
import com.denfop.gui.GuiRefrigerator;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotTank;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.items.reactors.ItemReactorCoolant;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.tiles.base.TileElectricMachine;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityRefrigeratorCoolant
extends TileElectricMachine
implements IUpgradableBlock,
IUpdatableTileEvent {
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, 4);
    public final Fluids fluids = this.addComponent(new Fluids(this));
    public final Fluids.InternalFluidTank tank = this.fluids.addTankInsert("input", 10000, Fluids.fluidPredicate(FluidName.fluidHelium.getInstance(), FluidName.fluidhyd.getInstance(), FluidName.fluidazot.getInstance()));
    public final InvSlot slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

        @Override
        public boolean accepts(ItemStack stack, int index) {
            return stack.func_77973_b() instanceof ItemReactorCoolant;
        }
    };
    public final InvSlotTank fluidSlot;

    public TileEntityRefrigeratorCoolant() {
        super(400.0, 14, 1);
        this.slot.setStackSizeLimit(1);
        this.fluidSlot = new InvSlotTank(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.INPUT, (IFluidTank)this.tank);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.refrigerator_coolant;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    public ContainerRefrigerator getGuiContainer(EntityPlayer var1) {
        return new ContainerRefrigerator(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiRefrigerator(this.getGuiContainer(var1));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.fluidSlot.isEmpty() && this.tank.getFluidAmount() + 1000 <= this.tank.getCapacity() && !this.fluidSlot.get().func_190926_b() && this.fluidSlot.processIntoTank((IFluidTank)this.tank, this.outputSlot)) {
            this.upgradeSlot.tickNoMark();
        }
        if (this.energy.getEnergy() >= 50.0 && !this.slot.isEmpty() && this.tank.getFluidAmount() > 1) {
            ItemReactorCoolant coolant = (ItemReactorCoolant)this.slot.get().func_77973_b();
            int need = coolant.needFill(this.slot.get());
            if (coolant == IUItem.coolant && this.tank.getFluid().getFluid() == FluidName.fluidhyd.getInstance() && need > 0) {
                coolant.fill(this.slot.get());
                this.tank.drain(1, true);
                this.setActive(true);
                this.energy.useEnergy(50.0);
            } else if (coolant == IUItem.adv_coolant && this.tank.getFluid().getFluid() == FluidName.fluidazot.getInstance() && need > 0) {
                coolant.fill(this.slot.get());
                this.tank.drain(1, true);
                this.setActive(true);
                this.energy.useEnergy(50.0);
            } else if (coolant == IUItem.imp_coolant && this.tank.getFluid().getFluid() == FluidName.fluidHelium.getInstance() && need > 0) {
                coolant.fill(this.slot.get());
                this.tank.drain(1, true);
                this.setActive(true);
                this.energy.useEnergy(50.0);
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.upgradeSlot.tickNoMark();
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.FluidConsuming, UpgradableProperty.FluidProducing);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            // empty if block
        }
    }
}

