/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.container.ContainerSafetyDoom;
import com.denfop.gui.GuiSafetyDoom;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityReactorSafetyDoom
extends TileElectricMachine {
    public final ComponentBaseEnergy rad;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    public List<List<IAdvReactor>> iAdvReactorList = new ArrayList<List<IAdvReactor>>();
    public boolean full = false;

    public TileEntityReactorSafetyDoom() {
        super(50000.0, 14, 1);
        this.rad = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.RADIATION, this, 5.0E9));
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        ChunkPos chunkPos = this.func_145831_w().func_175726_f(this.field_174879_c).func_76632_l();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                ChunkPos chunkPos1 = new ChunkPos(chunkPos.field_77276_a + x, chunkPos.field_77275_b + z);
                List list = RadiationSystem.rad_system.getAdvReactorMap().computeIfAbsent(chunkPos1, k -> new ArrayList());
                this.iAdvReactorList.add(list);
                this.full = this.full || !list.isEmpty();
            }
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.full);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.full = customPacketBuffer.readBoolean();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.reactor_safety_doom;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().field_73011_w.getWorldTime() % 300L == 0L) {
            boolean work = false;
            this.full = false;
            if (this.rad.getEnergy() < this.rad.getCapacity()) {
                block0: for (List<IAdvReactor> reactors : this.iAdvReactorList) {
                    for (IAdvReactor reactor : reactors) {
                        this.full = true;
                        double free = this.rad.getFreeEnergy();
                        if (free == 0.0 || this.energy.getEnergy() < 1000.0) continue block0;
                        double energy1 = Math.min(reactor.getRadiation().getEnergy(), free);
                        reactor.getRadiation().useEnergy(energy1);
                        this.rad.addEnergy(energy1);
                        this.energy.useEnergy(1000.0);
                        work = true;
                    }
                }
            }
            this.setActive(work);
        }
    }

    public ContainerSafetyDoom getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSafetyDoom(this, entityPlayer);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiSafetyDoom getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiSafetyDoom(this.getGuiContainer(entityPlayer));
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.radiation.getSoundEvent();
    }
}

