/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.ITransformer;
import com.denfop.componets.AdvEnergy;
import com.denfop.componets.Redstone;
import com.denfop.componets.RedstoneHandler;
import com.denfop.container.ContainerTransformer;
import com.denfop.gui.GuiTransformer;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileTransformer
extends TileEntityInventory
implements IUpdatableTileEvent,
ITransformer {
    private static final Mode defaultMode = Mode.redstone;
    protected final AdvEnergy energy;
    private final int defaultTier;
    private final Redstone redstone;
    private boolean hasRedstone = false;
    private double inputFlow = 0.0;
    private double outputFlow = 0.0;
    private Mode configuredMode = defaultMode;
    private Mode transformMode = null;

    public TileTransformer(int tier) {
        this.defaultTier = tier;
        this.energy = this.addComponent(new AdvEnergy((TileEntityInventory)this, EnergyNetGlobal.instance.getPowerFromTier(tier) * 4.0, Collections.emptyList(), Collections.emptyList(), tier, tier, true).setMultiSource(true));
        this.redstone = this.addComponent(new Redstone(this));
        this.redstone.subscribe(new RedstoneHandler(){

            @Override
            public void action(int input) {
                TileTransformer.this.hasRedstone = input != 0;
            }
        });
    }

    public String getType() {
        switch (this.energy.getSourceTier()) {
            case 1: {
                return "LV";
            }
            case 2: {
                return "MV";
            }
            case 3: {
                return "HV";
            }
            case 4: {
                return "EV";
            }
            case 5: {
                return "UMV";
            }
            case 6: {
                return "UHV";
            }
            case 7: {
                return "UEV";
            }
            case 8: {
                return "UMHV";
            }
            case 9: {
                return "UMEV";
            }
            case 10: {
                return "UHEV";
            }
            case 11: {
                return "HEEV";
            }
        }
        return "";
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.configuredMode = Mode.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.inputFlow = (Double)DecoderHandler.decode(customPacketBuffer);
            this.outputFlow = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, (Object)this.configuredMode);
            EncoderHandler.encode(packet, this.inputFlow);
            EncoderHandler.encode(packet, this.outputFlow);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int mode = nbt.func_74762_e("mode");
        this.configuredMode = mode >= 0 && mode < Mode.VALUES.length ? Mode.VALUES[mode] : defaultMode;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("mode", this.configuredMode.ordinal());
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.updateRedstone(true);
        }
    }

    @Override
    public Mode getMode() {
        return this.configuredMode;
    }

    @Override
    public void updateTileServer(EntityPlayer player, double event) {
        if (event >= 0.0 && event < (double)Mode.VALUES.length) {
            this.configuredMode = Mode.VALUES[(int)event];
            this.updateRedstone(false);
        } else if (event == 3.0) {
            this.outputFlow = EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSinkTier());
            this.inputFlow = EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSinkTier());
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.updateRedstone(false);
    }

    private void updateRedstone(boolean force) {
        Mode newMode;
        assert (!this.func_145831_w().field_72995_K);
        switch (this.configuredMode) {
            case redstone: {
                newMode = this.hasRedstone ? Mode.stepup : Mode.stepdown;
                break;
            }
            case stepdown: 
            case stepup: {
                newMode = this.configuredMode;
                break;
            }
            default: {
                throw new RuntimeException("invalid mode: " + (Object)((Object)this.configuredMode));
            }
        }
        this.energy.setEnabled(true);
        if (force || this.transformMode != newMode) {
            this.transformMode = newMode;
            this.setActive(this.isStepUp());
            if (this.isStepUp()) {
                this.energy.setSourceTier(this.defaultTier + 1);
                this.energy.setSinkTier(this.defaultTier);
                this.energy.setPacketOutput(1);
                this.energy.setDirections(Arrays.asList(EnumFacing.field_82609_l).stream().filter(facing -> facing != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()));
            } else {
                this.energy.setSourceTier(this.defaultTier);
                this.energy.setSinkTier(this.defaultTier + 1);
                this.energy.setPacketOutput(4);
                this.energy.setDirections(Collections.singletonList(this.getFacing()), Arrays.stream(EnumFacing.field_82609_l).filter(facing -> facing != this.getFacing()).collect(Collectors.toList()));
            }
            this.outputFlow = EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier());
            this.inputFlow = EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSinkTier());
        }
    }

    @Override
    public void setFacing(EnumFacing facing) {
        super.setFacing(facing);
        if (!this.func_145831_w().field_72995_K) {
            this.updateRedstone(true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        super.addInformation(stack, tooltip, advanced);
        tooltip.add(Localization.translate("iu.item.tooltip.Low") + " " + (int)EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSinkTier()) + " " + Localization.translate("iu.generic.text.EUt") + " " + Localization.translate("iu.item.tooltip.High") + " " + (int)EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier() + 1) + " " + Localization.translate("iu.generic.text.EUt"));
    }

    public ContainerTransformer getGuiContainer(EntityPlayer player) {
        return new ContainerTransformer(player, this, 219);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiTransformer(new ContainerTransformer(player, this, 219));
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public double getinputflow() {
        return !this.isStepUp() ? this.inputFlow : this.outputFlow;
    }

    @Override
    public double getoutputflow() {
        return this.isStepUp() ? this.inputFlow : this.outputFlow;
    }

    @Override
    public boolean isStepUp() {
        return this.transformMode == Mode.stepup;
    }

    public static enum Mode {
        redstone,
        stepdown,
        stepup;

        static final Mode[] VALUES;

        static {
            VALUES = Mode.values();
        }
    }
}

