/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.IAdvEnergyNet;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.SunCoef;
import com.denfop.api.gui.IType;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.sytem.EnergyType;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerSolarGeneratorEnergy;
import com.denfop.gui.GuiSolarGeneratorEnergy;
import com.denfop.invslot.InvSlotGenSunarrium;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileSolarGeneratorEnergy
extends TileEntityInventory
implements IUpdatableTileEvent,
IType {
    public final InvSlotGenSunarrium input;
    public final InvSlotOutput outputSlot;
    public final ItemStack itemstack = new ItemStack(IUItem.sunnarium, 1, 4);
    public final double maxSunEnergy;
    public final double cof;
    public boolean work;
    public ComponentBaseEnergy sunenergy;
    public List<Double> lst;
    public double coef_day;
    public double coef_night;
    public double update_night;
    public double generation;
    private boolean noSunWorld;
    private boolean skyIsVisible;
    private boolean sunIsUp;
    private SunCoef sunCoef;

    public TileSolarGeneratorEnergy(double cof) {
        this.maxSunEnergy = 6500.0;
        this.cof = cof;
        this.outputSlot = new InvSlotOutput(this, 1);
        this.input = new InvSlotGenSunarrium(this);
        this.lst = new ArrayList<Double>();
        this.lst.add(0.0);
        this.lst.add(0.0);
        this.lst.add(0.0);
        this.sunenergy = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.SOLARIUM, this, 10000.0, 1));
        this.coef_day = 0.0;
        this.coef_night = 0.0;
        this.update_night = 0.0;
    }

    @Override
    public int func_70302_i_() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.solarium_energy.info"));
            tooltip.add(Localization.translate("iu.info_upgrade_energy") + this.cof);
        }
        super.addInformation(stack, tooltip, advanced);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.work = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.generation = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.work);
            EncoderHandler.encode(packet, this.generation);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.sunenergy, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.sunenergy.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.lst = this.input.coefday();
        this.noSunWorld = this.field_145850_b.field_73011_w.func_177495_o();
        this.coef_day = this.lst.get(0);
        this.coef_night = this.lst.get(1);
        this.update_night = this.lst.get(2);
        IAdvEnergyNet advEnergyNet = EnergyNetGlobal.instance;
        this.sunCoef = advEnergyNet.getSunCoefficient(this.field_145850_b);
        this.updateVisibility();
    }

    public void updateVisibility() {
        this.skyIsVisible = this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) && this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_185904_a().func_151565_r() == MapColor.field_151660_b && !this.noSunWorld;
        this.sunIsUp = this.field_145850_b.func_72935_r();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.field_145850_b.field_73011_w.getWorldTime() % 80L == 0L) {
            this.updateVisibility();
        }
        this.generation = 0.0;
        if (this.skyIsVisible) {
            this.energy();
            if (this.sunenergy.getEnergy() >= 6500.0 && (this.outputSlot.get().func_190916_E() < 64 || this.outputSlot.isEmpty()) && this.outputSlot.add(this.itemstack)) {
                this.sunenergy.addEnergy(-6500.0);
            }
        }
    }

    public void energy() {
        if (this.sunIsUp) {
            this.generation = this.sunCoef.getCoef() * 30.0 * this.cof * (1.0 + this.coef_day);
            this.sunenergy.addEnergy(this.generation);
        } else if (this.update_night > 0.0) {
            this.generation = this.sunCoef.getCoef() * 30.0 * this.cof * (this.update_night - 1.0) * (1.0 + this.coef_night);
            this.sunenergy.addEnergy(this.generation);
        }
    }

    public ContainerSolarGeneratorEnergy getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSolarGeneratorEnergy(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiSolarGeneratorEnergy(new ContainerSolarGeneratorEnergy(entityPlayer, this));
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        this.work = !this.work;
    }

    @Override
    public EnumTypeStyle getStyle() {
        return EnumTypeStyle.DEFAULT;
    }
}

