/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.Config;
import com.denfop.IUItem;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerNeutronGenerator;
import com.denfop.gui.GuiNeutronGenerator;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileNeutronGenerator
extends TileElectricMachine
implements IUpgradableBlock,
IUpdatableTileEvent {
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotOutput outputSlot;
    public final InvSlotFluid containerslot;
    public final FluidTank fluidTank;
    protected final Fluids fluids;
    private final float energycost = (float)Config.energy / 100.0f;
    public boolean work = true;

    public TileNeutronGenerator() {
        super((int)(Config.energy * 128.0), 14, 1);
        this.outputSlot = new InvSlotOutput(this, 1);
        this.containerslot = new InvSlotFluidByList(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT, FluidName.fluidNeutron.getInstance());
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("fluidTank", 9000, Fluids.fluidPredicate(FluidName.fluidNeutron.getInstance()));
    }

    private static int applyModifier(int extra) {
        double ret = Math.round(14.0 + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.work = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine.neutron_generator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.machines;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.setUpgradestat();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.work = nbt.func_74767_n("work");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("work", this.work);
        return nbt;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.containerslot.isEmpty()) {
            this.containerslot.processFromTank((IFluidTank)this.fluidTank, this.outputSlot);
        }
        if (this.work && this.energy.getEnergy() >= (double)this.energycost) {
            boolean needsInvUpdate;
            if (!this.getActive()) {
                this.setActive(true);
            }
            if ((needsInvUpdate = this.attemptGeneration()) && this.upgradeSlot.tickNoMark()) {
                this.setUpgradestat();
            }
        } else if (this.getActive()) {
            this.setActive(false);
        }
        this.upgradeSlot.tickNoMark();
    }

    public boolean attemptGeneration() {
        int k = (int)(this.energy.getEnergy() / (double)this.energycost);
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return false;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        this.fluidTank.fillInternal(new FluidStack(FluidName.fluidNeutron.getInstance(), Math.min(m, k)), true);
        this.energy.useEnergy(this.energycost * (float)Math.min(m, k));
        return true;
    }

    public String getProgressAsString() {
        int p = Math.min((int)(this.energy.getEnergy() * 100.0 / (double)this.energycost), 100);
        return "" + p + "%";
    }

    public ContainerNeutronGenerator getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerNeutronGenerator(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiNeutronGenerator getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiNeutronGenerator(new ContainerNeutronGenerator(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(TileNeutronGenerator.applyModifier(this.upgradeSlot.extraTier));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidProducing);
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        if (i != 10.0) {
            this.work = !this.work;
        } else {
            super.updateTileServer(entityPlayer, i);
        }
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

