/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.denfop.Config;
import com.denfop.ElectricItem;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.container.ContainerFisher;
import com.denfop.gui.GuiFisher;
import com.denfop.invslot.InvSlotFisher;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.FakePlayerSpawner;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileFisher
extends TileElectricMachine
implements IUpgradableBlock,
IManufacturerBlock {
    private static Field _Random_seed = null;
    public final int energyconsume;
    public final InvSlotFisher inputslot;
    public int progress = 0;
    protected Random _rand = null;
    protected float _next = Float.NaN;
    private boolean checkwater = false;
    private int level = 1;
    private FakePlayerSpawner player;
    private EntityFishHook energyFishHook;
    private LootContext.Builder lootcontext$builder;
    private LootTable table;
    private LootPool listPool;

    public TileFisher() {
        super(10000.0, 14, 9);
        this.energyconsume = 100;
        this.inputslot = new InvSlotFisher(this);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.fisher;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void removeLevel(int level) {
        this.level -= level;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.energyconsume + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip, advanced);
    }

    private boolean checkwater() {
        int x1 = this.field_174879_c.func_177958_n();
        int y1 = this.field_174879_c.func_177956_o() - 2;
        int z1 = this.field_174879_c.func_177952_p();
        for (int i = x1 - 1; i <= x1 + 1; ++i) {
            for (int j = z1 - 1; j <= z1 + 1; ++j) {
                for (int k = y1 - 1; k <= y1 + 1; ++k) {
                    if (this.func_145831_w().func_180495_p(new BlockPos(i, k, j)).func_177230_c() == Blocks.field_150355_j) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.checkwater = this.checkwater();
        this.player = new FakePlayerSpawner(this.func_145831_w());
        this.energyFishHook = new EntityFishHook(this.func_145831_w(), (EntityPlayer)this.player);
        this.lootcontext$builder = new LootContext.Builder((WorldServer)this.field_145850_b);
        this.table = this.field_145850_b.func_184146_ak().func_186521_a(LootTableList.field_186387_al);
        this.listPool = this.table.getPool("main");
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this._rand == null) {
            this._rand = new Random(super.func_145831_w().func_72905_C() ^ super.func_145831_w().field_73012_v.nextLong());
            this._next = this._rand.nextFloat();
        }
        if (this.func_145831_w().field_73011_w.getWorldTime() % 100L == 0L) {
            this.checkwater = this.checkwater();
        }
        if (this.checkwater && !this.inputslot.isEmpty()) {
            IEnergyContainerItem item;
            int energy;
            boolean need;
            if (this.inputslot.get().func_77973_b() instanceof IEnergyItem ? !(need = ElectricItem.manager.canUse(this.inputslot.get(), 100.0)) : this.inputslot.get().func_77973_b() instanceof IEnergyContainerItem && (energy = (item = (IEnergyContainerItem)this.inputslot.get().func_77973_b()).getEnergyStored(this.inputslot.get())) < 100 * Config.coefficientrf) {
                return;
            }
            if (this.progress < 100) {
                if (this.energy.getEnergy() >= (double)this.energyconsume) {
                    if (!this.getActive()) {
                        this.setActive(true);
                    }
                    if (this.getActive() && this.progress == 0) {
                        this.initiate(0);
                    }
                    this.progress += this.level;
                } else if (this.getActive()) {
                    this.initiate(2);
                    this.setActive(false);
                }
            }
        } else if (this.getActive()) {
            this.initiate(2);
            this.setActive(false);
        }
        if (this.checkwater && this.progress >= 100) {
            if (this.getActive()) {
                this.initiate(2);
            }
            if (!this.inputslot.isEmpty()) {
                int k;
                ItemStack stack = this.inputslot.get();
                int j = EnchantmentHelper.func_191528_c((ItemStack)stack);
                if (j > 0) {
                    this.energyFishHook.func_191516_a(j);
                }
                if ((k = EnchantmentHelper.func_191529_b((ItemStack)stack)) > 0) {
                    this.energyFishHook.func_191517_b(k);
                }
                this.lootcontext$builder.func_186469_a((float)k + this.energyFishHook.field_146042_b.func_184817_da()).func_186470_a(this.energyFishHook.field_146042_b).func_186472_a((Entity)this.energyFishHook);
                ArrayList list = Lists.newArrayList();
                this.listPool.func_186449_b((Collection)list, this._rand, this.lootcontext$builder.func_186471_a());
                for (ItemStack var1 : list) {
                    if (this.outputSlot.add(var1)) {
                        this.energy.useEnergy(this.energyconsume);
                    }
                    this._next = this._rand.nextFloat();
                    this.progress = 0;
                }
                int damage = stack.func_77958_k() - stack.func_77952_i();
                int m = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
                if (!(stack.func_77973_b() instanceof IEnergyItem) && !(stack.func_77973_b() instanceof IEnergyContainerItem)) {
                    Random rand;
                    if (this.inputslot.get().func_77952_i() > -1 && (rand = this.func_145831_w().field_73012_v).nextInt(1 + m) == 0 && damage > -1) {
                        this.inputslot.get().func_77964_b(this.inputslot.get().func_77952_i() + 1);
                    }
                    if (this.inputslot.get().func_77952_i() >= this.inputslot.get().func_77958_k() && damage > -1) {
                        this.inputslot.consume(1);
                    }
                } else {
                    Random rand = this.func_145831_w().field_73012_v;
                    if (stack.func_77973_b() instanceof IEnergyItem) {
                        if (rand.nextInt(1 + m) == 0) {
                            ElectricItem.manager.use(stack, 100.0, null);
                        }
                    } else {
                        IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
                        if (rand.nextInt(1 + m) == 0) {
                            item.extractEnergy(stack, 100 * Config.coefficientrf, false);
                        }
                    }
                }
            }
        }
        if (this.getActive() && this.field_145850_b.func_72820_D() % 20L == 0L && !this.outputSlot.isEmpty()) {
            ModUtils.tick(this.outputSlot, this);
        }
    }

    @Override
    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        if (this.level != 1) {
            ret.add(new ItemStack((Item)IUItem.upgrade_speed_creation, this.level));
            this.level = 1;
        }
        return ret;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.level < 10) {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_77973_b().equals(IUItem.upgrade_speed_creation)) {
                return super.onActivated(player, hand, side, hitX, hitY, hitZ);
            }
            stack.func_190918_g(1);
            ++this.level;
            return false;
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74762_e("progress");
        if (nbttagcompound.func_74764_b("seed")) {
            this._rand = new Random(nbttagcompound.func_74763_f("seed"));
        }
        if (nbttagcompound.func_74764_b("next")) {
            this._next = nbttagcompound.func_74760_g("next");
        }
        this.level = nbttagcompound.func_74762_e("level");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74776_a("next", this._next);
        nbttagcompound.func_74768_a("level", this.level);
        nbttagcompound.func_74768_a("progress", this.progress);
        if (_Random_seed != null) {
            try {
                nbttagcompound.func_74772_a("seed", ((AtomicLong)_Random_seed.get(this._rand)).get());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return nbttagcompound;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiFisher getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiFisher(new ContainerFisher(entityPlayer, this));
    }

    public ContainerFisher getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerFisher(entityPlayer, this);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemProducing);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.fisher.getSoundEvent();
    }

    static {
        try {
            Field var0 = Random.class.getDeclaredField("seed");
            var0.setAccessible(true);
            _Random_seed = var0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

