/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerTank;
import com.denfop.gui.GuiTank;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityLiquedTank
extends TileEntityInventory
implements IUpgradableBlock {
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotFluidByList containerslot = new InvSlotFluidByList(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT, new Fluid[0]);
    public final InvSlotFluidByList containerslot1;
    public final ResourceLocation texture;
    public final Fluids fluids;
    public final InvSlotOutput outputSlot;
    public FluidTank fluidTank;
    private int old_amount;

    public TileEntityLiquedTank(int tanksize, String texturename) {
        this.containerslot.setUsually(true);
        this.containerslot1 = new InvSlotFluidByList(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.INPUT, new Fluid[0]);
        this.containerslot1.setUsually(true);
        this.texture = new ResourceLocation("industrialupgrade", "textures/models/" + texturename + ".png");
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("fluidTank", tanksize * 1000);
        this.outputSlot = new InvSlotOutput(this, 1);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.fluidTank = (FluidTank)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.getComp(Fluids.class).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)));
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)stack.func_77978_p().func_74781_a("fluid")));
            tooltip.add(Localization.translate("iu.fluid.info") + fluidStack.getLocalizedName());
            tooltip.add(Localization.translate("iu.fluid.info1") + fluidStack.amount / 1000 + " B");
        }
        super.addInformation(stack, tooltip, advanced);
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)stack.func_77978_p().func_74781_a("fluid")));
            if (fluidStack != null) {
                this.fluidTank.fill(fluidStack, true);
            }
            this.old_amount = this.fluidTank.getFluidAmount();
            new PacketUpdateFieldTile(this, "fluidTank", this.fluidTank);
        }
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        drop = super.adjustDrop(drop, wrench);
        if ((wrench || this.teBlock.getDefaultDrop() == MultiTileBlock.DefaultDrop.Self) && this.fluidTank.getFluidAmount() > 0) {
            NBTTagCompound nbt = ModUtils.nbt(drop);
            nbt.func_74782_a("fluid", (NBTBase)this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        return drop;
    }

    public double gaugeLiquidScaled(double i) {
        return this.getFluidTank().getFluidAmount() <= 0 ? 0.0 : (double)this.getFluidTank().getFluidAmount() * i / (double)this.getFluidTank().getCapacity();
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.fluidTank = (FluidTank)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean needsFluid() {
        return this.getFluidTank().getFluidAmount() < this.getFluidTank().getCapacity();
    }

    @Override
    public void updateEntityServer() {
        MutableObject output;
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L) {
            boolean need = false;
            if (this.fluidTank.getFluidAmount() != this.old_amount) {
                this.old_amount = this.fluidTank.getFluidAmount();
                need = true;
            }
            if (need) {
                new PacketUpdateFieldTile(this, "fluidTank", this.fluidTank);
            }
        }
        if (this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        if (this.needsFluid()) {
            output = new MutableObject();
            if (this.fluidTank.getFluidAmount() + 1000 <= this.fluidTank.getCapacity() && this.containerslot1.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
                needsInvUpdate = this.containerslot1.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
                if (output.getValue() != null) {
                    this.outputSlot.add((ItemStack)output.getValue());
                }
            }
        }
        if (this.upgradeSlot.tickNoMark() && needsInvUpdate) {
            this.setUpgradestat();
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("fluidTank")) {
            try {
                this.fluidTank.readFromNBT(((FluidTank)DecoderHandler.decode(is)).writeToNBT(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    public boolean canFill() {
        return true;
    }

    public boolean canDrain() {
        return true;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public ContainerTank getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerTank(entityPlayer, this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.canFill() ? this.getFluidTank().fill(resource, doFill) : 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return !this.canDrain() ? null : this.getFluidTank().drain(maxDrain, doDrain);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiTank(new ContainerTank(entityPlayer, this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (IUCore.proxy.isSimulating()) {
            this.setUpgradestat();
        }
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidProducing, UpgradableProperty.FluidConsuming);
    }
}

