/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockAnvil;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.register.RegisterOreDictionary;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityAnvil
extends TileEntityInventory
implements IUpdateTick,
IHasRecipe {
    public final InvSlotRecipes inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "anvil", (IUpdateTick)this);
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, 1);
    public int progress = 0;
    public MachineRecipe output;
    private static final List<AxisAlignedBB> aabbs = Collections.singletonList(new AxisAlignedBB(0.0, 0.0, -1.0, 1.0, 1.0, 2.0));
    private static final List<AxisAlignedBB> aabbs1 = Collections.singletonList(new AxisAlignedBB(-1.0, 0.0, 0.0, 2.0, 1.0, 1.0));

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        if (this.facing == 4 || this.facing == 5) {
            return aabbs1;
        }
        return aabbs;
    }

    public TileEntityAnvil() {
        Recipes.recipes.addInitRecipes(this);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.anvil;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockAnvil.block_anvil;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        this.output = this.inputSlotA.process();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == IUItem.ForgeHammer && this.output != null && this.outputSlot.canAdd(this.output.getRecipe().output.items.get(0))) {
            this.progress += 10;
            if (this.progress >= 100) {
                this.progress = 0;
                this.outputSlot.add(this.output.getRecipe().output.items.get(0));
                this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                if (this.inputSlotA.isEmpty() || this.outputSlot.get().func_190916_E() >= 64) {
                    this.output = null;
                }
            }
            return true;
        }
        if (!stack.func_190926_b()) {
            if (this.inputSlotA.get(0).func_190926_b() && this.inputSlotA.accepts(stack, 0)) {
                this.inputSlotA.put(0, stack.func_77946_l());
                stack.func_190920_e(0);
                return true;
            }
            if (!this.inputSlotA.get(0).func_190926_b() && this.inputSlotA.get(0).func_77969_a(stack)) {
                int minCount = 64 - this.inputSlotA.get(0).func_190916_E();
                minCount = Math.min(stack.func_190916_E(), minCount);
                this.inputSlotA.get(0).func_190917_f(minCount);
                stack.func_190917_f(-minCount);
                return true;
            }
        } else {
            if (!this.outputSlot.isEmpty()) {
                if (!this.field_145850_b.field_72995_K) {
                    ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.outputSlot.get());
                }
                this.outputSlot.get().func_190920_e(0);
                return true;
            }
            if (!this.inputSlotA.isEmpty()) {
                if (!this.field_145850_b.field_72995_K) {
                    ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.inputSlotA.get());
                }
                this.inputSlotA.get().func_190920_e(0);
                return true;
            }
        }
        return false;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        for (String s : RegisterOreDictionary.list_string) {
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingot" + s, 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)("plate" + s)))));
        }
        for (String s : RegisterOreDictionary.list_string1) {
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingot" + s, 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)("plate" + s)))));
        }
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotIron", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateIron"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotGold", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateGold"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotLead", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateLead"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotTin", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateTin"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotOsmium", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateOsmium"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotTantalum", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateTantalum"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotCadmium", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateCadmium"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotSteel", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateSteel"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotBronze", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateBronze"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotCopper", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateCopper"))));
    }
}

