/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.componets.AdvEnergy;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.TypeUpgrade;
import com.denfop.container.ContainerDoubleElectricMachine;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotDischarge;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.EnumDoubleElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public abstract class TileDoubleElectricMachine
extends TileEntityInventory
implements IAudioFixer,
IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent {
    public final AdvEnergy energy;
    public final InvSlotDischarge dischargeSlot;
    public final InvSlotRecipes inputSlotA;
    public final InvSlotOutput outputSlot;
    public final InvSlotUpgrade upgradeSlot;
    public final HeatComponent heat;
    protected final EnumDoubleElectricMachine type;
    private final ComponentUpgrade componentUpgrades;
    public MachineRecipe output;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    public ComponentUpgradeSlots componentUpgrade;
    public ComponentProgress componentProgress;
    public ComponentProcess componentProcess;
    private boolean sound = true;

    public TileDoubleElectricMachine(int energyPerTick, int length, int outputSlots, EnumDoubleElectricMachine type) {
        this(energyPerTick, length, outputSlots, 1, type, true);
    }

    public TileDoubleElectricMachine(int energyPerTick, int length, int outputSlots, EnumDoubleElectricMachine type, boolean register) {
        this(energyPerTick, length, outputSlots, 1, type, register);
    }

    public TileDoubleElectricMachine(int energyPerTick, int length, int outputSlots, int aDefaultTier, EnumDoubleElectricMachine type, boolean register) {
        this.outputSlot = new InvSlotOutput(this, outputSlots);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.dischargeSlot = new InvSlotDischarge(this, InvSlot.TypeItemSlot.INPUT, aDefaultTier, false);
        this.energy = this.addComponent(AdvEnergy.asBasicSink((TileEntityInventory)this, (double)energyPerTick * (double)length, aDefaultTier).addManagedSlot(this.dischargeSlot));
        this.inputSlotA = new InvSlotRecipes((TileEntityInventory)this, type.recipe_name, (IUpdateTick)this);
        this.type = type;
        this.output = null;
        this.heat = type.heat ? this.addComponent(HeatComponent.asBasicSink(this, 5000.0)) : null;
        if (register) {
            this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
            this.componentProgress = this.addComponent(new ComponentProgress(this, 1, (short)length));
            this.componentProcess = this.addComponent(new ComponentProcess(this, length, energyPerTick));
            this.componentProcess.setHasAudio(true);
            this.componentProcess.setSlotOutput(this.outputSlot);
            this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        }
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT, TypeUpgrade.STACK));
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        this.sound = !this.sound;
        new PacketUpdateFieldTile(this, "sound", this.sound);
        if (!this.sound && this.getType() == EnumTypeAudio.ON) {
            this.setType(EnumTypeAudio.OFF);
            new PacketStopSound(this.func_145831_w(), this.field_174879_c);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("sound")) {
            try {
                this.sound = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.sound = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.sound);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onNetworkEvent(int var1) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77952_i() == 4 && this.type == EnumDoubleElectricMachine.ALLOY_SMELTER) {
            if (!Keyboard.isKeyDown((int)42)) {
                tooltip.add(Localization.translate("press.lshift"));
            }
            if (Keyboard.isKeyDown((int)42)) {
                tooltip.add(Localization.translate("iu.heatmachine.info"));
                tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getDefaultEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
                tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getDefaultOperationLength());
            }
        } else if (stack.func_77952_i() == 0 && EnumDoubleElectricMachine.SUNNARIUM_PANEL == this.type) {
            if (!Keyboard.isKeyDown((int)42)) {
                tooltip.add(Localization.translate("press.lshift"));
            }
            if (Keyboard.isKeyDown((int)42)) {
                tooltip.add(Localization.translate("iu.solarium_energy_sink.info"));
                tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getDefaultEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
                tooltip.add(Localization.translate("iu.machines_work_energy") + 5 + Localization.translate("iu.machines_work_energy_type_se"));
                tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getDefaultOperationLength());
            }
        } else {
            if (!Keyboard.isKeyDown((int)42)) {
                tooltip.add(Localization.translate("press.lshift"));
            }
            if (Keyboard.isKeyDown((int)42)) {
                tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getDefaultEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
                tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getDefaultOperationLength());
            }
        }
        if (this.getComp(AdvEnergy.class) != null) {
            AdvEnergy energy = this.getComp(AdvEnergy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public EnumTypeAudio getType() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getType() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (this.sound) {
            if (this.getSound() == null) {
                return;
            }
            if (soundEvent == 0) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (soundEvent == 1) {
                new PacketStopSound(this.func_145831_w(), this.field_174879_c);
                this.func_145831_w().func_184133_a(null, this.field_174879_c, EnumSound.InterruptOne.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                new PacketStopSound(this.func_145831_w(), this.field_174879_c);
            }
        }
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.sound = nbttagcompound.func_74767_n("sound");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("sound", this.sound);
        return nbttagcompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    public ContainerDoubleElectricMachine getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerDoubleElectricMachine(entityPlayer, this, this.type);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing);
    }

    public final float getChargeLevel() {
        return Math.min((float)this.energy.getEnergy() / (float)this.energy.getCapacity(), 1.0f);
    }

    public double getProgress() {
        return this.componentProgress.getBar();
    }

    public int getMode() {
        return 0;
    }
}

