/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.audio.EnumSound;
import com.denfop.componets.Action;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.TypeAction;
import com.denfop.componets.TypeLoad;
import com.denfop.componets.TypeUpgrade;
import com.denfop.container.ContainerBaseWitherMaker;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileElectricMachine;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public abstract class TileBaseWitherMaker
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick {
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, 4);
    public final ComponentUpgradeSlots componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
    public final ComponentProgress componentProgress;
    public final ComponentProcess componentProcess;
    private final ComponentUpgrade componentUpgrades;
    public MachineRecipe output = null;
    public InvSlotRecipes inputSlotA;

    public TileBaseWitherMaker(int energyPerTick, int length, int outputSlots) {
        this(energyPerTick, length, outputSlots, 1);
    }

    public TileBaseWitherMaker(int energyPerTick, int length, int outputSlots, int aDefaultTier) {
        super(energyPerTick * length, 1, outputSlots);
        this.componentProgress = this.addComponent(new ComponentProgress(this, 1, (short)length));
        this.componentProcess = this.addComponent(new ComponentProcess(this, length, energyPerTick));
        this.componentProcess.setHasAudio(true);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setAction(new Action(this, 20, TypeAction.AUDIO, TypeLoad.PROGRESS, 3));
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT, TypeUpgrade.STACK));
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getDefaultEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getDefaultOperationLength());
        }
        super.addInformation(stack, tooltip, advanced);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.inputSlotA.load();
        if (IUCore.proxy.isSimulating()) {
            this.output = this.getOutput();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().field_73011_w.getWorldTime() % 20L == 0L && !this.inputSlotA.isEmpty()) {
            ItemStack stack;
            int j;
            int i;
            for (i = 0; i < 3; ++i) {
                if (this.inputSlotA.get(i).func_190926_b() || this.inputSlotA.get(i).func_190916_E() <= 1 || this.inputSlotA.get(i).func_77973_b() != Items.field_151144_bL || this.inputSlotA.get(i).func_77952_i() != 1) continue;
                for (j = 0; j < 3; ++j) {
                    if (!this.inputSlotA.get(j).func_190926_b() || this.inputSlotA.get(i).func_190926_b() || this.inputSlotA.get(i).func_190916_E() <= 1) continue;
                    this.inputSlotA.consume(i, 1);
                    stack = new ItemStack(Items.field_151144_bL, 1, 1);
                    this.inputSlotA.put(j, stack);
                }
            }
            for (i = 3; i < 7; ++i) {
                for (j = 3; j < 7; ++j) {
                    if (i == j || this.inputSlotA.get(i).func_190926_b() || this.inputSlotA.get(i).func_190916_E() <= 1 || this.inputSlotA.get(i).func_77973_b() != Item.func_150898_a((Block)Blocks.field_150425_aM) || !this.inputSlotA.get(j).func_190926_b()) continue;
                    this.inputSlotA.consume(i, 1);
                    stack = new ItemStack(Blocks.field_150425_aM, 1);
                    this.inputSlotA.put(j, stack);
                }
            }
        }
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    public ContainerBaseWitherMaker getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerBaseWitherMaker(entityPlayer, this);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.WitherSpawn1.getSoundEvent();
    }
}

