/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import cofh.redstoneflux.api.IEnergyHandler;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.denfop.Config;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.container.ContainerAutoSpawner;
import com.denfop.gui.GuiAutoSpawner;
import com.denfop.invslot.InvSlotModules;
import com.denfop.invslot.InvSlotUpgradeModule;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.FakePlayerSpawner;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileAutoSpawner
extends TileElectricMachine
implements IEnergyReceiver,
IEnergyHandler,
IUpgradableBlock {
    public final InvSlotModules module_slot;
    public final double[] maxprogress;
    public final InvSlotUpgradeModule module_upgrade;
    public final int tempcostenergy;
    public final double maxEnergy2;
    public final int defaultconsume;
    public final ComponentBaseEnergy exp;
    public int[] progress;
    public int costenergy = 1500;
    public int[] tempprogress;
    public FakePlayerSpawner player;
    public double energy2;
    public int speed = 0;
    public int chance = 0;
    public int spawn = 1;
    public int experience = 0;
    public EntityLiving[] mobUtils = new EntityLiving[4];
    public String[] description_mobs = new String[4];
    public LootTable[] loot_Tables = new LootTable[4];
    public LootContext.Builder[] lootContext = new LootContext.Builder[4];
    public List<LootPool>[] lootPoolList = new List[4];
    public int fireAspect;

    public TileAutoSpawner() {
        super(150000.0, 14, 27);
        this.module_slot = new InvSlotModules(this);
        this.module_upgrade = new InvSlotUpgradeModule(this);
        this.progress = new int[this.module_slot.size()];
        this.maxEnergy2 = 50000 * Config.coefficientrf;
        this.maxprogress = new double[4];
        this.tempprogress = new int[]{100, 100, 100, 100};
        this.tempcostenergy = 1500;
        this.defaultconsume = this.costenergy;
        this.exp = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.EXPERIENCE, this, 15000.0, 14));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.spawner;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public int func_70302_i_() {
        return 1;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.receiveEnergy(maxReceive, simulate);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultconsume + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip, advanced);
    }

    public int receiveEnergy(int paramInt, boolean paramBoolean) {
        int i = (int)Math.min(this.maxEnergy2 - this.energy2, Math.min(EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSinkTier()) * 4.0, (double)paramInt));
        if (!paramBoolean) {
            this.energy2 += (double)i;
        }
        return i;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (int[])DecoderHandler.decode(customPacketBuffer);
            this.energy2 = (Double)DecoderHandler.decode(customPacketBuffer);
            this.tempprogress = (int[])DecoderHandler.decode(customPacketBuffer);
            this.description_mobs = (String[])DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.energy2);
            EncoderHandler.encode(packet, this.tempprogress);
            EncoderHandler.encode(packet, this.description_mobs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            this.player = new FakePlayerSpawner(this.func_145831_w());
        }
        this.module_slot.update();
        this.module_upgrade.update();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing arg0) {
        return true;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return (int)this.energy2;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return (int)this.maxEnergy2;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiAutoSpawner getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiAutoSpawner(new ContainerAutoSpawner(entityPlayer, this));
    }

    public ContainerAutoSpawner getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerAutoSpawner(entityPlayer, this);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L && !this.outputSlot.isEmpty()) {
            ModUtils.tick(this.outputSlot, this);
        }
        for (int i = 0; i < this.module_slot.size(); ++i) {
            if (this.module_slot.get(i).func_190926_b()) continue;
            if (this.energy.getEnergy() >= (double)this.costenergy || this.energy2 >= (double)(this.costenergy * Config.coefficientrf)) {
                int n = i;
                this.progress[n] = this.progress[n] + 1;
                if (this.energy.getEnergy() >= (double)this.costenergy) {
                    this.energy.useEnergy(this.costenergy);
                } else {
                    this.energy2 -= (double)(this.costenergy * Config.coefficientrf);
                }
            }
            this.tempprogress[i] = (int)(this.maxprogress[i] - (double)this.speed);
            this.tempprogress[i] = Math.max(1, this.tempprogress[i]);
            if (this.progress[i] < this.tempprogress[i]) continue;
            this.progress[i] = 0;
            if (this.mobUtils[i] == null) continue;
            EntityLiving entity = this.mobUtils[i];
            entity.func_70029_a(this.func_145831_w());
            this.dropItemFromEntity(entity, DamageSource.func_76365_a((EntityPlayer)this.player), this.loot_Tables[i], i);
            int exp = Math.max(entity.func_70693_a((EntityPlayer)this.player), 1);
            this.exp.addEnergy((double)exp + (double)(this.experience * exp) / 100.0);
        }
    }

    private void dropItemFromEntity(EntityLiving entity, DamageSource source, LootTable table, int index) {
        if (entity.func_184222_aU() && !this.field_145850_b.field_72995_K) {
            int i = this.chance;
            LootContext.Builder lootcontext$builder = this.lootContext[index];
            if (table == null) {
                return;
            }
            if (lootcontext$builder == null) {
                lootcontext$builder = this.lootContext[index] = new LootContext.Builder((WorldServer)this.field_145850_b).func_186472_a((Entity)entity).func_186470_a((EntityPlayer)this.player).func_186473_a(source).func_186469_a((float)i);
                ArrayList<LootPool> lootPools = new ArrayList<LootPool>();
                LootPool mainPool = table.getPool("main");
                if (mainPool != null) {
                    lootPools.add(mainPool);
                    int in = 1;
                    LootPool pool = table.getPool("pool" + in);
                    while (pool != null) {
                        lootPools.add(pool);
                        pool = table.getPool("pool" + ++in);
                    }
                }
                this.lootPoolList[index] = lootPools;
            }
            LootContext context = lootcontext$builder.func_186471_a();
            ArrayList list = Lists.newArrayList();
            for (int j = 0; j < this.spawn; ++j) {
                for (LootPool lootpool : this.lootPoolList[index]) {
                    lootpool.func_186449_b((Collection)list, this.func_145831_w().field_73012_v, context);
                }
            }
            for (ItemStack item : list) {
                ItemStack smelt = ItemStack.field_190927_a;
                if (this.fireAspect > 0 && !(smelt = FurnaceRecipes.func_77602_a().func_151395_a(item)).func_190926_b()) {
                    smelt.func_190920_e(item.func_190916_E());
                }
                if (smelt.func_190926_b()) {
                    this.outputSlot.add(item);
                    continue;
                }
                this.outputSlot.add(smelt);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy2", this.energy2);
        for (int i = 0; i < 4; ++i) {
            nbttagcompound.func_74768_a("progress" + i, this.progress[i]);
        }
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        for (int i = 0; i < 4; ++i) {
            this.progress[i] = nbttagcompound.func_74762_e("progress" + i);
        }
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemProducing);
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

