/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.transport;

import com.denfop.blocks.state.TileEntityBlockStateContainer;
import com.denfop.render.base.AbstractModel;
import com.denfop.render.base.BasicBakedBlockModel;
import com.denfop.render.base.ISpecialParticleModel;
import com.denfop.render.base.ModelCuboidUtil;
import com.denfop.tiles.transport.tiles.RenderState;
import com.denfop.tiles.transport.tiles.TileEntityCable;
import com.denfop.tiles.transport.types.ICableItem;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelCable
extends AbstractModel
implements ISpecialParticleModel {
    private final Map<ResourceLocation, TextureAtlasSprite> textures;
    private final LoadingCache<RenderState, IBakedModel> modelCache;
    private final ICableItem[] values;

    public ModelCable(ICableItem[] values) {
        this.values = values;
        this.textures = this.generateTextureLocations();
        this.modelCache = CacheBuilder.newBuilder().maximumSize(256L).expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<RenderState, IBakedModel>(){

            public IBakedModel load(@Nonnull RenderState key) {
                return ModelCable.this.generateModel(key);
            }
        });
    }

    private Map<ResourceLocation, TextureAtlasSprite> generateTextureLocations() {
        HashMap<ResourceLocation, TextureAtlasSprite> ret = new HashMap<ResourceLocation, TextureAtlasSprite>();
        for (ICableItem item : this.values) {
            ret.put(item.getRecourse(), null);
        }
        return ret;
    }

    @Override
    public Collection<ResourceLocation> getTextures() {
        return this.textures.keySet();
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        for (Map.Entry<ResourceLocation, TextureAtlasSprite> locationTextureAtlasSpriteEntry : this.textures.entrySet()) {
            locationTextureAtlasSpriteEntry.setValue(bakedTextureGetter.apply(locationTextureAtlasSpriteEntry.getKey()));
        }
        return this;
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState rawState, EnumFacing side, long rand) {
        if (!(rawState instanceof TileEntityBlockStateContainer.PropertiesStateInstance)) {
            return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174951_a().func_188616_a(rawState, side, rand);
        }
        TileEntityBlockStateContainer.PropertiesStateInstance state = (TileEntityBlockStateContainer.PropertiesStateInstance)rawState;
        if (!state.hasValue(TileEntityCable.renderStateProperty)) {
            return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174951_a().func_188616_a((IBlockState)state, side, rand);
        }
        RenderState prop = (RenderState)state.getValue(TileEntityCable.renderStateProperty);
        try {
            return ((IBakedModel)this.modelCache.get((Object)prop)).func_188616_a((IBlockState)state, side, rand);
        }
        catch (ExecutionException var8) {
            throw new RuntimeException(var8);
        }
    }

    private IBakedModel generateModel(RenderState prop) {
        int used;
        float th = 0.25f;
        float sp = (1.0f - th) / 2.0f;
        List[] faceQuads = new List[EnumFacing.field_82609_l.length];
        for (int i = 0; i < faceQuads.length; ++i) {
            faceQuads[i] = new ArrayList();
        }
        ArrayList<BakedQuad> generalQuads = new ArrayList();
        TextureAtlasSprite sprite = this.textures.get(new ResourceLocation(prop.resourceLocation.toString().replace(".png", "")));
        EnumFacing[] var7 = EnumFacing.field_82609_l;
        int i = var7.length;
        for (used = 0; used < i; ++used) {
            float zE;
            EnumFacing facing = var7[used];
            boolean hasConnection = (prop.connectivity & 1 << var7.length - 1 - facing.ordinal()) != 0;
            float zS = sp;
            float yS = sp;
            float xS = sp;
            float yE = zE = sp + th;
            float xE = zE;
            if (hasConnection) {
                switch (facing) {
                    case DOWN: {
                        yS = 0.0f;
                        yE = sp;
                        break;
                    }
                    case UP: {
                        yS = sp + th;
                        yE = 1.0f;
                        break;
                    }
                    case NORTH: {
                        zS = 0.0f;
                        zE = sp;
                        break;
                    }
                    case SOUTH: {
                        zS = sp + th;
                        zE = 1.0f;
                        break;
                    }
                    case WEST: {
                        xS = 0.0f;
                        xE = sp;
                        break;
                    }
                    case EAST: {
                        xS = sp + th;
                        xE = 1.0f;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                ModelCuboidUtil.addCuboid(xS, yS, zS, xE, yE, zE, EnumSet.complementOf(EnumSet.of(facing.func_176734_d())), sprite, faceQuads, generalQuads);
                continue;
            }
            ModelCuboidUtil.addCuboid(sp, sp, sp, xE, yE, zE, EnumSet.of(facing), sprite, faceQuads, generalQuads);
        }
        used = 0;
        for (i = 0; i < faceQuads.length; ++i) {
            if (faceQuads[i].isEmpty()) {
                faceQuads[i] = Collections.emptyList();
                continue;
            }
            ++used;
        }
        if (used == 0) {
            faceQuads = null;
        }
        if (generalQuads.isEmpty()) {
            generalQuads = Collections.emptyList();
        }
        return new BasicBakedBlockModel(faceQuads, generalQuads, sprite);
    }

    @Override
    public void onReload() {
        this.modelCache.invalidateAll();
    }

    @Override
    public boolean needsEnhancing(IBlockState state) {
        return true;
    }

    @Override
    public TextureAtlasSprite getParticleTexture(TileEntityBlockStateContainer.PropertiesStateInstance state) {
        if (!state.hasValue(TileEntityCable.renderStateProperty)) {
            return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174951_a().func_177554_e();
        }
        RenderState prop = (RenderState)state.getValue(TileEntityCable.renderStateProperty);
        return this.textures.get(prop.resourceLocation);
    }
}

