/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.streak;

import com.denfop.IUItem;
import com.denfop.render.streak.PlayerStreakInfo;
import com.denfop.render.streak.RGB;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class EventSpectralSuitEffect {
    public static final ResourceLocation texture = new ResourceLocation("industrialupgrade:textures/items/effect.png");
    public static final Map<String, PlayerStreakInfo> mapStreakInfo = new HashMap<String, PlayerStreakInfo>();
    private static final Map<String, ArrayList<StreakLocation>> playerLoc = new HashMap<String, ArrayList<StreakLocation>>();
    public final int[] red = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 222, 186, 150, 124, 96, 67, 40, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 34, 56, 78, 102, 121, 145, 176, 201, 218, 230, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    public final int[] green = new int[]{0, 24, 36, 54, 72, 96, 120, 145, 172, 192, 216, 234, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 234, 214, 195, 176, 153, 137, 112, 94, 86, 55, 31, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public final int[] blue = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 32, 45, 68, 78, 103, 118, 138, 151, 178, 205, 221, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 228, 208, 186, 165, 149, 132, 115, 102, 97, 76, 53, 32, 15, 0};

    public static ArrayList<StreakLocation> getPlayerStreakLocationInfo(EntityPlayer player) {
        ArrayList loc = playerLoc.computeIfAbsent(player.func_70005_c_(), k -> new ArrayList());
        if (loc.size() < 20) {
            for (int i = 0; i < 20 - loc.size(); ++i) {
                loc.add(0, new StreakLocation(player));
            }
        } else if (loc.size() > 20) {
            loc.remove(0);
        }
        return loc;
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null && this.isRenderStreak(player)) {
            ArrayList<StreakLocation> loc = EventSpectralSuitEffect.getPlayerStreakLocationInfo(player);
            GL11.glPushMatrix();
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glShadeModel((int)7425);
            float startGrad = 5.0f - event.getPartialRenderTick();
            float endGrad = 20.0f - event.getPartialRenderTick();
            for (int i = loc.size() - 2; i >= 0; --i) {
                double grad1;
                float startAlpha;
                int start = i;
                StreakLocation infoStart = loc.get(i);
                float f = (float)i < endGrad ? MathHelper.func_76131_a((float)(0.8f * (float)i / endGrad), (float)0.0f, (float)0.8f) : (startAlpha = (float)i > (float)(loc.size() - 2) - startGrad ? MathHelper.func_76131_a((float)(0.8f * (float)(loc.size() - 2 - i) / startGrad), (float)0.0f, (float)0.8f) : 0.8f);
                if (player.field_70170_p.func_72820_D() - infoStart.lastTick > 40L) break;
                StreakLocation infoEnd = null;
                double grad = 500.0;
                --i;
                while (i >= 0) {
                    StreakLocation infoPoint = loc.get(i);
                    if (infoStart.isSprinting && loc.size() - 2 - i < 6) {
                        infoEnd = infoPoint;
                        --start;
                        --i;
                        break;
                    }
                    if (infoPoint.hasSameCoords(infoStart)) {
                        --start;
                        --i;
                        continue;
                    }
                    grad1 = infoPoint.posZ - infoStart.posZ / (infoPoint.posX - infoStart.posX);
                    if (grad == grad1 && infoPoint.posY == infoStart.posY) {
                        infoEnd = infoPoint;
                        --start;
                        --i;
                        continue;
                    }
                    if (grad != 500.0) break;
                    grad = grad1;
                    infoEnd = infoPoint;
                    --i;
                }
                if (infoEnd == null) continue;
                float endAlpha = (float)(i += 2) < endGrad ? MathHelper.func_76131_a((float)(0.8f * (float)(i - 1) / endGrad), (float)0.0f, (float)0.8f) : ((float)i > (float)(loc.size() - 1) - startGrad ? MathHelper.func_76131_a((float)(0.8f * (float)(loc.size() - 1 - i) / startGrad), (float)0.0f, (float)0.8f) : 0.8f);
                grad1 = infoStart.posX - mc.func_175598_ae().field_78725_b;
                double posY = infoStart.posY - mc.func_175598_ae().field_78726_c;
                double posZ = infoStart.posZ - mc.func_175598_ae().field_78723_d;
                double nextPosX = infoEnd.posX - mc.func_175598_ae().field_78725_b;
                double nextPosY = infoEnd.posY - mc.func_175598_ae().field_78726_c;
                double nextPosZ = infoEnd.posZ - mc.func_175598_ae().field_78723_d;
                Tessellator tessellator = Tessellator.func_178181_a();
                GL11.glPushMatrix();
                GL11.glTranslated((double)grad1, (double)posY, (double)posZ);
                int ii = 0xF000F0;
                int j = ii % 65536;
                int k = ii / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
                RenderHelper.func_74518_a();
                GL11.glDisable((int)2896);
                PlayerStreakInfo playerStreak = mapStreakInfo.get(player.func_70005_c_());
                if (playerStreak == null) {
                    playerStreak = new PlayerStreakInfo(new RGB(0, 0, 0), false);
                    mapStreakInfo.put(player.func_70005_c_(), playerStreak);
                }
                double red = playerStreak.getRgb().getRed();
                double green = playerStreak.getRgb().getGreen();
                double blue = playerStreak.getRgb().getBlue();
                boolean rgb = playerStreak.isRainbow();
                if (rgb) {
                    red = this.red[(int)(player.func_130014_f_().field_73011_w.getWorldTime() % (long)this.red.length)];
                    green = this.green[(int)(player.func_130014_f_().field_73011_w.getWorldTime() % (long)this.red.length)];
                    blue = this.blue[(int)(player.func_130014_f_().field_73011_w.getWorldTime() % (long)this.red.length)];
                }
                Color color = new Color((float)(red / 255.0), (float)(green / 255.0), (float)(blue / 255.0), startAlpha);
                mc.field_71446_o.func_110577_a(texture);
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(infoStart.startU, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * startAlpha)).func_181675_d();
                buffer.func_181662_b(0.0, (double)(0.0f + infoStart.height), 0.0).func_187315_a(infoStart.startU, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * startAlpha)).func_181675_d();
                double endTex = infoEnd.startU - (double)start + (double)i;
                if (endTex > infoStart.startU) {
                    endTex -= 1.0;
                }
                double distX = infoStart.posX - infoEnd.posX;
                double distZ = infoStart.posZ - infoEnd.posZ;
                for (double scales = Math.sqrt(distX * distX + distZ * distZ) / (double)infoStart.height; scales > 1.0; scales -= 1.0) {
                    endTex += 1.0;
                }
                buffer.func_181662_b(nextPosX - grad1, nextPosY - posY + (double)infoEnd.height, nextPosZ - posZ).func_187315_a(endTex, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * endAlpha)).func_181675_d();
                buffer.func_181662_b(nextPosX - grad1, nextPosY - posY, nextPosZ - posZ).func_187315_a(endTex, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * endAlpha)).func_181675_d();
                tessellator.func_78381_a();
                GL11.glEnable((int)2896);
                RenderHelper.func_74519_b();
                GL11.glPopMatrix();
            }
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)2884);
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END && this.isRenderStreak(player = event.player)) {
            ArrayList<StreakLocation> loc = EventSpectralSuitEffect.getPlayerStreakLocationInfo(player);
            StreakLocation oldest = loc.get(0);
            loc.remove(0);
            loc.add(oldest);
            oldest.update(player);
            StreakLocation newest = loc.get(loc.size() - 2);
            double distX = newest.posX - oldest.posX;
            double distZ = newest.posZ - oldest.posZ;
            newest.startU += Math.sqrt(distX * distX + distZ * distZ) / (double)newest.height;
            while (oldest.startU > 1.0) {
                oldest.startU -= 1.0;
            }
        }
    }

    private boolean isRenderStreak(EntityPlayer player) {
        NonNullList armors = player.field_71071_by.field_70460_b;
        return ((ItemStack)armors.get(2)).func_77973_b() == IUItem.spectral_chestplate;
    }

    public static class StreakLocation {
        public double posX;
        public double posY;
        public double posZ;
        public float renderYawOffset;
        public float rotationYawHead;
        public float rotationPitch;
        public float limbSwing;
        public float limbSwingAmount;
        public boolean isSprinting;
        public long lastTick;
        public float height;
        public double startU;

        public StreakLocation(EntityPlayer player) {
            this.update(player);
        }

        public void update(EntityPlayer player) {
            this.posX = player.field_70165_t;
            this.posY = player.func_174813_aQ().field_72338_b;
            this.posZ = player.field_70161_v;
            this.renderYawOffset = player.field_70761_aq;
            this.rotationYawHead = player.field_70759_as;
            this.rotationPitch = player.field_70125_A;
            this.limbSwing = player.field_184619_aG;
            this.limbSwingAmount = player.field_70721_aZ;
            this.isSprinting = player.func_70051_ag();
            this.lastTick = player.field_70170_p.func_72820_D();
            this.height = player.field_70131_O;
        }

        public boolean hasSameCoords(StreakLocation loc) {
            return loc.posX == this.posX && loc.posY == this.posY && loc.posZ == this.posZ && loc.height == this.height;
        }
    }
}

