/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.base;

import com.denfop.api.render.IModelCustom;
import com.denfop.render.base.Vertex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.client.lib.obj.WavefrontObject;

public class WavefrontObject
implements IModelCustom {
    private static final Pattern vertexPattern = Pattern.compile("(v( (\\-) {0,1}\\d+\\.\\d+){3,4} *\\n)|(v( (\\-){0,1}\\d+\\.\\d+){3,4} *$)");
    private static final Pattern vertexNormalPattern = Pattern.compile("(vn( (\\-){0,1}\\d+\\.\\d+){3,4} *\\n)|(vn( (\\-){0,1}\\d+\\.\\d+){3,4} *$)");
    private static final Pattern textureCoordinatePattern = Pattern.compile("(vt( (\\-){0,1}\\d+\\.\\d+){2,3} *\\n)|(vt( (\\-){0,1}\\d+\\.\\d+){2,3} *$)");
    private static final Pattern face_V_VT_VN_Pattern = Pattern.compile("(f( \\d+/\\d+/\\d+){3,4} *\\n)|(f( \\d+/\\d+/\\d+){3,4} *$)");
    private static final Pattern face_V_VT_Pattern = Pattern.compile("(f( \\d+/\\d+){3,4} *\\n)|(f( \\d+/\\d+){3,4} *$)");
    private static final Pattern face_V_VN_Pattern = Pattern.compile("(f( \\d+//\\d+){3,4} *\\n)|(f( \\d+//\\d+){3,4} *$)");
    private static final Pattern face_V_Pattern = Pattern.compile("(f( \\d+){3,4} *\\n)|(f( \\d+){3,4} *$)");
    private static final Pattern groupObjectPattern = Pattern.compile("([go]( [\\w\\d\\.]+) *\\n)|([go]( [\\w\\d\\.]+) *$)");
    private static Matcher vertexMatcher;
    private static Matcher vertexNormalMatcher;
    private static Matcher textureCoordinateMatcher;
    private static Matcher face_V_VT_VN_Matcher;
    private static Matcher face_V_VT_Matcher;
    private static Matcher face_V_VN_Matcher;
    private static Matcher face_V_Matcher;
    private static Matcher groupObjectMatcher;
    private final String fileName;
    public ArrayList<Vertex> vertices = new ArrayList();
    public ArrayList<Vertex> vertexNormals = new ArrayList();
    public ArrayList<TextureCoordinate> textureCoordinates = new ArrayList();
    public ArrayList<GroupObject> groupObjects = new ArrayList();
    private GroupObject currentGroupObject;

    public WavefrontObject(ResourceLocation resource) throws ModelFormatException {
        this.fileName = resource.toString();
        try {
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(resource);
            this.loadObjModel(res.func_110527_b());
        }
        catch (IOException var3) {
            throw new ModelFormatException("IO Exception reading model format", var3);
        }
    }

    private static boolean isValidFaceLine(String line) {
        return WavefrontObject.isValidFace_V_VT_VN_Line(line) || WavefrontObject.isValidFace_V_VT_Line(line) || WavefrontObject.isValidFace_V_VN_Line(line) || WavefrontObject.isValidFace_V_Line(line);
    }

    private static boolean isValidFace_V_VN_Line(String line) {
        if (face_V_VN_Matcher != null) {
            face_V_VN_Matcher.reset();
        }
        face_V_VN_Matcher = face_V_VN_Pattern.matcher(line);
        return face_V_VN_Matcher.matches();
    }

    private static boolean isValidFace_V_Line(String line) {
        if (face_V_Matcher != null) {
            face_V_Matcher.reset();
        }
        face_V_Matcher = face_V_Pattern.matcher(line);
        return face_V_Matcher.matches();
    }

    private static boolean isValidFace_V_VT_Line(String line) {
        if (face_V_VT_Matcher != null) {
            face_V_VT_Matcher.reset();
        }
        face_V_VT_Matcher = face_V_VT_Pattern.matcher(line);
        return face_V_VT_Matcher.matches();
    }

    private static boolean isValidGroupObjectLine(String line) {
        if (groupObjectMatcher != null) {
            groupObjectMatcher.reset();
        }
        groupObjectMatcher = groupObjectPattern.matcher(line);
        return groupObjectMatcher.matches();
    }

    private static boolean isValidVertexLine(String line) {
        if (vertexMatcher != null) {
            vertexMatcher.reset();
        }
        vertexMatcher = vertexPattern.matcher(line);
        return vertexMatcher.matches();
    }

    private static boolean isValidVertexNormalLine(String line) {
        if (vertexNormalMatcher != null) {
            vertexNormalMatcher.reset();
        }
        vertexNormalMatcher = vertexNormalPattern.matcher(line);
        return vertexNormalMatcher.matches();
    }

    private static boolean isValidFace_V_VT_VN_Line(String line) {
        if (face_V_VT_VN_Matcher != null) {
            face_V_VT_VN_Matcher.reset();
        }
        face_V_VT_VN_Matcher = face_V_VT_VN_Pattern.matcher(line);
        return face_V_VT_VN_Matcher.matches();
    }

    private static boolean isValidTextureCoordinateLine(String line) {
        if (textureCoordinateMatcher != null) {
            textureCoordinateMatcher.reset();
        }
        textureCoordinateMatcher = textureCoordinatePattern.matcher(line);
        return textureCoordinateMatcher.matches();
    }

    private void loadObjModel(InputStream inputStream) throws ModelFormatException {
        BufferedReader reader = null;
        int lineCount = 0;
        try {
            String currentLine;
            reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((currentLine = reader.readLine()) != null) {
                Vertex vertex;
                ++lineCount;
                if ((currentLine = currentLine.replaceAll("\\s+", " ").trim()).startsWith("#") || currentLine.length() == 0) continue;
                if (currentLine.startsWith("v ")) {
                    vertex = this.parseVertex(currentLine, lineCount);
                    if (vertex == null) continue;
                    this.vertices.add(vertex);
                    continue;
                }
                if (currentLine.startsWith("vn ")) {
                    vertex = this.parseVertexNormal(currentLine, lineCount);
                    if (vertex == null) continue;
                    this.vertexNormals.add(vertex);
                    continue;
                }
                if (currentLine.startsWith("vt ")) {
                    TextureCoordinate textureCoordinate = this.parseTextureCoordinate(currentLine, lineCount);
                    if (textureCoordinate == null) continue;
                    this.textureCoordinates.add(textureCoordinate);
                    continue;
                }
                if (currentLine.startsWith("f ")) {
                    if (this.currentGroupObject == null) {
                        this.currentGroupObject = new GroupObject("Default");
                    }
                    Face face = this.parseFace(currentLine, lineCount);
                    this.currentGroupObject.faces.add(face);
                    continue;
                }
                if (!(currentLine.startsWith("g ") | currentLine.startsWith("o "))) continue;
                GroupObject group = this.parseGroupObject(currentLine, lineCount);
                if (group != null && this.currentGroupObject != null) {
                    this.groupObjects.add(this.currentGroupObject);
                }
                this.currentGroupObject = group;
            }
            this.groupObjects.add(this.currentGroupObject);
        }
        catch (IOException var16) {
            throw new ModelFormatException("IO Exception reading model format", var16);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Face parseFace(String line, int lineCount) {
        if (WavefrontObject.isValidFaceLine(line)) {
            Face face = new Face();
            String trimmedLine = line.substring(line.indexOf(" ") + 1);
            String[] tokens = trimmedLine.split(" ");
            if (tokens.length == 3) {
                this.currentGroupObject.glDrawingMode = 4;
            } else if (tokens.length == 4) {
                this.currentGroupObject.glDrawingMode = 7;
            }
            if (WavefrontObject.isValidFace_V_VT_VN_Line(line)) {
                face.vertices = new Vertex[tokens.length];
                face.textureCoordinates = new TextureCoordinate[tokens.length];
                face.vertexNormals = new Vertex[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    String[] subTokens = tokens[i].split("/");
                    face.vertices[i] = this.vertices.get(Integer.parseInt(subTokens[0]) - 1);
                    face.textureCoordinates[i] = this.textureCoordinates.get(Integer.parseInt(subTokens[1]) - 1);
                    face.vertexNormals[i] = this.vertexNormals.get(Integer.parseInt(subTokens[2]) - 1);
                }
                face.faceNormal = face.calculateFaceNormal();
            } else if (WavefrontObject.isValidFace_V_VT_Line(line)) {
                face.vertices = new Vertex[tokens.length];
                face.textureCoordinates = new TextureCoordinate[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    String[] subTokens = tokens[i].split("/");
                    face.vertices[i] = this.vertices.get(Integer.parseInt(subTokens[0]) - 1);
                    face.textureCoordinates[i] = this.textureCoordinates.get(Integer.parseInt(subTokens[1]) - 1);
                }
                face.faceNormal = face.calculateFaceNormal();
            } else if (WavefrontObject.isValidFace_V_VN_Line(line)) {
                face.vertices = new Vertex[tokens.length];
                face.vertexNormals = new Vertex[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    String[] subTokens = tokens[i].split("//");
                    face.vertices[i] = this.vertices.get(Integer.parseInt(subTokens[0]) - 1);
                    face.vertexNormals[i] = this.vertexNormals.get(Integer.parseInt(subTokens[1]) - 1);
                }
                face.faceNormal = face.calculateFaceNormal();
            } else {
                if (!WavefrontObject.isValidFace_V_Line(line)) {
                    throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileName + "' - Incorrect format");
                }
                face.vertices = new Vertex[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    face.vertices[i] = this.vertices.get(Integer.parseInt(tokens[i]) - 1);
                }
                face.faceNormal = face.calculateFaceNormal();
            }
            return face;
        }
        throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileName + "' - Incorrect format");
    }

    private GroupObject parseGroupObject(String line, int lineCount) throws WavefrontObject.ModelFormatException {
        GroupObject group = null;
        if (WavefrontObject.isValidGroupObjectLine(line)) {
            String trimmedLine = line.substring(line.indexOf(" ") + 1);
            if (trimmedLine.length() > 0) {
                group = new GroupObject(trimmedLine);
            }
            return group;
        }
        throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileName + "' - Incorrect format");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAll() {
        Tessellator tessellator = Tessellator.func_178181_a();
        if (this.currentGroupObject != null) {
            tessellator.func_178180_c().func_181668_a(this.currentGroupObject.glDrawingMode, DefaultVertexFormats.field_181710_j);
        } else {
            tessellator.func_178180_c().func_181668_a(4, DefaultVertexFormats.field_181710_j);
        }
        this.tessellateAll(tessellator);
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void tessellateAll(Tessellator tessellator) {
        this.groupObjects.forEach(groupObject -> groupObject.render(tessellator));
    }

    private Vertex parseVertex(String line, int lineCount) throws ModelFormatException {
        if (WavefrontObject.isValidVertexLine(line)) {
            line = line.substring(line.indexOf(" ") + 1);
            String[] tokens = line.split(" ");
            try {
                if (tokens.length == 2) {
                    return new Vertex(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]));
                }
                return tokens.length == 3 ? new Vertex(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2])) : null;
            }
            catch (NumberFormatException var6) {
                throw new ModelFormatException(String.format("Number formatting error at line %d", lineCount), var6);
            }
        }
        throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileName + "' - Incorrect format");
    }

    private Vertex parseVertexNormal(String line, int lineCount) throws ModelFormatException {
        if (WavefrontObject.isValidVertexNormalLine(line)) {
            line = line.substring(line.indexOf(" ") + 1);
            String[] tokens = line.split(" ");
            try {
                return tokens.length == 3 ? new Vertex(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2])) : null;
            }
            catch (NumberFormatException var6) {
                throw new ModelFormatException(String.format("Number formatting error at line %d", lineCount), var6);
            }
        }
        throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileName + "' - Incorrect format");
    }

    private TextureCoordinate parseTextureCoordinate(String line, int lineCount) throws ModelFormatException {
        if (WavefrontObject.isValidTextureCoordinateLine(line)) {
            line = line.substring(line.indexOf(" ") + 1);
            String[] tokens = line.split(" ");
            try {
                if (tokens.length == 2) {
                    return new TextureCoordinate(Float.parseFloat(tokens[0]), 1.0f - Float.parseFloat(tokens[1]));
                }
                return tokens.length == 3 ? new TextureCoordinate(Float.parseFloat(tokens[0]), 1.0f - Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2])) : null;
            }
            catch (NumberFormatException var6) {
                throw new ModelFormatException(String.format("Number formatting error at line %d", lineCount), var6);
            }
        }
        throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileName + "' - Incorrect format");
    }

    @Override
    public String getType() {
        return "obj";
    }

    public static class TextureCoordinate {
        public float u;
        public float v;
        public float w;

        public TextureCoordinate(float u, float v) {
            this(u, v, 0.0f);
        }

        public TextureCoordinate(float u, float v, float w) {
            this.u = u;
            this.v = v;
            this.w = w;
        }
    }

    public static class Face {
        public Vertex[] vertices;
        public Vertex[] vertexNormals;
        public Vertex faceNormal;
        public TextureCoordinate[] textureCoordinates;
        private boolean update = false;
        private float averageU;
        private float averageV;

        @SideOnly(value=Side.CLIENT)
        public void addFaceForRender(Tessellator tessellator) {
            this.addFaceForRender(tessellator, 5.0E-4f);
        }

        @SideOnly(value=Side.CLIENT)
        public void addFaceForRender(Tessellator tessellator, float textureOffset) {
            if (this.faceNormal == null) {
                this.faceNormal = this.calculateFaceNormal();
            }
            if (!this.update) {
                this.update = true;
                this.averageU = 0.0f;
                this.averageV = 0.0f;
                if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
                    for (TextureCoordinate textureCoordinate : this.textureCoordinates) {
                        this.averageU += textureCoordinate.u;
                        this.averageV += textureCoordinate.v;
                    }
                    this.averageU /= (float)this.textureCoordinates.length;
                    this.averageV /= (float)this.textureCoordinates.length;
                }
            }
            for (int i = 0; i < this.vertices.length; ++i) {
                if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
                    float offsetU = textureOffset;
                    float offsetV = textureOffset;
                    if (this.textureCoordinates[i].u > this.averageU) {
                        offsetU = -textureOffset;
                    }
                    if (this.textureCoordinates[i].v > this.averageV) {
                        offsetV = -textureOffset;
                    }
                    tessellator.func_178180_c().func_181662_b((double)this.vertices[i].x, (double)this.vertices[i].y, (double)this.vertices[i].z).func_187315_a((double)(this.textureCoordinates[i].u + offsetU), (double)(this.textureCoordinates[i].v + offsetV)).func_181663_c(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z).func_181675_d();
                    continue;
                }
                tessellator.func_178180_c().func_181662_b((double)this.vertices[i].x, (double)this.vertices[i].y, (double)this.vertices[i].z).func_181663_c(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z).func_181675_d();
            }
        }

        public Vertex calculateFaceNormal() {
            Vec3d v1 = new Vec3d((double)(this.vertices[1].x - this.vertices[0].x), (double)(this.vertices[1].y - this.vertices[0].y), (double)(this.vertices[1].z - this.vertices[0].z));
            Vec3d v2 = new Vec3d((double)(this.vertices[2].x - this.vertices[0].x), (double)(this.vertices[2].y - this.vertices[0].y), (double)(this.vertices[2].z - this.vertices[0].z));
            Vec3d normalVector = v1.func_72431_c(v2).func_72432_b();
            return new Vertex((float)normalVector.field_72450_a, (float)normalVector.field_72448_b, (float)normalVector.field_72449_c);
        }
    }

    public static class GroupObject {
        public String name;
        public ArrayList<Face> faces = new ArrayList();
        public int glDrawingMode;

        public GroupObject(String name) {
            this(name, -1);
        }

        public GroupObject(String name, int glDrawingMode) {
            this.name = name;
            this.glDrawingMode = glDrawingMode;
        }

        @SideOnly(value=Side.CLIENT)
        public void render() {
            if (this.faces.size() > 0) {
                Tessellator tessellator = Tessellator.func_178181_a();
                tessellator.func_178180_c().func_181668_a(this.glDrawingMode, DefaultVertexFormats.field_181710_j);
                this.render(tessellator);
                tessellator.func_78381_a();
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void render(Tessellator tessellator) {
            this.faces.forEach(face -> face.addFaceForRender(tessellator));
        }
    }

    public static class ModelFormatException
    extends RuntimeException {
        private static final long serialVersionUID = 2023547503969671835L;

        public ModelFormatException(String message, Throwable cause) {
            super(message, cause);
        }

        public ModelFormatException(String message) {
            super(message);
        }
    }
}

