/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipes;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.blocks.BlockClassicOre;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class ScrapboxRecipeManager {
    public static ScrapboxRecipeManager instance;
    public final List<Drop> drops = new ArrayList<Drop>();

    public ScrapboxRecipeManager() {
        instance = this;
        this.addBuiltinDrops();
    }

    public boolean addRecipe(IInputItemStack input, Collection<ItemStack> output, NBTTagCompound metadata, boolean replace) {
        if (!input.matches(IUItem.scrapBox)) {
            throw new IllegalArgumentException("currently only scrap boxes are supported");
        }
        if (metadata != null && metadata.func_74764_b("weight")) {
            if (output.size() != 1) {
                throw new IllegalArgumentException("currently only a single drop stack is supported");
            }
            float weight = metadata.func_74760_g("weight");
            if (!(weight <= 0.0f || Float.isInfinite(weight) || Float.isNaN(weight))) {
                this.addDrop(output.iterator().next(), weight);
                return true;
            }
            throw new IllegalArgumentException("invalid weight");
        }
        throw new IllegalArgumentException("no weight metadata");
    }

    public boolean addRecipe(IInputItemStack input, NBTTagCompound metadata, boolean replace, ItemStack ... outputs) {
        return this.addRecipe(input, Arrays.asList(outputs), metadata, replace);
    }

    public ItemStack apply(ItemStack input) {
        if (!ModUtils.isEmpty(input) && input.func_77969_a(IUItem.scrapBox)) {
            if (this.drops.isEmpty()) {
                return ItemStack.field_190927_a;
            }
            float chance = IUCore.random.nextFloat() * Drop.topChance;
            int low = 0;
            int high = this.drops.size() - 1;
            while (low < high) {
                int mid = (high + low) / 2;
                if (chance < this.drops.get((int)mid).upperChanceBound) {
                    high = mid;
                    continue;
                }
                low = mid + 1;
            }
            return this.drops.get((int)low).item.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public boolean isIterable() {
        return false;
    }

    public void addDrop(ItemStack drop, float rawChance) {
        this.drops.add(new Drop(drop, rawChance));
    }

    public ItemStack getDrop(ItemStack input) {
        return this.apply(input);
    }

    public Map<ItemStack, Float> getDrops() {
        HashMap<ItemStack, Float> ret = new HashMap<ItemStack, Float>(this.drops.size());
        for (Drop drop : this.drops) {
            ret.put(drop.item, Float.valueOf(drop.originalChance / Drop.topChance));
        }
        return ret;
    }

    private void addBuiltinDrops() {
        this.addDrop(Items.field_151017_I, 5.01f);
        this.addDrop(Blocks.field_150346_d, 5.0f);
        this.addDrop(Items.field_151055_y, 4.0f);
        this.addDrop((Block)Blocks.field_150349_c, 3.0f);
        this.addDrop(Blocks.field_150351_n, 3.0f);
        this.addDrop(Blocks.field_150424_aL, 2.0f);
        this.addDrop(Items.field_151078_bh, 2.0f);
        this.addDrop(Items.field_151034_e, 1.5f);
        this.addDrop(Items.field_151025_P, 1.5f);
        this.addDrop(Items.field_151041_m, 1.0f);
        this.addDrop(Items.field_151038_n, 1.0f);
        this.addDrop(Items.field_151039_o, 1.0f);
        this.addDrop(Blocks.field_150425_aM, 1.0f);
        this.addDrop(Items.field_151155_ap, 1.0f);
        this.addDrop(Items.field_151116_aA, 1.0f);
        this.addDrop(Items.field_151008_G, 1.0f);
        this.addDrop(Items.field_151103_aS, 1.0f);
        this.addDrop(Items.field_151157_am, 0.9f);
        this.addDrop(Items.field_151083_be, 0.9f);
        this.addDrop(Blocks.field_150423_aK, 0.9f);
        this.addDrop(Items.field_151077_bg, 0.9f);
        this.addDrop(Items.field_151143_au, 0.01f);
        this.addDrop(Items.field_151137_ax, 0.9f);
        this.addDrop(IUItem.rubber, 0.8f);
        this.addDrop(Items.field_151114_aO, 0.8f);
        this.addDrop(IUItem.coalDust, 0.8f);
        this.addDrop(IUItem.copperDust, 0.8f);
        this.addDrop(IUItem.tinDust, 0.8f);
        this.addDrop(IUItem.ironDust, 0.7f);
        this.addDrop(IUItem.goldDust, 0.7f);
        this.addDrop(Items.field_151123_aH, 0.6f);
        this.addDrop(Blocks.field_150366_p, 0.5f);
        this.addDrop((Item)Items.field_151169_ag, 0.01f);
        this.addDrop(Blocks.field_150352_o, 0.5f);
        this.addDrop(Items.field_151105_aU, 0.5f);
        this.addDrop(Items.field_151045_i, 0.1f);
        this.addDrop(Items.field_151166_bC, 0.05f);
        this.addDrop(Items.field_151079_bi, 0.08f);
        this.addDrop(Items.field_151072_bj, 0.04f);
        this.addDrop(Items.field_151110_aK, 0.8f);
        this.addDrop(IUItem.classic_ore.getItemStack(BlockClassicOre.Type.copper), 0.7f);
        this.addDrop(IUItem.classic_ore.getItemStack(BlockClassicOre.Type.tin), 0.7f);
    }

    private void addDrop(Block block, float rawChance) {
        this.addDrop(new ItemStack(block), rawChance);
    }

    private void addDrop(Item item, float rawChance) {
        this.addDrop(new ItemStack(item), rawChance);
    }

    private static class Drop {
        static float topChance;
        final ItemStack item;
        final float originalChance;
        final float upperChanceBound;

        Drop(ItemStack item, float chance) {
            this.item = item;
            this.originalChance = chance;
            this.upperChanceBound = topChance += chance;
        }
    }
}

