/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class InputOreDict
implements IInputItemStack {
    public final String input;
    public final int amount;
    public final Integer meta;
    private List<ItemStack> ores;

    InputOreDict(String input) {
        this(input, 1);
    }

    public InputOreDict(String input, int amount) {
        this(input, amount, null);
    }

    InputOreDict(String input, int amount, Integer meta) {
        this.input = input;
        this.amount = amount;
        this.meta = meta;
    }

    @Override
    public boolean matches(ItemStack subject) {
        List<ItemStack> inputs = this.getOres();
        boolean useOreStackMeta = this.meta == null;
        Item subjectItem = subject.func_77973_b();
        int subjectMeta = subject.func_77952_i();
        return inputs.stream().anyMatch(oreStack -> {
            Item oreItem = oreStack.func_77973_b();
            int metaRequired = useOreStackMeta ? oreStack.func_77952_i() : this.meta.intValue();
            return subjectItem == oreItem && (subjectMeta == metaRequired || metaRequired == Short.MAX_VALUE);
        });
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public List<ItemStack> getInputs() {
        List<ItemStack> ores = this.getOres();
        boolean allSuitableEntries = ores.stream().allMatch(stack -> ModUtils.getSize(stack) == this.getAmount());
        if (allSuitableEntries) {
            return ores;
        }
        List ret = ores.stream().filter(stack -> stack.func_77973_b() != ItemStack.field_190927_a.func_77973_b()).map(stack -> ModUtils.getSize(stack) == this.getAmount() ? stack : ModUtils.setSize(stack, this.getAmount())).collect(Collectors.toList());
        return Collections.unmodifiableList(ret);
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            InputOreDict other = (InputOreDict)obj;
            if (this.input.equals(other.input) && other.amount == this.amount) {
                return Objects.equals(this.meta, other.meta);
            }
        }
        return false;
    }

    private List<ItemStack> getOres() {
        if (this.ores != null) {
            return this.ores;
        }
        NonNullList ret = OreDictionary.getOres((String)this.input);
        if (ret != OreDictionary.EMPTY_LIST) {
            this.ores = ret;
        }
        return ret;
    }
}

